/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.state.internals.BlockBasedTableConfigWithAccessibleCache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.RocksDB;

public class BlockBasedTableConfigWithAccessibleCacheTest {
    @Test
    public void shouldReturnNoBlockCacheIfNoneIsSet() {
        BlockBasedTableConfigWithAccessibleCache configWithAccessibleCache = new BlockBasedTableConfigWithAccessibleCache();
        MatcherAssert.assertThat((Object)configWithAccessibleCache.blockCache(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldSetBlockCacheAndMakeItAccessible() {
        BlockBasedTableConfigWithAccessibleCache configWithAccessibleCache = new BlockBasedTableConfigWithAccessibleCache();
        try (LRUCache blockCache = new LRUCache(1024L);){
            BlockBasedTableConfig updatedConfig = configWithAccessibleCache.setBlockCache((Cache)blockCache);
            MatcherAssert.assertThat((Object)updatedConfig, (Matcher)CoreMatchers.sameInstance((Object)configWithAccessibleCache));
            MatcherAssert.assertThat((Object)configWithAccessibleCache.blockCache(), (Matcher)CoreMatchers.sameInstance((Object)blockCache));
        }
    }

    static {
        RocksDB.loadLibrary();
    }
}

