/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ApplicationState;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.KafkaStreamsAssignment;
import org.apache.kafka.streams.processor.assignment.KafkaStreamsState;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.assignment.TaskAssignmentUtils;
import org.apache.kafka.streams.processor.assignment.TaskAssignor;
import org.apache.kafka.streams.processor.assignment.TaskInfo;
import org.apache.kafka.streams.processor.assignment.assignors.StickyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.TaskAssignmentUtilsTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CustomStickyTaskAssignorTest {
    @Rule
    public Timeout timeout = new Timeout(3L, TimeUnit.MINUTES);
    private TaskAssignor assignor;
    @Parameterized.Parameter
    public String rackAwareStrategy;

    @Parameterized.Parameters(name="rackAwareStrategy={0}")
    public static Collection<Object[]> getParamStoreType() {
        return Arrays.asList({"none"}, {"min_traffic"}, {"balance_subtopology"});
    }

    @Before
    public void setUp() {
        this.assignor = new StickyTaskAssignor();
    }

    @Test
    public void shouldAssignOneActiveTaskToEachProcessWhenTaskCountSameAsProcessCount() {
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty())});
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        for (KafkaStreamsAssignment assignment : assignments.values()) {
            MatcherAssert.assertThat((Object)assignment.tasks().size(), (Matcher)Matchers.equalTo((Object)1));
        }
    }

    @Test
    public void shouldAssignTopicGroupIdEvenlyAcrossClientsWithNoStandByTasks() {
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 2, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 2, Optional.empty())});
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_2, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_2, false)});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        this.assertActiveTaskTopicGroupIdsEvenlyDistributed(assignments);
    }

    @Test
    public void shouldAssignTopicGroupIdEvenlyAcrossClientsWithStandByTasks() {
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 2, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 2, Optional.empty())});
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_2, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_2, false)});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 1);
        this.assertActiveTaskTopicGroupIdsEvenlyDistributed(assignments);
    }

    @Test
    public void shouldNotMigrateActiveTaskToOtherProcess() {
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[0]))});
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        this.assertHasAssignment(assignments, 1, AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments, 2, AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        Map streamStates2 = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0]))});
        Map<ProcessId, KafkaStreamsAssignment> assignments2 = this.assign(streamStates2, tasks);
        this.assertHasAssignment(assignments2, 1, AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments2, 2, AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
    }

    @Test
    public void shouldMigrateActiveTasksToNewProcessWithoutChangingAllAssignments() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(1)).tasks().values().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(2)).tasks().values().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(3)).tasks().values().size(), (Matcher)Matchers.equalTo((Object)1));
        this.assertHasAssignment(assignments, 2, AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
    }

    @Test
    public void shouldAssignBasedOnCapacity() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(1)).tasks().values().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(2)).tasks().values().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAssignTasksEvenlyWithUnequalTopicGroupSizes() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_3, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_4, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_5, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5, AssignmentTestUtils.TASK_1_0}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        Set client1Tasks = assignments.get(TaskAssignmentUtilsTest.processId(1)).tasks().values().stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.ACTIVE).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet());
        Set client2Tasks = assignments.get(TaskAssignmentUtilsTest.processId(2)).tasks().values().stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.ACTIVE).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet());
        Set allTasks = tasks.keySet();
        MatcherAssert.assertThat((Object)(client1Tasks.size() == 3 && client2Tasks.size() == 4 || client1Tasks.size() == 4 && client2Tasks.size() == 3 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        allTasks.removeAll(client1Tasks);
        MatcherAssert.assertThat(client2Tasks, (Matcher)Matchers.equalTo(allTasks));
    }

    @Test
    public void shouldKeepActiveTaskStickinessWhenMoreClientThanActiveTasks() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(4, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(5, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(1)).tasks().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(2)).tasks().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(3)).tasks().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(4)).tasks().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(5)).tasks().size(), (Matcher)Matchers.is((Object)0));
        this.assertHasAssignment(assignments, 1, AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments, 2, AssignmentTestUtils.TASK_0_2, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments, 3, AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        Map streamStates2 = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(4, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(5, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[0]))});
        Map<ProcessId, KafkaStreamsAssignment> assignments2 = this.assign(streamStates2, tasks);
        MatcherAssert.assertThat((Object)assignments2.get(TaskAssignmentUtilsTest.processId(1)).tasks().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)assignments2.get(TaskAssignmentUtilsTest.processId(2)).tasks().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)assignments2.get(TaskAssignmentUtilsTest.processId(3)).tasks().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)assignments2.get(TaskAssignmentUtilsTest.processId(4)).tasks().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)assignments2.get(TaskAssignmentUtilsTest.processId(5)).tasks().size(), (Matcher)Matchers.is((Object)1));
        this.assertHasAssignment(assignments2, 3, AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments2, 4, AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments2, 5, AssignmentTestUtils.TASK_0_2, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
    }

    @Test
    public void shouldAssignTasksToClientWithPreviousStandbyTasks() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}))});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        this.assertHasAssignment(assignments, 1, AssignmentTestUtils.TASK_0_2, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments, 2, AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments, 3, AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
    }

    @Test
    public void shouldAssignBasedOnCapacityWhenMultipleClientHaveStandbyTasks() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}))});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(1)).tasks().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)assignments.get(TaskAssignmentUtilsTest.processId(2)).tasks().size(), (Matcher)Matchers.is((Object)2));
        this.assertHasAssignment(assignments, 1, AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments, 2, AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
        this.assertHasAssignment(assignments, 2, AssignmentTestUtils.TASK_0_2, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE);
    }

    @Test
    public void shouldAssignStandbyTasksToDifferentClientThanCorrespondingActiveTaskIsAssignedTo() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_3, true)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(4, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3}), Utils.mkSet((Object[])new TaskId[0]))});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 1);
        MatcherAssert.assertThat((Object)this.standbyTasks(assignments, 1).size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)this.standbyTasks(assignments, 2).size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)this.standbyTasks(assignments, 3).size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)this.standbyTasks(assignments, 4).size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 1), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 2), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 3), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 4), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3})));
        MatcherAssert.assertThat(this.activeTasks(assignments, 1), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}));
        MatcherAssert.assertThat(this.activeTasks(assignments, 2), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}));
        MatcherAssert.assertThat(this.activeTasks(assignments, 3), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}));
        MatcherAssert.assertThat(this.activeTasks(assignments, 4), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3}));
        int nonEmptyStandbyTaskCount = 0;
        for (int i = 1; i <= 4; ++i) {
            nonEmptyStandbyTaskCount += this.standbyTasks(assignments, i).isEmpty() ? 0 : 1;
        }
        MatcherAssert.assertThat((Object)nonEmptyStandbyTaskCount, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
        Set allStandbyTasks = this.allTasks(assignments).stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.STANDBY).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet());
        MatcherAssert.assertThat(allStandbyTasks, (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3})));
    }

    @Test
    public void shouldAssignMultipleReplicasOfStandbyTask() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, true)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[0]))});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 2);
        MatcherAssert.assertThat(this.activeTasks(assignments, 1), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(this.activeTasks(assignments, 2), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(this.activeTasks(assignments, 3), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 1), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 2), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 3), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
    }

    @Test
    public void shouldNotAssignStandbyTaskReplicasWhenNoClientAvailableWithoutHavingTheTaskAssigned() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0]))});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 2);
        MatcherAssert.assertThat(this.activeTasks(assignments, 1), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 1), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new Object[0])));
    }

    @Test
    public void shouldAssignActiveAndStandbyTasks() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, true)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 1);
        List<KafkaStreamsAssignment.AssignedTask> allTasks = this.allTasks(assignments);
        MatcherAssert.assertThat(allTasks.stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.ACTIVE).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet()), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat(allTasks.stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.STANDBY).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet()), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
    }

    @Test
    public void shouldAssignAtLeastOneTaskToEachClientIfPossible() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 3, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        MatcherAssert.assertThat((Object)this.activeTasks(assignments, 1).size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.activeTasks(assignments, 2).size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.activeTasks(assignments, 3).size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void shouldAssignEachActiveTaskToOneClientWhenMoreClientsThanTasks() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(4, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(5, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(6, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        List<KafkaStreamsAssignment.AssignedTask> allTasks = this.allTasks(assignments);
        MatcherAssert.assertThat(allTasks.stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.ACTIVE).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet()), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat(allTasks.stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.STANDBY).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet()), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new Object[0])));
        int clientsWithATask = assignments.values().stream().mapToInt(assignment -> assignment.tasks().isEmpty() ? 0 : 1).sum();
        MatcherAssert.assertThat((Object)clientsWithATask, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
    }

    @Test
    public void shouldBalanceActiveAndStandbyTasksAcrossAvailableClients() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, true)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(4, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(5, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(6, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 1);
        for (KafkaStreamsAssignment assignment : assignments.values()) {
            MatcherAssert.assertThat(assignment.tasks().values(), (Matcher)Matchers.not((Matcher)Matchers.hasSize((int)0)));
        }
    }

    @Test
    public void shouldAssignMoreTasksToClientWithMoreCapacity() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_2, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_2_2, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_3_0, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_3_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_3_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign(streamStates, tasks);
        MatcherAssert.assertThat((Object)this.activeTasks(assignments, 1).size(), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)this.activeTasks(assignments, 2).size(), (Matcher)Matchers.equalTo((Object)8));
    }

    @Test
    public void shouldEvenlyDistributeByTaskIdAndPartition() {
    }

    @Test
    public void shouldNotHaveSameAssignmentOnAnyTwoHosts() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_3, true)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(4, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 1);
        for (KafkaStreamsState client1 : streamStates.values()) {
            for (KafkaStreamsState client2 : streamStates.values()) {
                if (client1.processId().equals((Object)client2.processId())) continue;
                Set assignedTasks1 = assignments.get(client1.processId()).tasks().keySet();
                Set assignedTasks2 = assignments.get(client2.processId()).tasks().keySet();
                MatcherAssert.assertThat((String)"clients shouldn't have same task assignment", assignedTasks1, (Matcher)Matchers.not((Matcher)Matchers.equalTo(assignedTasks2)));
            }
        }
    }

    @Test
    public void shouldNotHaveSameAssignmentOnAnyTwoHostsWhenThereArePreviousActiveTasks() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_3, true)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(4, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 1);
        for (KafkaStreamsState client1 : streamStates.values()) {
            for (KafkaStreamsState client2 : streamStates.values()) {
                if (client1.processId().equals((Object)client2.processId())) continue;
                Set assignedTasks1 = assignments.get(client1.processId()).tasks().keySet();
                Set assignedTasks2 = assignments.get(client2.processId()).tasks().keySet();
                MatcherAssert.assertThat((String)"clients shouldn't have same task assignment", assignedTasks1, (Matcher)Matchers.not((Matcher)Matchers.equalTo(assignedTasks2)));
            }
        }
    }

    @Test
    public void shouldAssignMultipleStandbys() {
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false)});
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(3, 1, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(4, 1, Optional.empty())});
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, 3);
        MatcherAssert.assertThat(this.standbyTasks(assignments, 1), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 2), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 3), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(this.standbyTasks(assignments, 4), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
    }

    @Test
    public void largeAssignmentShouldTerminateWithinAcceptableTime() {
        int topicCount = 10;
        int taskPerTopic = 30;
        int numStandbys = 2;
        int clientCount = 20;
        int clientCapacity = 50;
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[0]);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 30; ++j) {
                TaskId newTaskId = new TaskId(i, j);
                Set partitionRacks = Utils.mkSet((Object[])new String[]{String.format("rack-%d", i * j % 31)});
                Map.Entry<TaskId, TaskInfo> newTask = TaskAssignmentUtilsTest.mkTaskInfo(newTaskId, true, partitionRacks);
                tasks.put(newTask.getKey(), newTask.getValue());
            }
        }
        Map streamStates = Utils.mkMap((Map.Entry[])new Map.Entry[0]);
        for (int i = 0; i < 20; ++i) {
            Map.Entry<ProcessId, KafkaStreamsState> newClient = TaskAssignmentUtilsTest.mkStreamState(i + 1, 50, Optional.of(String.format("rack-%d", i % 31)), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]));
            streamStates.put(newClient.getKey(), newClient.getValue());
        }
        AssignmentConfigs assignmentConfigs = new AssignmentConfigs(0L, 1, 2, 60000L, Collections.emptyList(), OptionalInt.of(1), OptionalInt.of(2), this.rackAwareStrategy);
        Map<ProcessId, KafkaStreamsAssignment> assignments = this.assign((Map<ProcessId, KafkaStreamsState>)streamStates, (Map<TaskId, TaskInfo>)tasks, assignmentConfigs);
        List allActiveTasks = this.allTasks(assignments).stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.ACTIVE).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)allActiveTasks.size(), (Matcher)Matchers.equalTo((Object)300));
        List allStandbyTasks = this.allTasks(assignments).stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.STANDBY).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)allStandbyTasks.size(), (Matcher)Matchers.equalTo((Object)600));
    }

    private Map<ProcessId, KafkaStreamsAssignment> assign(Map<ProcessId, KafkaStreamsState> streamStates, Map<TaskId, TaskInfo> tasks) {
        return this.assign(streamStates, tasks, 0);
    }

    private Map<ProcessId, KafkaStreamsAssignment> assign(Map<ProcessId, KafkaStreamsState> streamStates, Map<TaskId, TaskInfo> tasks, int numStandbys) {
        return this.assign(streamStates, tasks, this.defaultAssignmentConfigs(numStandbys));
    }

    private Map<ProcessId, KafkaStreamsAssignment> assign(Map<ProcessId, KafkaStreamsState> streamStates, Map<TaskId, TaskInfo> tasks, AssignmentConfigs assignmentConfigs) {
        TaskAssignmentUtilsTest.TestApplicationState applicationState = new TaskAssignmentUtilsTest.TestApplicationState(assignmentConfigs, streamStates, tasks);
        TaskAssignor.TaskAssignment taskAssignment = this.assignor.assign((ApplicationState)applicationState);
        TaskAssignor.AssignmentError assignmentError = TaskAssignmentUtils.validateTaskAssignment((ApplicationState)applicationState, (TaskAssignor.TaskAssignment)taskAssignment);
        MatcherAssert.assertThat((Object)assignmentError, (Matcher)Matchers.equalTo((Object)TaskAssignor.AssignmentError.NONE));
        return this.indexAssignment(taskAssignment.assignment());
    }

    public AssignmentConfigs defaultAssignmentConfigs(int numStandbys) {
        return new AssignmentConfigs(0L, 1, numStandbys, 60000L, Collections.emptyList(), OptionalInt.empty(), OptionalInt.empty(), this.rackAwareStrategy);
    }

    private Map<ProcessId, KafkaStreamsAssignment> indexAssignment(Collection<KafkaStreamsAssignment> assignments) {
        return assignments.stream().collect(Collectors.toMap(KafkaStreamsAssignment::processId, assignment -> assignment));
    }

    private Set<TaskId> activeTasks(Map<ProcessId, KafkaStreamsAssignment> assignments, int client) {
        KafkaStreamsAssignment assignment = assignments.getOrDefault(TaskAssignmentUtilsTest.processId(client), null);
        if (assignment == null) {
            return Utils.mkSet((Object[])new TaskId[0]);
        }
        return assignment.tasks().values().stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.ACTIVE).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet());
    }

    private Set<TaskId> standbyTasks(Map<ProcessId, KafkaStreamsAssignment> assignments, int client) {
        KafkaStreamsAssignment assignment = assignments.getOrDefault(TaskAssignmentUtilsTest.processId(client), null);
        if (assignment == null) {
            return Utils.mkSet((Object[])new TaskId[0]);
        }
        return assignment.tasks().values().stream().filter(t -> t.type() == KafkaStreamsAssignment.AssignedTask.Type.STANDBY).map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet());
    }

    private List<KafkaStreamsAssignment.AssignedTask> allTasks(Map<ProcessId, KafkaStreamsAssignment> assignments) {
        ArrayList<KafkaStreamsAssignment.AssignedTask> allTasks = new ArrayList<KafkaStreamsAssignment.AssignedTask>();
        assignments.values().forEach(assignment -> allTasks.addAll(assignment.tasks().values()));
        return allTasks;
    }

    private void assertHasAssignment(Map<ProcessId, KafkaStreamsAssignment> assignments, int client, TaskId taskId, KafkaStreamsAssignment.AssignedTask.Type taskType) {
        KafkaStreamsAssignment assignment = assignments.getOrDefault(TaskAssignmentUtilsTest.processId(client), null);
        MatcherAssert.assertThat((Object)assignment, (Matcher)Matchers.notNullValue());
        KafkaStreamsAssignment.AssignedTask assignedTask = assignment.tasks().getOrDefault(taskId, null);
        MatcherAssert.assertThat((Object)assignedTask, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)assignedTask.id().equals((Object)taskId), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)assignedTask.type().equals((Object)taskType), (Matcher)Matchers.is((Object)true));
    }

    private void assertActiveTaskTopicGroupIdsEvenlyDistributed(Map<ProcessId, KafkaStreamsAssignment> assignments) {
        for (KafkaStreamsAssignment assignment : assignments.values()) {
            ArrayList<Integer> topicGroupIds = new ArrayList<Integer>();
            Set activeTasks = assignment.tasks().values().stream().map(KafkaStreamsAssignment.AssignedTask::id).collect(Collectors.toSet());
            for (TaskId activeTask : activeTasks) {
                topicGroupIds.add(activeTask.subtopology());
            }
            Collections.sort(topicGroupIds);
            MatcherAssert.assertThat(topicGroupIds, (Matcher)Matchers.equalTo(Arrays.asList(1, 2)));
        }
    }
}

