/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.internals.AbstractPartitionGroup;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.streams.processor.internals.SynchronizedPartitionGroup;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class SynchronizedPartitionGroupTest {
    @Mock
    private AbstractPartitionGroup wrapped;
    private SynchronizedPartitionGroup synchronizedPartitionGroup;
    private AutoCloseable closeable;

    @BeforeEach
    public void setUp() {
        this.closeable = MockitoAnnotations.openMocks((Object)this);
        this.synchronizedPartitionGroup = new SynchronizedPartitionGroup(this.wrapped);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.closeable.close();
    }

    @Test
    public void testReadyToProcess() {
        long wallClockTime = 0L;
        Mockito.when((Object)this.wrapped.readyToProcess(0L)).thenReturn((Object)true);
        this.synchronizedPartitionGroup.readyToProcess(0L);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).readyToProcess(0L);
    }

    @Test
    public void testUpdatePartitions() {
        Set<TopicPartition> inputPartitions = Collections.singleton(new TopicPartition("topic", 0));
        Function recordQueueCreator = (Function)Mockito.mock(Function.class);
        this.synchronizedPartitionGroup.updatePartitions(inputPartitions, recordQueueCreator);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).updatePartitions(inputPartitions, recordQueueCreator);
    }

    @Test
    public void testSetPartitionTime() {
        TopicPartition partition = new TopicPartition("topic", 0);
        long partitionTime = 12345678L;
        this.synchronizedPartitionGroup.setPartitionTime(partition, 12345678L);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).setPartitionTime(partition, 12345678L);
    }

    @Test
    public void testNextRecord() {
        AbstractPartitionGroup.RecordInfo info = (AbstractPartitionGroup.RecordInfo)Mockito.mock(AbstractPartitionGroup.RecordInfo.class);
        long wallClockTime = 12345678L;
        StampedRecord stampedRecord = (StampedRecord)Mockito.mock(StampedRecord.class);
        Mockito.when((Object)this.wrapped.nextRecord(info, 12345678L)).thenReturn((Object)stampedRecord);
        StampedRecord result = this.synchronizedPartitionGroup.nextRecord(info, 12345678L);
        Assertions.assertEquals((Object)stampedRecord, (Object)result);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).nextRecord(info, 12345678L);
    }

    @Test
    public void testAddRawRecords() {
        TopicPartition partition = new TopicPartition("topic", 0);
        Iterable rawRecords = (Iterable)Mockito.mock(Iterable.class);
        Mockito.when((Object)this.wrapped.addRawRecords(partition, rawRecords)).thenReturn((Object)1);
        int result = this.synchronizedPartitionGroup.addRawRecords(partition, rawRecords);
        Assertions.assertEquals((int)1, (int)result);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).addRawRecords(partition, rawRecords);
    }

    @Test
    public void testPartitionTimestamp() {
        TopicPartition partition = new TopicPartition("topic", 0);
        long timestamp = 12345678L;
        Mockito.when((Object)this.wrapped.partitionTimestamp(partition)).thenReturn((Object)12345678L);
        long result = this.synchronizedPartitionGroup.partitionTimestamp(partition);
        Assertions.assertEquals((long)12345678L, (long)result);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).partitionTimestamp(partition);
    }

    @Test
    public void testStreamTime() {
        long streamTime = 12345678L;
        Mockito.when((Object)this.wrapped.streamTime()).thenReturn((Object)12345678L);
        long result = this.synchronizedPartitionGroup.streamTime();
        Assertions.assertEquals((long)12345678L, (long)result);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).streamTime();
    }

    @Test
    public void testHeadRecordOffset() {
        TopicPartition partition = new TopicPartition("topic", 0);
        Long recordOffset = 0L;
        Mockito.when((Object)this.wrapped.headRecordOffset(partition)).thenReturn((Object)recordOffset);
        Long result = this.synchronizedPartitionGroup.headRecordOffset(partition);
        Assertions.assertEquals((Long)recordOffset, (Long)result);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).headRecordOffset(partition);
    }

    @Test
    public void testNumBuffered() {
        boolean numBuffered = true;
        Mockito.when((Object)this.wrapped.numBuffered()).thenReturn((Object)1);
        int result = this.synchronizedPartitionGroup.numBuffered();
        Assertions.assertEquals((int)1, (int)result);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).numBuffered();
    }

    @Test
    public void testNumBufferedWithTopicPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean numBuffered = true;
        Mockito.when((Object)this.wrapped.numBuffered(partition)).thenReturn((Object)1);
        int result = this.synchronizedPartitionGroup.numBuffered(partition);
        Assertions.assertEquals((int)1, (int)result);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).numBuffered(partition);
    }

    @Test
    public void testClear() {
        this.synchronizedPartitionGroup.clear();
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testUpdateLags() {
        this.synchronizedPartitionGroup.updateLags();
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).updateLags();
    }

    @Test
    public void testClose() {
        this.synchronizedPartitionGroup.close();
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testPartitions() {
        Set<TopicPartition> partitions = Collections.singleton(new TopicPartition("topic", 0));
        Mockito.when((Object)this.wrapped.partitions()).thenReturn(partitions);
        Set result = this.synchronizedPartitionGroup.partitions();
        Assertions.assertEquals(partitions, (Object)result);
        ((AbstractPartitionGroup)Mockito.verify((Object)this.wrapped, (VerificationMode)Mockito.times((int)1))).partitions();
    }
}

