/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import org.apache.kafka.streams.KeyValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=600L)
public class KeyValueTest {
    @Test
    public void shouldHaveSameEqualsAndHashCode() {
        KeyValue kv = KeyValue.pair((Object)"key1", (Object)1L);
        KeyValue copyOfKV = KeyValue.pair((Object)kv.key, (Object)kv.value);
        Assertions.assertEquals((Object)kv, (Object)kv);
        Assertions.assertEquals((int)kv.hashCode(), (int)kv.hashCode());
        Assertions.assertEquals((Object)kv, (Object)copyOfKV);
        Assertions.assertEquals((int)kv.hashCode(), (int)copyOfKV.hashCode());
        Assertions.assertEquals((int)copyOfKV.hashCode(), (int)kv.hashCode());
        KeyValue copyOfCopyOfKV = KeyValue.pair((Object)copyOfKV.key, (Object)copyOfKV.value);
        Assertions.assertEquals((Object)copyOfKV, (Object)copyOfCopyOfKV);
        Assertions.assertEquals((int)copyOfKV.hashCode(), (int)copyOfCopyOfKV.hashCode());
        Assertions.assertEquals((Object)kv, (Object)copyOfCopyOfKV);
        Assertions.assertEquals((int)kv.hashCode(), (int)copyOfCopyOfKV.hashCode());
        Assertions.assertNotEquals(null, (Object)kv, (String)"must be false for null");
        Assertions.assertNotEquals((Object)kv, (Object)KeyValue.pair(null, (Object)kv.value), (String)"must be false if key is non-null and other key is null");
        Assertions.assertNotEquals((Object)kv, (Object)KeyValue.pair((Object)kv.key, null), (String)"must be false if value is non-null and other value is null");
        KeyValue differentKeyType = KeyValue.pair((Object)1L, (Object)kv.value);
        Assertions.assertNotEquals((Object)kv, (Object)differentKeyType, (String)"must be false for different key types");
        KeyValue differentValueType = KeyValue.pair((Object)kv.key, (Object)"anyString");
        Assertions.assertNotEquals((Object)kv, (Object)differentValueType, (String)"must be false for different value types");
        KeyValue differentKeyValueTypes = KeyValue.pair((Object)1L, (Object)"anyString");
        Assertions.assertNotEquals((Object)kv, (Object)differentKeyValueTypes, (String)"must be false for different key and value types");
        Assertions.assertNotEquals((Object)kv, (Object)new Object(), (String)"must be false for different types of objects");
        KeyValue differentKey = KeyValue.pair((Object)((String)kv.key + "suffix"), (Object)kv.value);
        Assertions.assertNotEquals((Object)kv, (Object)differentKey, (String)"must be false if key is different");
        Assertions.assertNotEquals((Object)differentKey, (Object)kv, (String)"must be false if key is different");
        KeyValue differentValue = KeyValue.pair((Object)kv.key, (Object)((Long)kv.value + 1L));
        Assertions.assertNotEquals((Object)kv, (Object)differentValue, (String)"must be false if value is different");
        Assertions.assertNotEquals((Object)differentValue, (Object)kv, (String)"must be false if value is different");
        KeyValue differentKeyAndValue = KeyValue.pair((Object)((String)kv.key + "suffix"), (Object)((Long)kv.value + 1L));
        Assertions.assertNotEquals((Object)kv, (Object)differentKeyAndValue, (String)"must be false if key and value are different");
        Assertions.assertNotEquals((Object)differentKeyAndValue, (Object)kv, (String)"must be false if key and value are different");
    }
}

