/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableNewProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

class KTableFilter<KIn, VIn>
implements KTableNewProcessorSupplier<KIn, VIn, KIn, VIn> {
    private final KTableImpl<KIn, ?, VIn> parent;
    private final Predicate<? super KIn, ? super VIn> predicate;
    private final boolean filterNot;
    private final String queryableName;
    private boolean sendOldValues;

    KTableFilter(KTableImpl<KIn, ?, VIn> parent, Predicate<? super KIn, ? super VIn> predicate, boolean filterNot, String queryableName) {
        this.parent = parent;
        this.predicate = predicate;
        this.filterNot = filterNot;
        this.queryableName = queryableName;
        this.sendOldValues = parent.enableSendingOldValues(false);
    }

    @Override
    public Processor<KIn, Change<VIn>, KIn, Change<VIn>> get() {
        return new KTableFilterProcessor();
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        if (this.queryableName != null) {
            this.sendOldValues = true;
            return true;
        }
        if (this.parent.enableSendingOldValues(forceMaterialization)) {
            this.sendOldValues = true;
        }
        return this.sendOldValues;
    }

    private VIn computeValue(KIn key, VIn value) {
        VIn newValue = null;
        if (value != null && this.filterNot ^ this.predicate.test(key, value)) {
            newValue = value;
        }
        return newValue;
    }

    private ValueAndTimestamp<VIn> computeValue(KIn key, ValueAndTimestamp<VIn> valueAndTimestamp) {
        VIn value;
        ValueAndTimestamp<VIn> newValueAndTimestamp = null;
        if (valueAndTimestamp != null && this.filterNot ^ this.predicate.test(key, value = valueAndTimestamp.value())) {
            newValueAndTimestamp = valueAndTimestamp;
        }
        return newValueAndTimestamp;
    }

    @Override
    public KTableValueGetterSupplier<KIn, VIn> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<KIn, VIn>(){
            final KTableValueGetterSupplier<KIn, VIn> parentValueGetterSupplier;
            {
                this.parentValueGetterSupplier = KTableFilter.this.parent.valueGetterSupplier();
            }

            @Override
            public KTableValueGetter<KIn, VIn> get() {
                return new KTableFilterValueGetter(this.parentValueGetterSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return this.parentValueGetterSupplier.storeNames();
            }
        };
    }

    private class KTableFilterValueGetter
    implements KTableValueGetter<KIn, VIn> {
        private final KTableValueGetter<KIn, VIn> parentGetter;

        KTableFilterValueGetter(KTableValueGetter<KIn, VIn> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(org.apache.kafka.streams.processor.ProcessorContext context) {
            this.parentGetter.init(context);
        }

        @Override
        public ValueAndTimestamp<VIn> get(KIn key) {
            return KTableFilter.this.computeValue(key, this.parentGetter.get(key));
        }

        @Override
        public void close() {
            this.parentGetter.close();
        }
    }

    private class KTableFilterProcessor
    implements Processor<KIn, Change<VIn>, KIn, Change<VIn>> {
        private ProcessorContext<KIn, Change<VIn>> context;
        private TimestampedKeyValueStore<KIn, VIn> store;
        private TimestampedTupleForwarder<KIn, VIn> tupleForwarder;

        private KTableFilterProcessor() {
        }

        @Override
        public void init(ProcessorContext<KIn, Change<VIn>> context) {
            this.context = context;
            if (KTableFilter.this.queryableName != null) {
                this.store = (TimestampedKeyValueStore)context.getStateStore(KTableFilter.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableFilter.this.sendOldValues);
            }
        }

        @Override
        public void process(Record<KIn, Change<VIn>> record) {
            Object key = record.key();
            Change change = record.value();
            Object newValue = KTableFilter.this.computeValue(key, change.newValue);
            Object oldValue = this.computeOldValue(key, change);
            if (KTableFilter.this.sendOldValues && oldValue == null && newValue == null) {
                return;
            }
            if (KTableFilter.this.queryableName != null) {
                this.store.put(key, ValueAndTimestamp.make(newValue, record.timestamp()));
                this.tupleForwarder.maybeForward(record.withValue(new Change<Object>(newValue, oldValue)));
            } else {
                this.context.forward(record.withValue(new Change<Object>(newValue, oldValue)));
            }
        }

        private VIn computeOldValue(KIn key, Change<VIn> change) {
            if (!KTableFilter.this.sendOldValues) {
                return null;
            }
            return KTableFilter.this.queryableName != null ? ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)this.store.get(key)) : KTableFilter.this.computeValue(key, change.oldValue);
        }
    }
}

