/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.OptionalLong;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.AssignmentsManagerDeadlineFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssignmentsManagerDeadlineFunctionTest {
    private static final ExponentialBackoff BACKOFF = new ExponentialBackoff(1000L, 2, 8000L, 0.0);

    @Test
    public void applyAfterDispatchInterval() {
        Assertions.assertEquals((Object)OptionalLong.of(BACKOFF.initialInterval()), (Object)new AssignmentsManagerDeadlineFunction(BACKOFF, 0L, 0, false, 12).apply(OptionalLong.empty()));
    }

    @Test
    public void applyAfterDispatchIntervalWithExistingEarlierDeadline() {
        Assertions.assertEquals((Object)OptionalLong.of(BACKOFF.initialInterval() / 2L), (Object)new AssignmentsManagerDeadlineFunction(BACKOFF, 0L, 0, false, 12).apply(OptionalLong.of(BACKOFF.initialInterval() / 2L)));
    }

    @Test
    public void applyBackoffInterval() {
        Assertions.assertEquals((Object)OptionalLong.of(BACKOFF.initialInterval() * 2L), (Object)new AssignmentsManagerDeadlineFunction(BACKOFF, 0L, 1, false, 12).apply(OptionalLong.empty()));
    }

    @Test
    public void applyBackoffIntervalWithExistingEarlierDeadline() {
        Assertions.assertEquals((Object)OptionalLong.of(BACKOFF.initialInterval() / 2L), (Object)new AssignmentsManagerDeadlineFunction(BACKOFF, 0L, 1, false, 12).apply(OptionalLong.of(BACKOFF.initialInterval() / 2L)));
    }

    @Test
    public void scheduleImmediatelyWhenOverloaded() {
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)new AssignmentsManagerDeadlineFunction(BACKOFF, 0L, 0, false, 2251).apply(OptionalLong.of(BACKOFF.initialInterval() / 2L)));
    }

    @Test
    public void doNotScheduleImmediatelyWhenOverloadedIfThereAreInFlightRequests() {
        Assertions.assertEquals((Object)OptionalLong.of(BACKOFF.initialInterval()), (Object)new AssignmentsManagerDeadlineFunction(BACKOFF, 0L, 0, true, 2251).apply(OptionalLong.empty()));
    }

    @Test
    public void doNotScheduleImmediatelyWhenOverloadedIfThereArePreviousGlobalFailures() {
        Assertions.assertEquals((Object)OptionalLong.of(BACKOFF.initialInterval() * 2L), (Object)new AssignmentsManagerDeadlineFunction(BACKOFF, 0L, 1, false, 2251).apply(OptionalLong.empty()));
    }
}

