/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.ShareSession;
import org.apache.kafka.server.share.ShareSessionCache;
import org.apache.kafka.server.share.ShareSessionKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShareSessionCacheTest {
    @Test
    public void testShareSessionCache() {
        ShareSessionCache cache = new ShareSessionCache(3, 100L);
        Assertions.assertEquals((int)0, (int)cache.size());
        ShareSessionKey key1 = cache.maybeCreateSession("grp", Uuid.randomUuid(), 0L, this.mockedSharePartitionMap(10));
        ShareSessionKey key2 = cache.maybeCreateSession("grp", Uuid.randomUuid(), 10L, this.mockedSharePartitionMap(20));
        ShareSessionKey key3 = cache.maybeCreateSession("grp", Uuid.randomUuid(), 20L, this.mockedSharePartitionMap(30));
        Assertions.assertNull((Object)cache.maybeCreateSession("grp", Uuid.randomUuid(), 30L, this.mockedSharePartitionMap(40)));
        Assertions.assertNull((Object)cache.maybeCreateSession("grp", Uuid.randomUuid(), 40L, this.mockedSharePartitionMap(5)));
        this.assertShareCacheContains(cache, new ArrayList<ShareSessionKey>(Arrays.asList(key1, key2, key3)));
        cache.touch(cache.get(key1), 200L);
        ShareSessionKey key4 = cache.maybeCreateSession("grp", Uuid.randomUuid(), 210L, this.mockedSharePartitionMap(11));
        this.assertShareCacheContains(cache, new ArrayList<ShareSessionKey>(Arrays.asList(key1, key3, key4)));
        cache.touch(cache.get(key1), 400L);
        cache.touch(cache.get(key3), 390L);
        cache.touch(cache.get(key4), 400L);
        ShareSessionKey key5 = cache.maybeCreateSession("grp", Uuid.randomUuid(), 410L, this.mockedSharePartitionMap(50));
        Assertions.assertNull((Object)key5);
    }

    @Test
    public void testResizeCachedSessions() {
        ShareSessionCache cache = new ShareSessionCache(2, 100L);
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.totalPartitions());
        ShareSessionKey key1 = cache.maybeCreateSession("grp", Uuid.randomUuid(), 0L, this.mockedSharePartitionMap(2));
        Assertions.assertNotNull((Object)key1);
        this.assertShareCacheContains(cache, new ArrayList<ShareSessionKey>(Collections.singletonList(key1)));
        ShareSession session1 = cache.get(key1);
        Assertions.assertEquals((int)2, (int)session1.size());
        Assertions.assertEquals((long)2L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)1, (int)cache.size());
        ShareSessionKey key2 = cache.maybeCreateSession("grp", Uuid.randomUuid(), 0L, this.mockedSharePartitionMap(4));
        Assertions.assertNotNull((Object)key2);
        this.assertShareCacheContains(cache, new ArrayList<ShareSessionKey>(Arrays.asList(key1, key2)));
        ShareSession session2 = cache.get(key2);
        Assertions.assertEquals((long)6L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        ShareSessionKey key3 = cache.maybeCreateSession("grp", Uuid.randomUuid(), 200L, this.mockedSharePartitionMap(5));
        Assertions.assertNull((Object)key3);
        this.assertShareCacheContains(cache, new ArrayList<ShareSessionKey>(Arrays.asList(key1, key2)));
        Assertions.assertEquals((long)6L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        cache.remove(key1);
        this.assertShareCacheContains(cache, new ArrayList<ShareSessionKey>(Collections.singletonList(key2)));
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)4L, (long)cache.totalPartitions());
        Iterator iterator = session2.partitionMap().iterator();
        iterator.next();
        iterator.remove();
        Assertions.assertEquals((int)3, (int)session2.size());
        Assertions.assertEquals((int)4, (int)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assertions.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    private ImplicitLinkedHashCollection<CachedSharePartition> mockedSharePartitionMap(int size) {
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        for (int i = 0; i < size; ++i) {
            cacheMap.add((ImplicitLinkedHashCollection.Element)new CachedSharePartition("test", Uuid.randomUuid(), i, false));
        }
        return cacheMap;
    }

    private void assertShareCacheContains(ShareSessionCache cache, ArrayList<ShareSessionKey> sessionKeys) {
        int i = 0;
        Assertions.assertEquals((int)sessionKeys.size(), (int)cache.size());
        for (ShareSessionKey sessionKey : sessionKeys) {
            Assertions.assertFalse((boolean)cache.get(sessionKey).isEmpty(), (String)("Missing session " + ++i + " out of " + sessionKeys.size() + " ( " + sessionKey + " )"));
        }
    }
}

