/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.LinuxIoMetricsCollector;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class LinuxIoMetricsCollectorTest {
    @Test
    public void testReadProcFile() throws IOException {
        TestDirectory testDirectory = new TestDirectory();
        MockTime time = new MockTime(0L, 100L, 1000L);
        testDirectory.writeProcFile(123L, 456L);
        LinuxIoMetricsCollector collector = new LinuxIoMetricsCollector(testDirectory.baseDir.getAbsolutePath(), (Time)time);
        Assertions.assertTrue((boolean)collector.usable());
        Assertions.assertEquals((long)123L, (long)collector.readBytes());
        Assertions.assertEquals((long)456L, (long)collector.writeBytes());
        testDirectory.writeProcFile(124L, 457L);
        Assertions.assertEquals((long)123L, (long)collector.readBytes());
        Assertions.assertEquals((long)456L, (long)collector.writeBytes());
        time.sleep(1L);
        Assertions.assertEquals((long)124L, (long)collector.readBytes());
        Assertions.assertEquals((long)457L, (long)collector.writeBytes());
    }

    @Test
    public void testUnableToReadNonexistentProcFile() throws IOException {
        TestDirectory testDirectory = new TestDirectory();
        MockTime time = new MockTime(0L, 100L, 1000L);
        LinuxIoMetricsCollector collector = new LinuxIoMetricsCollector(testDirectory.baseDir.getAbsolutePath(), (Time)time);
        Assertions.assertFalse((boolean)collector.usable());
    }

    static class TestDirectory {
        public final File baseDir = TestUtils.tempDirectory();
        private final Path selfDir = Files.createDirectories(this.baseDir.toPath().resolve("self"), new FileAttribute[0]);

        TestDirectory() throws IOException {
        }

        void writeProcFile(long readBytes, long writeBytes) throws IOException {
            String bld = "rchar: 0\nwchar: 0\nsyschr: 0\nsyscw: 0\nread_bytes: " + readBytes + "\nwrite_bytes: " + writeBytes + "\ncancelled_write_bytes: 0\n";
            Files.write(this.selfDir.resolve("io"), bld.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }
}

