/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.metrics.ClientMetricsInstanceMetadata;
import org.apache.kafka.server.metrics.ClientMetricsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientMetricsInstanceMetadataTest {
    @Test
    public void testIsMatchValid() throws UnknownHostException {
        Uuid uuid = Uuid.randomUuid();
        ClientMetricsInstanceMetadata instanceMetadata = new ClientMetricsInstanceMetadata(uuid, ClientMetricsTestUtils.requestContext());
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.emptyMap()));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_id", Pattern.compile(".*"))));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_id", Pattern.compile("producer-1"))));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_id", Pattern.compile("producer.*"))));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_instance_id", Pattern.compile(uuid.toString()))));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_software_name", Pattern.compile("apache-kafka-java"))));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_software_version", Pattern.compile("3.5.2"))));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_source_address", Pattern.compile(InetAddress.getLocalHost().getHostAddress()))));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_source_port", Pattern.compile(String.valueOf(56078)))));
    }

    @Test
    public void testIsMatchMultiplePatternValid() throws UnknownHostException {
        Uuid uuid = Uuid.randomUuid();
        ClientMetricsInstanceMetadata instanceMetadata = new ClientMetricsInstanceMetadata(uuid, ClientMetricsTestUtils.requestContext());
        HashMap<String, Pattern> patternMap = new HashMap<String, Pattern>();
        patternMap.put("client_id", Pattern.compile("producer-1"));
        patternMap.put("client_instance_id", Pattern.compile(uuid.toString()));
        patternMap.put("client_software_name", Pattern.compile("apache-kafka-.*"));
        patternMap.put("client_software_version", Pattern.compile("3.5.2"));
        patternMap.put("client_source_address", Pattern.compile(InetAddress.getLocalHost().getHostAddress()));
        patternMap.put("client_source_port", Pattern.compile(String.valueOf(56078)));
        Assertions.assertTrue((boolean)instanceMetadata.isMatch(patternMap));
    }

    @Test
    public void testIsMatchMismatchFail() throws UnknownHostException {
        Uuid uuid = Uuid.randomUuid();
        ClientMetricsInstanceMetadata instanceMetadata = new ClientMetricsInstanceMetadata(uuid, ClientMetricsTestUtils.requestContext());
        HashMap<String, Pattern> patternMap = new HashMap<String, Pattern>();
        patternMap.put("client_instance_id", Pattern.compile(uuid.toString()));
        patternMap.put("client_software_name", Pattern.compile("apache-kafka-.*"));
        patternMap.put("client_software_version", Pattern.compile("3.5.2"));
        patternMap.put("client_source_address", Pattern.compile(InetAddress.getLocalHost().getHostAddress()));
        patternMap.put("client_id", Pattern.compile("producer-2"));
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(patternMap));
        patternMap.put("client_id", Pattern.compile("producer-1"));
        patternMap.put("client_instance_id", Pattern.compile(uuid + "random"));
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(patternMap));
        patternMap.put("client_instance_id", Pattern.compile(uuid.toString()));
        patternMap.put("client_software_name", Pattern.compile("apache-kafka-java-1"));
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(patternMap));
        patternMap.put("client_software_name", Pattern.compile("apache-kafka-java"));
        patternMap.put("client_software_version", Pattern.compile("3.5.x"));
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(patternMap));
        patternMap.put("client_software_version", Pattern.compile("3.5.2"));
        patternMap.put("client_source_address", Pattern.compile("1.2.3.4"));
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(patternMap));
        patternMap.put("client_source_address", Pattern.compile(InetAddress.getLocalHost().getHostAddress()));
        patternMap.put("client_source_port", Pattern.compile("8080"));
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(patternMap));
    }

    @Test
    public void testIsMatchWithInvalidKeyFail() throws UnknownHostException {
        Uuid uuid = Uuid.randomUuid();
        ClientMetricsInstanceMetadata instanceMetadata = new ClientMetricsInstanceMetadata(uuid, ClientMetricsTestUtils.requestContext());
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(Collections.singletonMap("unknown", Pattern.compile(".*"))));
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(Collections.singletonMap("*", Pattern.compile(".*"))));
    }

    @Test
    public void testIsMatchWithNullValueFail() throws UnknownHostException {
        Uuid uuid = Uuid.randomUuid();
        ClientMetricsInstanceMetadata instanceMetadata = new ClientMetricsInstanceMetadata(uuid, ClientMetricsTestUtils.requestContextWithNullClientInfo());
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_software_name", Pattern.compile(".*"))));
        Assertions.assertFalse((boolean)instanceMetadata.isMatch(Collections.singletonMap("client_software_version", Pattern.compile(".*"))));
    }
}

