/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.network.SocketServerConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SocketServerConfigsTest {
    @Test
    public void testDefaultNameToSecurityProto() {
        HashMap<ListenerName, SecurityProtocol> expected = new HashMap<ListenerName, SecurityProtocol>();
        expected.put(new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
        expected.put(new ListenerName("SSL"), SecurityProtocol.SSL);
        expected.put(new ListenerName("SASL_PLAINTEXT"), SecurityProtocol.SASL_PLAINTEXT);
        expected.put(new ListenerName("SASL_SSL"), SecurityProtocol.SASL_SSL);
        Assertions.assertEquals(expected, (Object)SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO);
    }

    @Test
    public void testListenerListToEndPointsWithEmptyString() {
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)SocketServerConfigs.listenerListToEndPoints((String)"", (Map)SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO));
    }

    @Test
    public void testListenerListToEndPointsWithBlankString() {
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)SocketServerConfigs.listenerListToEndPoints((String)" ", (Map)SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO));
    }

    @Test
    public void testListenerListToEndPointsWithOneEndpoint() {
        Assertions.assertEquals(Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "example.com", 8080)), (Object)SocketServerConfigs.listenerListToEndPoints((String)"PLAINTEXT://example.com:8080", (Map)SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO));
    }

    @Test
    public void testListenerListToEndPointsWithUnderscores() {
        Assertions.assertEquals(Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "example.com", 8080), new Endpoint("SSL", SecurityProtocol.SSL, "local_host", 8081)), (Object)SocketServerConfigs.listenerListToEndPoints((String)"PLAINTEXT://example.com:8080,SSL://local_host:8081", (Map)SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO));
    }

    @Test
    public void testListenerListToEndPointsWithWildcard() {
        Assertions.assertEquals(Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, null, 8080)), (Object)SocketServerConfigs.listenerListToEndPoints((String)"PLAINTEXT://:8080", (Map)SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO));
    }

    @Test
    public void testListenerListToEndPointsWithIpV6() {
        Assertions.assertEquals(Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "::1", 9092)), (Object)SocketServerConfigs.listenerListToEndPoints((String)"PLAINTEXT://[::1]:9092", (Map)SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO));
    }

    @Test
    public void testAnotherListenerListToEndPointsWithIpV6() {
        Assertions.assertEquals(Arrays.asList(new Endpoint("SASL_SSL", SecurityProtocol.SASL_SSL, "fe80::b1da:69ca:57f7:63d8%3", 9092)), (Object)SocketServerConfigs.listenerListToEndPoints((String)"SASL_SSL://[fe80::b1da:69ca:57f7:63d8%3]:9092", (Map)SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO));
    }

    @Test
    public void testAnotherListenerListToEndPointsWithNonDefaultProtoMap() {
        HashMap<ListenerName, SecurityProtocol> map = new HashMap<ListenerName, SecurityProtocol>();
        map.put(new ListenerName("CONTROLLER"), SecurityProtocol.PLAINTEXT);
        Assertions.assertEquals(Arrays.asList(new Endpoint("CONTROLLER", SecurityProtocol.PLAINTEXT, "example.com", 9093)), (Object)SocketServerConfigs.listenerListToEndPoints((String)"CONTROLLER://example.com:9093", map));
    }
}

