/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.interceptor;

import java.net.InetAddress;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkRequestContext;
import org.apache.kafka.server.link.ClusterLinkSourceMetrics;

public class DefaultBrokerInterceptor
implements BrokerInterceptor {
    private final Time time;
    private ClusterLinkSourceMetrics clusterLinkSourceMetrics;
    private boolean clusterLinkMetricReductionAdvancedEnabled;

    public DefaultBrokerInterceptor() {
        this(Time.SYSTEM);
    }

    public DefaultBrokerInterceptor(Time time) {
        this.time = time;
    }

    @Override
    public void onAuthenticatedConnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics, ChannelMetadataRegistry metadataRegistry) {
    }

    @Override
    public void onAuthenticatedDisconnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
    }

    @Override
    public RequestContext newContext(BrokerInterceptor.RequestContextOptions options) {
        return this.newContext(options, true);
    }

    protected RequestContext newContext(BrokerInterceptor.RequestContextOptions options, boolean allowAllClusterLinkRequestTypes) {
        RequestHeader header = options.header();
        if (header.clusterLinkId().isPresent() || this.clusterLinkSourceMetrics != null) {
            header.clusterLinkId().ifPresent(linkId -> {
                if (this.clusterLinkSourceMetrics == null) {
                    this.clusterLinkSourceMetrics = new ClusterLinkSourceMetrics(options.metrics(), (Uuid)linkId, this.clusterLinkMetricReductionAdvancedEnabled, false);
                } else {
                    this.clusterLinkSourceMetrics.ensureLinkId((Uuid)linkId);
                }
            });
            return new ClusterLinkRequestContext(options.header(), options.connectionId(), options.clientAddress(), options.clientPort(), options.principal(), options.listenerName(), options.securityProtocol(), options.clientInformation(), options.sniHostName(), this.time, this.clusterLinkSourceMetrics, options.isPrivilegedListener(), options.principalSerde(), options.authenticationContext(), allowAllClusterLinkRequestTypes, options.isProxyModeLocal(), options.fqdnPropertiesFromPpv2(), options.shouldLogForConnection(), options.confluentMetricsContextProvider());
        }
        return new RequestContext(options.header(), options.connectionId(), options.requestId(), options.clientAddress(), options.clientPort(), options.principal(), options.listenerName(), options.securityProtocol(), options.clientInformation(), options.sniHostName(), options.isPrivilegedListener(), options.principalSerde(), options.authenticationContext(), options.produceConsumeAuditLogTracker(), options.isProxyModeLocal(), options.fqdnPropertiesFromPpv2(), options.shouldLogForConnection(), options.confluentMetricsContextProvider());
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.clusterLinkMetricReductionAdvancedEnabled = ConfluentConfigs.clusterLinkMetricReductionAdvancedEnabled(configs);
    }

    ClusterLinkSourceMetrics clusterLinkSourceMetrics() {
        return this.clusterLinkSourceMetrics;
    }
}

