/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.audit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.server.audit.AuditEventStatus;

public class AuthenticationErrorInfo {
    public static final AuthenticationErrorInfo UNAUTHENTICATED_USER_ERROR = new AuthenticationErrorInfo(AuditEventStatus.UNAUTHENTICATED);
    public static final AuthenticationErrorInfo UNKNOWN_USER_ERROR = new AuthenticationErrorInfo(AuditEventStatus.UNKNOWN_USER_DENIED);
    private final AuditEventStatus auditEventStatus;
    private final String errorMessage;
    private final String identifier;
    private final String clusterId;
    private final String logicalClusterId;
    private Map<String, String> saslExtensions = Collections.emptyMap();
    private Map<String, String> data;

    public AuthenticationErrorInfo(AuditEventStatus auditEventStatus, String errorMessage, String identifier, String clusterId, String logicalClusterId) {
        this.auditEventStatus = Objects.requireNonNull(auditEventStatus);
        this.errorMessage = Objects.toString(errorMessage, "");
        this.identifier = Objects.toString(identifier, "");
        this.clusterId = Objects.toString(clusterId, "");
        this.logicalClusterId = Objects.toString(logicalClusterId, "");
        this.data = new HashMap<String, String>();
    }

    public AuthenticationErrorInfo(AuditEventStatus auditEventStatus, String errorMessage, String identifier, String clusterId) {
        this(auditEventStatus, errorMessage, identifier, clusterId, "");
    }

    public AuthenticationErrorInfo(AuditEventStatus auditEventStatus) {
        this(auditEventStatus, "", "", "");
    }

    public AuditEventStatus auditEventStatus() {
        return this.auditEventStatus;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String identifier() {
        return this.identifier;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    public Map<String, String> saslExtensions() {
        return this.saslExtensions;
    }

    public void saslExtensions(Map<String, String> saslExtensions) {
        this.saslExtensions = Objects.requireNonNull(saslExtensions);
    }

    public String toString() {
        return "AuthenticationErrorInfo{auditEventStatus=" + String.valueOf((Object)this.auditEventStatus) + ", errorMessage='" + this.errorMessage + "', identifier='" + this.identifier + "', clusterId='" + this.clusterId + "', logicalClusterId=" + this.logicalClusterId + "', saslExtensions=" + String.valueOf(this.saslExtensions) + ", data=" + String.valueOf(this.data) + "}";
    }

    public Map<String, String> data() {
        return this.data;
    }

    public void data(String key, String value) {
        this.data.put(key, value);
    }
}

