/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetFetchRequest
extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(OffsetFetchRequest.class);
    public static final short TOP_LEVEL_ERROR_AND_NULL_TOPICS_MIN_VERSION = 2;
    public static final short REQUIRE_STABLE_OFFSET_MIN_VERSION = 7;
    public static final short BATCH_MIN_VERSION = 8;
    public static final short TOPIC_ID_MIN_VERSION = 10;
    private final OffsetFetchRequestData data;

    public String groupId() {
        return this.data.groupId();
    }

    public boolean requireStable() {
        return this.data.requireStable();
    }

    public List<OffsetFetchRequestData.OffsetFetchRequestGroup> groups() {
        if (this.version() >= 8) {
            return this.data.groups();
        }
        OffsetFetchRequestData.OffsetFetchRequestGroup group = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.data.groupId());
        if (this.data.topics() == null) {
            group.setTopics(null);
        } else {
            this.data.topics().forEach(topic -> group.topics().add(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topic.name()).setPartitionIndexes(topic.partitionIndexes())));
        }
        return Collections.singletonList(group);
    }

    private OffsetFetchRequest(OffsetFetchRequestData data, short version) {
        super(ApiKeys.OFFSET_FETCH, version);
        this.data = data;
    }

    @Override
    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        if (this.version() < 2) {
            return new OffsetFetchResponse(new OffsetFetchResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(this.data.topics().stream().map(topic -> new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topic.name()).setPartitions(topic.partitionIndexes().stream().map(partition -> new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex((int)partition).setErrorCode(error.code()).setCommittedOffset(-1L).setMetadata("").setCommittedLeaderEpoch(-1)).collect(Collectors.toList()))).collect(Collectors.toList())), this.version());
        }
        if (this.version() < 8) {
            return new OffsetFetchResponse(new OffsetFetchResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()), this.version());
        }
        return new OffsetFetchResponse(new OffsetFetchResponseData().setThrottleTimeMs(throttleTimeMs).setGroups(this.data.groups().stream().map(group -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group.groupId()).setErrorCode(error.code())).collect(Collectors.toList())), this.version());
    }

    public static OffsetFetchRequest parse(Readable readable, short version, MessageContext context) {
        return new OffsetFetchRequest(new OffsetFetchRequestData(readable, version, context), version);
    }

    public static boolean useTopicIds(short version) {
        return version >= 10;
    }

    @Override
    public OffsetFetchRequestData data() {
        return this.data;
    }

    public static class NoBatchedOffsetFetchRequestException
    extends UnsupportedVersionException {
        private static final long serialVersionUID = 1L;

        public NoBatchedOffsetFetchRequestException(String message) {
            super(message);
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetFetchRequest> {
        private final OffsetFetchRequestData data;
        private final boolean throwOnFetchStableOffsetsUnsupported;

        public static Builder forTopicIdsOrNames(OffsetFetchRequestData data, boolean throwOnFetchStableOffsetsUnsupported, boolean enableUnstableLastVersion) {
            return new Builder(data, throwOnFetchStableOffsetsUnsupported, ApiKeys.OFFSET_FETCH.oldestVersion(), ApiKeys.OFFSET_FETCH.latestVersion(enableUnstableLastVersion));
        }

        public static Builder forTopicNames(OffsetFetchRequestData data, boolean throwOnFetchStableOffsetsUnsupported) {
            return new Builder(data, throwOnFetchStableOffsetsUnsupported, ApiKeys.OFFSET_FETCH.oldestVersion(), 9);
        }

        private Builder(OffsetFetchRequestData data, boolean throwOnFetchStableOffsetsUnsupported, short oldestAllowedVersion, short latestAllowedVersion) {
            super(ApiKeys.OFFSET_FETCH, oldestAllowedVersion, latestAllowedVersion);
            this.data = data;
            this.throwOnFetchStableOffsetsUnsupported = throwOnFetchStableOffsetsUnsupported;
        }

        private void throwIfBatchingIsUnsupported(short version) {
            if (this.data.groups().size() > 1 && version < 8) {
                throw new NoBatchedOffsetFetchRequestException("Broker does not support batching groups for fetch offset request on version " + version);
            }
        }

        private void throwIfStableOffsetsUnsupported(short version) {
            if (this.data.requireStable() && version < 7) {
                if (this.throwOnFetchStableOffsetsUnsupported) {
                    throw new UnsupportedVersionException("Broker unexpectedly doesn't support requireStable flag on version " + version);
                }
                log.trace("Fallback the requireStable flag to false as broker only supports OffsetFetchRequest version {}. Need v7 or newer to enable this feature", (Object)version);
                this.data.setRequireStable(false);
            }
        }

        private void throwIfMissingRequiredTopicIdentifiers(short version) {
            if (version < 10) {
                this.data.groups().forEach(group -> {
                    if (group.topics() != null) {
                        group.topics().forEach(topic -> {
                            if (topic.name() == null || topic.name().isEmpty()) {
                                throw new UnsupportedVersionException("The broker offset fetch api version " + version + " does require usage of topic names.");
                            }
                        });
                    }
                });
            } else {
                this.data.groups().forEach(group -> {
                    if (group.topics() != null) {
                        group.topics().forEach(topic -> {
                            if (topic.topicId() == null || topic.topicId().equals(Uuid.ZERO_UUID)) {
                                throw new UnsupportedVersionException("The broker offset fetch api version " + version + " does require usage of topic ids.");
                            }
                        });
                    }
                });
            }
        }

        private void throwIfRequestingAllTopicsIsUnsupported(short version) {
            if (version < 2) {
                this.data.groups().forEach(group -> {
                    if (group.topics() == null) {
                        throw new UnsupportedVersionException("The broker only supports OffsetFetchRequest v" + version + ", but we need v2 or newer to request all topic partitions.");
                    }
                });
            }
        }

        private OffsetFetchRequestData maybeDowngrade(short version) {
            if (version >= 8 || this.data.groups().isEmpty()) {
                return this.data;
            }
            OffsetFetchRequestData.OffsetFetchRequestGroup group = this.data.groups().get(0);
            String groupName = group.groupId();
            List<OffsetFetchRequestData.OffsetFetchRequestTopics> topics = group.topics();
            List oldFormatTopics = null;
            if (topics != null) {
                oldFormatTopics = topics.stream().map(t -> new OffsetFetchRequestData.OffsetFetchRequestTopic().setName(t.name()).setPartitionIndexes(t.partitionIndexes())).collect(Collectors.toList());
            }
            return new OffsetFetchRequestData().setGroupId(groupName).setTopics(oldFormatTopics).setRequireStable(this.data.requireStable());
        }

        @Override
        public OffsetFetchRequest build(short version) {
            this.throwIfBatchingIsUnsupported(version);
            this.throwIfStableOffsetsUnsupported(version);
            this.throwIfMissingRequiredTopicIdentifiers(version);
            this.throwIfRequestingAllTopicsIsUnsupported(version);
            return new OffsetFetchRequest(this.maybeDowngrade(version), version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

