/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeTransactionsResponse
extends AbstractResponse {
    private final DescribeTransactionsResponseData data;

    public DescribeTransactionsResponse(DescribeTransactionsResponseData data) {
        super(ApiKeys.DESCRIBE_TRANSACTIONS);
        this.data = data;
    }

    @Override
    public DescribeTransactionsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        for (DescribeTransactionsResponseData.TransactionState transactionState : this.data.transactionStates()) {
            Errors error = Errors.forCode(transactionState.errorCode());
            DescribeTransactionsResponse.updateErrorCounts(errorCounts, error);
        }
        return errorCounts;
    }

    public static DescribeTransactionsResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeTransactionsResponse(new DescribeTransactionsResponseData(readable, version, context));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }
}

