/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Utils;

public class DescribeGroupsResponse
extends AbstractResponse {
    public static final int AUTHORIZED_OPERATIONS_OMITTED = Integer.MIN_VALUE;
    private final DescribeGroupsResponseData data;
    public static final String UNKNOWN_STATE = "";
    public static final String UNKNOWN_PROTOCOL_TYPE = "";
    public static final String UNKNOWN_PROTOCOL = "";

    public DescribeGroupsResponse(DescribeGroupsResponseData data) {
        super(ApiKeys.DESCRIBE_GROUPS);
        this.data = data;
    }

    public static DescribeGroupsResponseData.DescribedGroupMember groupMember(String memberId, String groupInstanceId, String clientId, String clientHost, byte[] assignment, byte[] metadata) {
        return new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(memberId).setGroupInstanceId(groupInstanceId).setClientId(clientId).setClientHost(clientHost).setMemberAssignment(assignment).setMemberMetadata(metadata);
    }

    public static DescribeGroupsResponseData.DescribedGroup groupMetadata(String groupId, Errors error, String state, String protocolType, String protocol, List<DescribeGroupsResponseData.DescribedGroupMember> members, Set<Byte> authorizedOperations) {
        DescribeGroupsResponseData.DescribedGroup groupMetadata = new DescribeGroupsResponseData.DescribedGroup();
        groupMetadata.setGroupId(groupId).setErrorCode(error.code()).setGroupState(state).setProtocolType(protocolType).setProtocolData(protocol).setMembers(members).setAuthorizedOperations(Utils.to32BitField(authorizedOperations));
        return groupMetadata;
    }

    public static DescribeGroupsResponseData.DescribedGroup groupMetadata(String groupId, Errors error, String state, String protocolType, String protocol, List<DescribeGroupsResponseData.DescribedGroupMember> members, int authorizedOperations) {
        return new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(error.code()).setGroupState(state).setProtocolType(protocolType).setProtocolData(protocol).setMembers(members).setAuthorizedOperations(authorizedOperations);
    }

    public static DescribeGroupsResponseData.DescribedGroup groupError(String groupId, Errors error) {
        return DescribeGroupsResponse.groupMetadata(groupId, error, "", "", "", Collections.emptyList(), Integer.MIN_VALUE);
    }

    public static DescribeGroupsResponseData.DescribedGroup groupError(String groupId, Errors error, String errorMessage) {
        return new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState("").setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    @Override
    public DescribeGroupsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.groups().forEach(describedGroup -> DescribeGroupsResponse.updateErrorCounts(errorCounts, Errors.forCode(describedGroup.errorCode())));
        return errorCounts;
    }

    public static DescribeGroupsResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeGroupsResponse(new DescribeGroupsResponseData(readable, version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }
}

