/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.replica.ReplicaStatus;

public class ClusterLinkDescription {
    private final String linkName;
    private final Uuid linkId;
    private final String remoteClusterId;
    private final String localClusterId;
    private final Collection<String> topics;
    private final LinkState linkState;
    private final LinkMode linkMode;
    private final ConnectionMode connectionMode;
    private final ClusterLinkError clusterLinkError;
    private final String linkErrorMessage;
    private final int linkCoordinatorId;
    private final String linkCoordinatorHost;
    private final int linkCoordinatorPort;
    private final LinkState remoteLinkState;
    private final ClusterLinkError remoteLinkError;
    private final String remoteLinkErrorMessage;
    private final long remoteLinkStateTimeMs;
    private final List<ClusterLinkTaskDescription> taskDescriptions;
    private final Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> partitionStateCategoryCounts;
    private final int linkCoordinatorPartitionId;

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage, Node linkCoordinator) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, clusterLinkError, linkErrorMessage, Objects.requireNonNull(linkCoordinator).id(), Objects.requireNonNull(linkCoordinator).host(), Objects.requireNonNull(linkCoordinator).port());
    }

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, clusterLinkError, linkErrorMessage, Node.noNode());
    }

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage, int linkCoordinatorId, String linkCoordinatorHost, int linkCoordinatorPort) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, clusterLinkError, linkErrorMessage, linkCoordinatorId, linkCoordinatorHost, linkCoordinatorPort, LinkState.UNKNOWN, ClusterLinkError.NO_ERROR, null, -1L);
    }

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage, int linkCoordinatorId, String linkCoordinatorHost, int linkCoordinatorPort, LinkState remoteLinkState, ClusterLinkError remoteLinkError, String remoteLinkErrorMessage, long remoteLinkStateTimeMs) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, clusterLinkError, linkErrorMessage, new Node(linkCoordinatorId, linkCoordinatorHost, linkCoordinatorPort), remoteLinkState, remoteLinkError, remoteLinkErrorMessage, remoteLinkStateTimeMs, Collections.emptyList(), Collections.emptyMap(), -1);
    }

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage, int linkCoordinatorId, String linkCoordinatorHost, int linkCoordinatorPort, LinkState remoteLinkState, ClusterLinkError remoteLinkError, String remoteLinkErrorMessage, long remoteLinkStateTimeMs, int linkCoordinatorPartitionId) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, clusterLinkError, linkErrorMessage, new Node(linkCoordinatorId, linkCoordinatorHost, linkCoordinatorPort), remoteLinkState, remoteLinkError, remoteLinkErrorMessage, remoteLinkStateTimeMs, Collections.emptyList(), Collections.emptyMap(), linkCoordinatorPartitionId);
    }

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage, List<ClusterLinkTaskDescription> taskDescriptions, Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> partitionStateCategoryCounts) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, clusterLinkError, linkErrorMessage, new Node(Objects.requireNonNull(Node.noNode()).id(), Objects.requireNonNull(Node.noNode()).host(), Objects.requireNonNull(Node.noNode()).port()), LinkState.UNKNOWN, ClusterLinkError.NO_ERROR, null, -1L, taskDescriptions, partitionStateCategoryCounts, -1);
    }

    private ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage, Node linkCoordinator, LinkState remoteLinkState, ClusterLinkError remoteLinkError, String remoteLinkErrorMessage, long remoteLinkStateTimeMs, List<ClusterLinkTaskDescription> taskDescriptions, Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> partitionStateCategoryCounts, int linkCoordinatorPartitionId) {
        this.linkName = Objects.requireNonNull(linkName, "linkName");
        this.linkId = Objects.requireNonNull(linkId, "linkId");
        this.remoteClusterId = remoteClusterId;
        this.localClusterId = localClusterId;
        this.topics = topics;
        this.linkState = linkState;
        this.linkMode = linkMode;
        this.connectionMode = connectionMode;
        this.clusterLinkError = clusterLinkError;
        this.linkErrorMessage = linkErrorMessage;
        this.linkCoordinatorId = Objects.requireNonNull(linkCoordinator).id();
        this.linkCoordinatorHost = Objects.requireNonNull(linkCoordinator).host();
        this.linkCoordinatorPort = Objects.requireNonNull(linkCoordinator).port();
        this.remoteLinkState = remoteLinkState;
        this.remoteLinkError = remoteLinkError;
        this.remoteLinkErrorMessage = remoteLinkErrorMessage;
        this.remoteLinkStateTimeMs = remoteLinkStateTimeMs;
        this.taskDescriptions = Objects.requireNonNull(taskDescriptions);
        this.partitionStateCategoryCounts = partitionStateCategoryCounts;
        this.linkCoordinatorPartitionId = linkCoordinatorPartitionId;
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid clusterLinkId() {
        return this.linkId;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public Optional<Collection<String>> topics() {
        return Optional.ofNullable(this.topics);
    }

    public LinkState linkState() {
        return this.linkState;
    }

    public LinkMode linkMode() {
        return this.linkMode;
    }

    public ConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public ClusterLinkError clusterLinkError() {
        return this.clusterLinkError;
    }

    public String linkErrorMessage() {
        return this.linkErrorMessage;
    }

    public int linkCoordinatorId() {
        return this.linkCoordinatorId;
    }

    public String linkCoordinatorHost() {
        return this.linkCoordinatorHost;
    }

    public int linkCoordinatorPort() {
        return this.linkCoordinatorPort;
    }

    public LinkState remoteLinkState() {
        return this.remoteLinkState;
    }

    public ClusterLinkError remoteLinkError() {
        return this.remoteLinkError;
    }

    public String remoteLinkErrorMessage() {
        return this.remoteLinkErrorMessage;
    }

    public long remoteLinkStateTimeMs() {
        return this.remoteLinkStateTimeMs;
    }

    public List<ClusterLinkTaskDescription> taskDescriptions() {
        return this.taskDescriptions;
    }

    public Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> partitionStateCategoryCounts() {
        return this.partitionStateCategoryCounts;
    }

    public int linkCoordinatorPartitionId() {
        return this.linkCoordinatorPartitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterLinkDescription that = (ClusterLinkDescription)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.remoteClusterId, that.remoteClusterId) && Objects.equals(this.localClusterId, that.localClusterId) && Objects.equals(this.topics, that.topics) && Objects.equals((Object)this.linkState, (Object)that.linkState) && Objects.equals((Object)this.linkMode, (Object)that.linkMode) && Objects.equals((Object)this.connectionMode, (Object)that.connectionMode) && Objects.equals((Object)this.clusterLinkError, (Object)that.clusterLinkError) && Objects.equals(this.linkErrorMessage, that.linkErrorMessage) && Objects.equals(this.linkCoordinatorId, that.linkCoordinatorId) && Objects.equals(this.linkCoordinatorHost, that.linkCoordinatorHost) && Objects.equals(this.linkCoordinatorPort, that.linkCoordinatorPort) && Objects.equals((Object)this.remoteLinkState, (Object)that.remoteLinkState) && Objects.equals((Object)this.remoteLinkError, (Object)that.remoteLinkError) && Objects.equals(this.remoteLinkErrorMessage, that.remoteLinkErrorMessage) && Objects.equals(this.remoteLinkStateTimeMs, that.remoteLinkStateTimeMs) && Objects.equals(this.taskDescriptions, that.taskDescriptions) && Objects.equals(this.partitionStateCategoryCounts, that.partitionStateCategoryCounts) && Objects.equals(this.linkCoordinatorPartitionId, that.linkCoordinatorPartitionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linkName, this.linkId, this.remoteClusterId, this.localClusterId, this.topics, this.linkState, this.linkMode, this.connectionMode, this.clusterLinkError, this.linkErrorMessage, this.linkCoordinatorId, this.linkCoordinatorHost, this.linkCoordinatorPort, this.remoteLinkState, this.remoteLinkError, this.remoteLinkErrorMessage, this.remoteLinkStateTimeMs, this.taskDescriptions, this.partitionStateCategoryCounts, this.linkCoordinatorPartitionId});
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ClusterLinkDescription(linkName=").append(this.linkName).append(", linkId=").append(this.linkId).append(", remoteClusterId=").append(this.remoteClusterId).append(", localClusterId=").append(this.localClusterId).append(", linkState=").append((Object)this.linkState).append(", linkMode=").append((Object)this.linkMode).append(", connectionMode=").append((Object)this.connectionMode).append(", topics=").append(this.topics).append(", clusterLinkError=").append((Object)this.clusterLinkError).append(", linkErrorMessage=").append(this.linkErrorMessage).append(", linkCoordinatorId=").append(this.linkCoordinatorId).append(", linkCoordinatorHost=").append(this.linkCoordinatorHost).append(", linkCoordinatorPort=").append(this.linkCoordinatorPort).append(", remoteLinkState=").append((Object)this.remoteLinkState).append(", remoteLinkError=").append((Object)this.remoteLinkError).append(", remoteLinkErrorMessage=").append(this.remoteLinkErrorMessage).append(", remoteLinkStateTimeMs=").append(this.remoteLinkStateTimeMs).append(", taskDescriptions=").append(this.taskDescriptions).append(", partitionStateCategoryCounts=").append(this.partitionStateCategoryCounts).append(", linkCoordinatorPartitionId=").append(this.linkCoordinatorPartitionId).append(")");
        return str.toString();
    }

    public static enum LinkState {
        UNKNOWN(-1, false),
        ACTIVE(0, true),
        FAILED(1, false),
        UNAVAILABLE(2, false),
        PAUSED(3, true),
        UNMANAGED_SOURCE(4, true),
        REMOTE_LINK_NOT_FOUND(5, false);

        private short value;
        private boolean available;

        private LinkState(int value, boolean available) {
            this.value = (short)value;
            this.available = available;
        }

        public short getValue() {
            return this.value;
        }

        public static LinkState fromShort(short x) {
            switch (x) {
                case -1: {
                    return UNKNOWN;
                }
                case 0: {
                    return ACTIVE;
                }
                case 1: {
                    return FAILED;
                }
                case 2: {
                    return UNAVAILABLE;
                }
                case 3: {
                    return PAUSED;
                }
                case 4: {
                    return UNMANAGED_SOURCE;
                }
                case 5: {
                    return REMOTE_LINK_NOT_FOUND;
                }
            }
            return UNKNOWN;
        }

        public boolean available() {
            LinkState state = LinkState.fromShort(this.value);
            return state.available;
        }
    }

    public static enum LinkMode {
        UNKNOWN(0),
        DESTINATION(1),
        SOURCE(2),
        BIDIRECTIONAL(3);

        private short value;

        private LinkMode(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static LinkMode fromShort(short x) {
            switch (x) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return DESTINATION;
                }
                case 2: {
                    return SOURCE;
                }
                case 3: {
                    return BIDIRECTIONAL;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum ConnectionMode {
        UNKNOWN(0),
        INBOUND(1),
        OUTBOUND(2);

        private short value;

        private ConnectionMode(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static ConnectionMode fromShort(short x) {
            switch (x) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return INBOUND;
                }
                case 2: {
                    return OUTBOUND;
                }
            }
            return UNKNOWN;
        }
    }

    public static class Builder {
        private String linkName;
        private Uuid linkId;
        private String remoteClusterId;
        private String localClusterId;
        private Collection<String> topics;
        private LinkState linkState = LinkState.UNKNOWN;
        private LinkMode linkMode;
        private ConnectionMode connectionMode;
        private ClusterLinkError clusterLinkError = ClusterLinkError.NO_ERROR;
        private String linkErrorMessage = null;
        private Node linkCoordinator = Node.noNode();
        private LinkState remoteLinkState = LinkState.UNKNOWN;
        private ClusterLinkError remoteLinkError = ClusterLinkError.NO_ERROR;
        private String remoteLinkErrorMessage = null;
        private long remoteLinkStateTimeMs = -1L;
        private List<ClusterLinkTaskDescription> taskDescriptions = Collections.emptyList();
        private Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> partitionStateCategoryCounts = Collections.emptyMap();
        private int linkCoordinatorPartitionId;

        public Builder setLinkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public Builder setLinkId(Uuid linkId) {
            this.linkId = linkId;
            return this;
        }

        public Builder setRemoteClusterId(String remoteClusterId) {
            this.remoteClusterId = remoteClusterId;
            return this;
        }

        public Builder setLocalClusterId(String localClusterId) {
            this.localClusterId = localClusterId;
            return this;
        }

        public Builder setTopics(Collection<String> topics) {
            this.topics = topics;
            return this;
        }

        public Builder setLinkState(LinkState linkState) {
            this.linkState = linkState;
            return this;
        }

        public Builder setLinkMode(LinkMode linkMode) {
            this.linkMode = linkMode;
            return this;
        }

        public Builder setConnectionMode(ConnectionMode connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        public Builder setClusterLinkError(ClusterLinkError clusterLinkError) {
            this.clusterLinkError = clusterLinkError;
            return this;
        }

        public Builder setLinkErrorMessage(String linkErrorMessage) {
            this.linkErrorMessage = linkErrorMessage;
            return this;
        }

        public Builder setRemoteLinkState(LinkState remoteLinkState) {
            this.remoteLinkState = remoteLinkState;
            return this;
        }

        public Builder setRemoteLinkError(ClusterLinkError remoteLinkError) {
            this.remoteLinkError = remoteLinkError;
            return this;
        }

        public Builder setRemoteLinkErrorMessage(String remoteLinkErrorMessage) {
            this.remoteLinkErrorMessage = remoteLinkErrorMessage;
            return this;
        }

        public Builder setRemoteLinkStateTimeMs(long remoteLinkStateTimeMs) {
            this.remoteLinkStateTimeMs = remoteLinkStateTimeMs;
            return this;
        }

        public Builder setTaskDescriptions(List<ClusterLinkTaskDescription> taskDescriptions) {
            this.taskDescriptions = taskDescriptions;
            return this;
        }

        public Builder setLinkCoordinator(Node linkCoordinator) {
            this.linkCoordinator = linkCoordinator;
            return this;
        }

        public Builder setPartitionStateCategoryCounts(Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> partitionStateCategoryCounts) {
            this.partitionStateCategoryCounts = partitionStateCategoryCounts;
            return this;
        }

        public Builder setLinkCoordinatorPartitionId(int linkCoordinatorPartitionId) {
            this.linkCoordinatorPartitionId = linkCoordinatorPartitionId;
            return this;
        }

        public ClusterLinkDescription build() {
            return new ClusterLinkDescription(this.linkName, this.linkId, this.remoteClusterId, this.localClusterId, this.topics, this.linkState, this.linkMode, this.connectionMode, this.clusterLinkError, this.linkErrorMessage, this.linkCoordinator, this.remoteLinkState, this.remoteLinkError, this.remoteLinkErrorMessage, this.remoteLinkStateTimeMs, this.taskDescriptions, this.partitionStateCategoryCounts, this.linkCoordinatorPartitionId);
        }
    }
}

