/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.utils.MetricUtils;

public class ApiSensors {
    public static final int BASE_HEADER_SIZE = new RequestHeader(ApiKeys.PRODUCE, 0, "", 0).size(new ObjectSerializationCache());
    private final Sensor requestRate;
    private final Sensor requestByteRate;
    public final Sensor responseByteRate;
    private final Sensor responseTime;
    private final EnumMap<Errors, Sensor> errorRates;

    public ApiSensors(Sensor requestRate, Sensor requestByteRate, Sensor responseByteRate, Sensor responseTime) {
        this.requestRate = requestRate;
        this.requestByteRate = requestByteRate;
        this.responseByteRate = responseByteRate;
        this.responseTime = responseTime;
        this.errorRates = new EnumMap(Errors.class);
    }

    public void recordRequest(long requestSize, long currentTimeMs) {
        this.requestRate.record(1.0, currentTimeMs, false);
        this.requestByteRate.record(requestSize, currentTimeMs, false);
    }

    public void recordResponse(long responseSize, long responseTimeNanos, long currentTimeMs) {
        this.responseByteRate.record(responseSize, currentTimeMs, false);
        this.responseTime.record(responseTimeNanos, currentTimeMs, false);
    }

    public void recordErrors(Map<Errors, Integer> errorCounts, long currentTimeMs) {
        for (Map.Entry<Errors, Integer> entry : errorCounts.entrySet()) {
            this.errorRates.get((Object)entry.getKey()).record((double)entry.getValue().intValue(), currentTimeMs);
        }
    }

    public Set<Errors> errorsWithoutSensors(Metrics metrics, Set<Errors> errors) {
        return errors.stream().filter(error -> !this.errorRates.containsKey(error) || ApiSensors.isExpired(metrics, this.errorRates.get(error))).collect(Collectors.toSet());
    }

    public void addErrorSensors(Map<Errors, Sensor> errorSensors) {
        this.errorRates.putAll(errorSensors);
    }

    public boolean requestSensorsExpired(Metrics metrics) {
        return ApiSensors.isExpired(metrics, this.requestRate) || ApiSensors.isExpired(metrics, this.requestByteRate);
    }

    public boolean responseSensorsExpired(Metrics metrics) {
        return ApiSensors.isExpired(metrics, this.responseByteRate) || ApiSensors.isExpired(metrics, this.responseTime);
    }

    public static boolean isExpired(Metrics metrics, Sensor sensor) {
        return MetricUtils.isExpired(metrics, sensor);
    }

    public static int calculateRequestSize(RequestHeader header, Readable readable) {
        return 4 + BASE_HEADER_SIZE + (header.clientId() == null ? 0 : Utils.utf8Length(header.clientId())) + readable.remaining();
    }

    public static int calculateRequestSize(RequestHeader header, ByteBuffer buffer) {
        return ApiSensors.calculateRequestSize(header, new ByteBufferAccessor(buffer));
    }

    public Sensor responseByteSensor() {
        return this.responseByteRate;
    }
}

