/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.link;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.link.ClusterLinkMetricsUtils;
import org.apache.kafka.server.metrics.ApiSensorBuilder;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLinkSourceMetrics {
    public static final String SOURCE_METRICS_GROUP = "cluster-link-source-metrics";
    public static final long SOURCE_LINK_EXPIRY_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private static final Logger log = LoggerFactory.getLogger(ClusterLinkSourceMetrics.class);
    private final EnumMap<ApiKeys, ApiSensors> apiSensors = new EnumMap(ApiKeys.class);
    private final Optional<Sensor> linkCountSensor;
    private final Metrics metrics;
    private final MetricsBuilderContext context;
    private final Uuid linkId;

    public ClusterLinkSourceMetrics(Metrics metrics, Uuid linkId, boolean clusterLinkMetricReductionAdvancedEnabled, boolean skipSourceLinkCountSensor) {
        this(metrics, linkId, Collections.emptyMap(), "", clusterLinkMetricReductionAdvancedEnabled, skipSourceLinkCountSensor);
        log.debug("Created ClusterLinkMetrics for link id {}", (Object)linkId);
    }

    public ClusterLinkSourceMetrics(Metrics metrics, Uuid linkId, Map<String, String> additionalTags, String additionalSensorSuffix, boolean clusterLinkMetricReductionAdvancedEnabled, boolean skipSourceLinkCountSensor) {
        this.metrics = metrics;
        this.context = new LinkMetricsBuilderContext(linkId, additionalTags, additionalSensorSuffix, clusterLinkMetricReductionAdvancedEnabled);
        this.linkId = linkId;
        this.linkCountSensor = skipSourceLinkCountSensor ? Optional.empty() : Optional.of(ClusterLinkMetricsUtils.createActiveLinkCountSensor(metrics, Utils.toJavaUuid(linkId), "source", additionalTags, additionalSensorSuffix, SOURCE_LINK_EXPIRY_SECONDS));
    }

    public void ensureLinkId(Uuid linkId) {
        if (!this.linkId.equals(linkId)) {
            log.error("Invalid link id in request, expected " + String.valueOf(this.linkId) + ", got " + String.valueOf(linkId));
        }
    }

    public void recordRequest(ApiKeys apiKey, long requestSize, long currentTimeMs) {
        ApiSensors sensors = this.apiSensors(this.metrics, apiKey, this.context, apiSensors -> apiSensors.requestSensorsExpired(this.metrics));
        sensors.recordRequest(requestSize, currentTimeMs);
        this.linkCountSensor.ifPresent(Sensor::record);
    }

    public void recordResponse(ApiKeys apiKey, long responseSize, long responseTimeNanos, Map<Errors, Integer> errorCounts, long currentTimeMs) {
        ApiSensors sensors = this.apiSensors(this.metrics, apiKey, this.context, apiSensors -> apiSensors.responseSensorsExpired(this.metrics));
        Set<Errors> newErrors = sensors.errorsWithoutSensors(this.metrics, errorCounts.keySet());
        if (!newErrors.isEmpty()) {
            ApiSensorBuilder builder = new ApiSensorBuilder(this.metrics, this.context, apiKey);
            builder.addErrorSensors(sensors, newErrors);
        }
        sensors.recordResponse(responseSize, responseTimeNanos, currentTimeMs);
        sensors.recordErrors(errorCounts, currentTimeMs);
    }

    private ApiSensors apiSensors(Metrics metrics, ApiKeys apiKey, MetricsBuilderContext context, Predicate<ApiSensors> expiredPred) {
        ApiSensors sensors = this.apiSensors.get((Object)apiKey);
        if (sensors == null || expiredPred.test(sensors)) {
            sensors = new ApiSensorBuilder(metrics, context, apiKey).build();
            this.apiSensors.put(apiKey, sensors);
        }
        return sensors;
    }

    ApiSensors apiSensors(ApiKeys apiKey) {
        return this.apiSensors.get((Object)apiKey);
    }

    MetricsBuilderContext builderContext() {
        return this.context;
    }

    private static class LinkMetricsBuilderContext
    implements MetricsBuilderContext {
        private final Map<String, String> metricTags;
        private final String sensorSuffix;

        LinkMetricsBuilderContext(Uuid linkId, Map<String, String> additionalTags, String additionalSensorSuffix, boolean clusterLinkMetricReductionAdvancedEnabled) {
            String linkIdStr = clusterLinkMetricReductionAdvancedEnabled ? ClusterLinkMetricsUtils.METRIC_REDUCTION_LINK_ID_TAG_VALUE : linkId.toString();
            this.metricTags = new HashMap<String, String>(additionalTags.size() + 1);
            this.metricTags.put("link-id", linkIdStr);
            this.metricTags.putAll(additionalTags);
            this.sensorSuffix = String.format(":%s-%s%s", "link-id", linkIdStr, additionalSensorSuffix);
        }

        @Override
        public String metricsGroup() {
            return ClusterLinkSourceMetrics.SOURCE_METRICS_GROUP;
        }

        @Override
        public Map<String, String> metricTags() {
            return new HashMap<String, String>(this.metricTags);
        }

        @Override
        public String sensorSuffix() {
            return this.sensorSuffix;
        }
    }
}

