/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.interceptor;

import java.net.InetAddress;
import java.util.Optional;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.ConfluentMetricsContextProvider;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.network.ProxyTlvProvider;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;

public interface BrokerInterceptor
extends Configurable {
    public void onAuthenticatedConnection(String var1, InetAddress var2, KafkaPrincipal var3, Metrics var4, ChannelMetadataRegistry var5);

    public void onAuthenticatedDisconnection(String var1, InetAddress var2, KafkaPrincipal var3, Metrics var4);

    default public void onFailedAuthentication(String connectionId, InetAddress clientAddress, Metrics metrics) {
    }

    default public void onApiVersionsRequest(ClientInformation clientInformation, String clientId, KafkaPrincipal principal, Metrics metrics) {
    }

    public RequestContext newContext(RequestContextOptions var1);

    public static class RequestContextOptions {
        private final RequestHeader header;
        private final String connectionId;
        private final long requestId;
        private final InetAddress clientAddress;
        private final Optional<Integer> clientPort;
        private final KafkaPrincipal principal;
        private final ListenerName listenerName;
        private final SecurityProtocol securityProtocol;
        private final ClientInformation clientInformation;
        private final Metrics metrics;
        private final PathAwareSniHostName sniHostName;
        private final boolean isPrivilegedListener;
        private final Optional<KafkaPrincipalSerde> principalSerde;
        private final AuthenticationContext authenticationContext;
        private final ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker;
        private final boolean isProxyModeLocal;
        private final BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2;
        private final boolean shouldLogForConnection;
        private final ConfluentMetricsContextProvider confluentMetricsContextProvider;
        private final ProxyTlvProvider proxyTlvProvider;

        public RequestContextOptions(RequestHeader header, String connectionId, long requestId, InetAddress clientAddress, Optional<Integer> clientPort, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, Metrics metrics, PathAwareSniHostName sniHostName, boolean isPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext, ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker, boolean isProxyModeLocal, BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2, boolean shouldLogForConnection, ConfluentMetricsContextProvider confluentMetricsContextProvider, ProxyTlvProvider proxyTlvProvider) {
            this.header = header;
            this.connectionId = connectionId;
            this.requestId = requestId;
            this.clientAddress = clientAddress;
            this.clientPort = clientPort;
            this.principal = principal;
            this.listenerName = listenerName;
            this.securityProtocol = securityProtocol;
            this.clientInformation = clientInformation;
            this.metrics = metrics;
            this.sniHostName = sniHostName;
            this.isPrivilegedListener = isPrivilegedListener;
            this.principalSerde = principalSerde;
            this.authenticationContext = authenticationContext;
            this.produceConsumeAuditLogTracker = produceConsumeAuditLogTracker;
            this.isProxyModeLocal = isProxyModeLocal;
            this.fqdnPropertiesFromPpv2 = fqdnPropertiesFromPpv2;
            this.shouldLogForConnection = shouldLogForConnection;
            this.confluentMetricsContextProvider = confluentMetricsContextProvider;
            this.proxyTlvProvider = proxyTlvProvider;
        }

        public RequestHeader header() {
            return this.header;
        }

        public String connectionId() {
            return this.connectionId;
        }

        public long requestId() {
            return this.requestId;
        }

        public InetAddress clientAddress() {
            return this.clientAddress;
        }

        public Optional<Integer> clientPort() {
            return this.clientPort;
        }

        public KafkaPrincipal principal() {
            return this.principal;
        }

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public SecurityProtocol securityProtocol() {
            return this.securityProtocol;
        }

        public ClientInformation clientInformation() {
            return this.clientInformation;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public PathAwareSniHostName sniHostName() {
            return this.sniHostName;
        }

        public boolean isPrivilegedListener() {
            return this.isPrivilegedListener;
        }

        public Optional<KafkaPrincipalSerde> principalSerde() {
            return this.principalSerde;
        }

        public AuthenticationContext authenticationContext() {
            return this.authenticationContext;
        }

        public ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker() {
            return this.produceConsumeAuditLogTracker;
        }

        public boolean isProxyModeLocal() {
            return this.isProxyModeLocal;
        }

        public BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2() {
            return this.fqdnPropertiesFromPpv2;
        }

        public boolean shouldLogForConnection() {
            return this.shouldLogForConnection;
        }

        public ConfluentMetricsContextProvider confluentMetricsContextProvider() {
            return this.confluentMetricsContextProvider;
        }

        public Optional<ProxyTlvProvider> proxyTlvProvider() {
            return Optional.ofNullable(this.proxyTlvProvider);
        }
    }
}

