/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class WriteShareGroupStateResponse
extends AbstractResponse {
    private final WriteShareGroupStateResponseData data;

    public WriteShareGroupStateResponse(WriteShareGroupStateResponseData data) {
        super(ApiKeys.WRITE_SHARE_GROUP_STATE);
        this.data = data;
    }

    @Override
    public WriteShareGroupStateResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result -> result.partitions().forEach(partitionResult -> WriteShareGroupStateResponse.updateErrorCounts(counts, Errors.forCode(partitionResult.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static WriteShareGroupStateResponse parse(Readable readable, short version, MessageContext context) {
        return new WriteShareGroupStateResponse(new WriteShareGroupStateResponseData(readable, version, context));
    }

    public static WriteShareGroupStateResponseData toResponseData(Uuid topicId, int partitionId) {
        return new WriteShareGroupStateResponseData().setResults(List.of(new WriteShareGroupStateResponseData.WriteStateResult().setTopicId(topicId).setPartitions(List.of(new WriteShareGroupStateResponseData.PartitionResult().setPartition(partitionId)))));
    }

    public static WriteShareGroupStateResponseData toErrorResponseData(Uuid topicId, int partitionId, Errors error, String errorMessage) {
        WriteShareGroupStateResponseData responseData = new WriteShareGroupStateResponseData();
        responseData.setResults(List.of(new WriteShareGroupStateResponseData.WriteStateResult().setTopicId(topicId).setPartitions(List.of(new WriteShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage)))));
        return responseData;
    }

    public static WriteShareGroupStateResponseData.PartitionResult toErrorResponsePartitionResult(int partitionId, Errors error, String errorMessage) {
        return new WriteShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    public static WriteShareGroupStateResponseData.WriteStateResult toResponseWriteStateResult(Uuid topicId, List<WriteShareGroupStateResponseData.PartitionResult> partitionResults) {
        return new WriteShareGroupStateResponseData.WriteStateResult().setTopicId(topicId).setPartitions(partitionResults);
    }

    public static WriteShareGroupStateResponseData.PartitionResult toResponsePartitionResult(int partitionId) {
        return new WriteShareGroupStateResponseData.PartitionResult().setPartition(partitionId);
    }

    public static WriteShareGroupStateResponseData toGlobalErrorResponse(WriteShareGroupStateRequestData request, Errors error) {
        ArrayList<WriteShareGroupStateResponseData.WriteStateResult> writeStateResults = new ArrayList<WriteShareGroupStateResponseData.WriteStateResult>();
        request.topics().forEach(topicData -> {
            ArrayList<WriteShareGroupStateResponseData.PartitionResult> partitionResults = new ArrayList<WriteShareGroupStateResponseData.PartitionResult>();
            topicData.partitions().forEach(partitionData -> partitionResults.add(WriteShareGroupStateResponse.toErrorResponsePartitionResult(partitionData.partition(), error, error.message())));
            writeStateResults.add(WriteShareGroupStateResponse.toResponseWriteStateResult(topicData.topicId(), partitionResults));
        });
        return new WriteShareGroupStateResponseData().setResults(writeStateResults);
    }
}

