/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.ReadableBuf;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ResponseHeader;

public class RequestHeader
implements AbstractRequestResponse {
    private static final int SIZE_NOT_INITIALIZED = -1;
    private final RequestHeaderData data;
    private final short headerVersion;
    private int size = -1;

    public RequestHeader(ApiKeys requestApiKey, short requestVersion, String clientId, int correlationId) {
        this(new RequestHeaderData().setRequestApiKey(requestApiKey.id).setRequestApiVersion(requestVersion).setClientId(clientId).setCorrelationId(correlationId), ApiKeys.forId(requestApiKey.id).requestHeaderVersion(requestVersion));
    }

    public RequestHeader(RequestHeaderData data, short headerVersion) {
        this.data = data;
        this.headerVersion = headerVersion;
    }

    public ApiKeys apiKey() {
        return ApiKeys.forId(this.data.requestApiKey());
    }

    public short apiVersion() {
        return this.data.requestApiVersion();
    }

    public short headerVersion() {
        return this.headerVersion;
    }

    public String clientId() {
        return this.data.clientId();
    }

    public Optional<Uuid> clusterLinkId() {
        Uuid kafkaLinkId = this.data.clusterLinkId();
        return kafkaLinkId == null || kafkaLinkId.equals(Uuid.ZERO_UUID) ? Optional.empty() : Optional.of(kafkaLinkId);
    }

    public Optional<String> clusterLinkTenant() {
        return Optional.ofNullable(this.data.clusterLinkTenant()).filter(t -> !t.isEmpty());
    }

    public RequestHeaderData.TraceContext traceContext() {
        return this.data.traceContext();
    }

    public int correlationId() {
        return this.data.correlationId();
    }

    @Override
    public RequestHeaderData data() {
        return this.data;
    }

    void write(ByteBuffer buffer, ObjectSerializationCache serializationCache) {
        this.data.write(new ByteBufferAccessor(buffer), serializationCache, this.headerVersion);
    }

    public int size(ObjectSerializationCache serializationCache) {
        this.size = this.data.size(serializationCache, this.headerVersion);
        return this.size;
    }

    public int size() {
        if (this.size == -1) {
            this.size = this.size(new ObjectSerializationCache());
        }
        return this.size;
    }

    public boolean isApiVersionSupported() {
        return this.apiKey().isVersionSupported(this.apiVersion());
    }

    public boolean isApiVersionDeprecated() {
        return this.apiKey().isVersionDeprecated(this.apiVersion());
    }

    public ResponseHeader toResponseHeader() {
        return new ResponseHeader(this.data.correlationId(), this.apiKey().responseHeaderVersion(this.apiVersion()));
    }

    public static RequestHeader parse(ByteBuffer buffer) {
        return RequestHeader.parse(new ByteBufferAccessor(buffer));
    }

    public static RequestHeader parse(ReadableBuf buffer) {
        short apiKeyId = -1;
        try {
            int bufferStartPositionForHeader = buffer.position();
            apiKeyId = buffer.readShort();
            short apiVersion = buffer.readShort();
            ApiKeys apiKey = ApiKeys.forId(apiKeyId);
            if (!apiKey.hasValidVersion()) {
                throw new InvalidRequestException("Unsupported api with key " + apiKeyId + " (" + apiKey.name + ") and version " + apiVersion);
            }
            short headerVersion = apiKey.requestHeaderVersion(apiVersion);
            buffer.position(bufferStartPositionForHeader);
            RequestHeaderData headerData = new RequestHeaderData(buffer, headerVersion);
            if (headerData.clientId() == null) {
                headerData.setClientId("");
            }
            RequestHeader header = new RequestHeader(headerData, headerVersion);
            header.size = Math.max(buffer.position() - bufferStartPositionForHeader, 0);
            return header;
        }
        catch (UnsupportedVersionException e) {
            throw new InvalidRequestException("Unknown API key " + apiKeyId, e);
        }
        catch (InvalidRequestException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new InvalidRequestException("Error parsing request header. Our best guess of the apiKeyId is: " + apiKeyId, ex);
        }
    }

    public static ApiKeys parseApiKey(ByteBuffer buffer) {
        try {
            return ApiKeys.forId(buffer.getShort(buffer.position()));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            return null;
        }
    }

    public String toString() {
        return "RequestHeader(apiKey=" + String.valueOf((Object)this.apiKey()) + ", apiVersion=" + this.apiVersion() + ", clientId=" + this.clientId() + ", correlationId=" + this.correlationId() + ", headerVersion=" + this.headerVersion + this.clusterLinkId().map(linkId -> ", clusterLinkId=" + String.valueOf(linkId)).orElse("") + this.clusterLinkTenant().map(tenant -> ", clusterLinkTenant=" + tenant).orElse("") + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestHeader that = (RequestHeader)o;
        return this.headerVersion == that.headerVersion && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.headerVersion);
    }
}

