/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryResponse;

public class ReadShareGroupStateSummaryRequest
extends AbstractRequest {
    private final ReadShareGroupStateSummaryRequestData data;

    public ReadShareGroupStateSummaryRequest(ReadShareGroupStateSummaryRequestData data, short version) {
        super(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY, version);
        this.data = data;
    }

    @Override
    public ReadShareGroupStateSummaryResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult> results = new ArrayList<ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult>();
        this.data.topics().forEach(topicResult -> results.add(new ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult().setTopicId(topicResult.topicId()).setPartitions(topicResult.partitions().stream().map(partitionData -> new ReadShareGroupStateSummaryResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(Errors.forException(e).code()).setErrorMessage(Errors.forException(e).message())).collect(Collectors.toList()))));
        return new ReadShareGroupStateSummaryResponse(new ReadShareGroupStateSummaryResponseData().setResults(results));
    }

    @Override
    public ReadShareGroupStateSummaryRequestData data() {
        return this.data;
    }

    public static ReadShareGroupStateSummaryRequest parse(Readable readable, short version, MessageContext context) {
        return new ReadShareGroupStateSummaryRequest(new ReadShareGroupStateSummaryRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ReadShareGroupStateSummaryRequest> {
        private final ReadShareGroupStateSummaryRequestData data;

        public Builder(ReadShareGroupStateSummaryRequestData data) {
            super(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY);
            this.data = data;
        }

        @Override
        public ReadShareGroupStateSummaryRequest build(short version) {
            return new ReadShareGroupStateSummaryRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

