/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.netty.AbstractConnectionInitializer;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class NettyHttp2ConnectionInitializer
extends AbstractConnectionInitializer<Channel> {
    private final Logger log;
    private final ConnectionMode connectionMode;
    private final SslContext sslContext;
    private final Http2Settings http2Settings;
    private final ChannelHandler http2MultiplexInboundStreamHandler;
    private final boolean enabledHttp2FrameLogging;
    private final int connectionWindowSize;
    private final CompletableFuture<Void> firstSettingsFrameReceived = new CompletableFuture();

    public NettyHttp2ConnectionInitializer(ConnectionMode connectionMode, ChannelGroup trackedChannels, SslContext sslContext, Http2Settings http2Settings, ChannelHandler http2MultiplexInboundStreamHandler, LogContext logContext) {
        this(connectionMode, trackedChannels, sslContext, http2Settings, http2MultiplexInboundStreamHandler, logContext, 0x1E00000, false);
    }

    public NettyHttp2ConnectionInitializer(ConnectionMode connectionMode, ChannelGroup trackedChannels, SslContext sslContext, Http2Settings http2Settings, ChannelHandler http2MultiplexInboundStreamHandler, LogContext logContext, int connectionWindowSize) {
        this(connectionMode, trackedChannels, sslContext, http2Settings, http2MultiplexInboundStreamHandler, logContext, connectionWindowSize, false);
    }

    public NettyHttp2ConnectionInitializer(ConnectionMode connectionMode, ChannelGroup trackedChannels, SslContext sslContext, Http2Settings http2Settings, ChannelHandler http2MultiplexInboundStreamHandler, LogContext logContext, int connectionWindowSize, boolean enableHttp2FrameLogging) {
        super(trackedChannels);
        this.connectionMode = connectionMode;
        this.sslContext = sslContext;
        this.http2Settings = http2Settings;
        this.http2MultiplexInboundStreamHandler = http2MultiplexInboundStreamHandler;
        this.connectionWindowSize = connectionWindowSize;
        this.enabledHttp2FrameLogging = enableHttp2FrameLogging;
        this.log = logContext.logger(NettyHttp2ConnectionInitializer.class);
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.sslContext != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslContext.newHandler(channel.alloc())});
            pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("h2"){

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
                    if (!"h2".equals(protocol)) {
                        NettyHttp2ConnectionInitializer.this.log.error("Unexpected protocol: {}, expected {}", (Object)protocol, (Object)"h2");
                        ctx.close();
                        throw new IllegalStateException("Protocol: " + protocol + " not supported");
                    }
                }
            }});
        }
        pipeline.addLast(new ChannelHandler[]{this.createHttp2FrameCodec()});
        pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Http2SettingsFrame>(){

            protected void channelRead0(ChannelHandlerContext ctx, Http2SettingsFrame frame) {
                NettyHttp2ConnectionInitializer.this.firstSettingsFrameReceived.complete(null);
                ctx.fireChannelRead((Object)frame);
                Http2Connection http2Connection = NettyHttp2ConnectionInitializer.getHttp2Connection(ctx.channel());
                Http2FlowController localFlowController = http2Connection.local().flowController();
                int windowSize = localFlowController.windowSize(http2Connection.connectionStream());
                int increment = NettyHttp2ConnectionInitializer.this.connectionWindowSize - windowSize;
                if (increment > 0) {
                    NettyHttp2ConnectionInitializer.this.log.debug("Expanding HTTP/2 connection window size by {} to {}", (Object)increment, (Object)NettyHttp2ConnectionInitializer.this.connectionWindowSize);
                    ctx.writeAndFlush((Object)new DefaultHttp2WindowUpdateFrame(increment)).addListener(future -> {
                        if (!future.isSuccess()) {
                            NettyHttp2ConnectionInitializer.this.log.error("Failed to expand HTTP/2 connection window size, closing connection {}", (Object)ctx.channel(), (Object)future.cause());
                            ctx.close();
                        } else {
                            NettyHttp2ConnectionInitializer.this.log.debug("HTTP/2 connection window size expanded successfully");
                        }
                    });
                }
                this.removeSelfIfPresent(ctx);
            }

            private void removeSelfIfPresent(ChannelHandlerContext ctx) {
                if (!ctx.isRemoved()) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
        }});
        pipeline.addLast(new ChannelHandler[]{new Http2MultiplexHandler(this.http2MultiplexInboundStreamHandler)});
        if (this.trackedChannels != null) {
            this.trackedChannels.add((Object)channel);
        }
    }

    public static Http2Connection getHttp2Connection(Http2StreamChannel streamChannel) {
        return NettyHttp2ConnectionInitializer.getHttp2Connection(streamChannel.parent());
    }

    static Http2Connection getHttp2Connection(Channel channel) {
        try {
            return ((Http2FrameCodec)channel.pipeline().get(Http2FrameCodec.class)).connection();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to get HTTP/2 connection from channel " + String.valueOf(channel), e);
        }
    }

    private Http2FrameCodec createHttp2FrameCodec() {
        Http2FrameCodecBuilder http2FrameCodecBuilder = this.connectionMode == ConnectionMode.SERVER ? Http2FrameCodecBuilder.forServer() : Http2FrameCodecBuilder.forClient();
        Http2FrameCodecBuilder builder = http2FrameCodecBuilder.initialSettings(this.http2Settings).decoderEnforceMaxRstFramesPerWindow(0, 30);
        if (this.enabledHttp2FrameLogging) {
            builder.frameLogger(new Http2FrameLogger(LogLevel.INFO));
        }
        return builder.build();
    }

    public CompletableFuture<Void> firstSettingsFrameReceived() {
        return this.firstSettingsFrameReceived;
    }

    public static class NettyHttp2StreamInitializer
    extends AbstractConnectionInitializer<Http2StreamChannel> {
        private final BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator;
        private final LogContext logContext;
        private final boolean flowControlEnabled;

        public NettyHttp2StreamInitializer(BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator, ChannelGroup trackedChannels, LogContext logContext, boolean flowControlEnabled) {
            super(trackedChannels);
            this.handlerCreator = handlerCreator;
            this.logContext = logContext;
            this.flowControlEnabled = flowControlEnabled;
        }

        protected void initChannel(Http2StreamChannel streamChannel) {
            NettyHttp2Stream nettyHttp2Stream = new NettyHttp2Stream(streamChannel, this.logContext, this.flowControlEnabled);
            NettyHttp2Stream.NettyHttp2StreamHandler pipelineHandler = new NettyHttp2Stream.NettyHttp2StreamHandler((NettyStream)nettyHttp2Stream, this.handlerCreator, this.logContext);
            nettyHttp2Stream.setAbstractStreamHandler(pipelineHandler);
            streamChannel.pipeline().addLast(new ChannelHandler[]{pipelineHandler});
            this.trackedChannels.add((Object)streamChannel);
        }
    }
}

