/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Objects;
import org.apache.kafka.common.Uuid;

public class TopicIdAndPartition {
    private final Uuid topicId;
    private final int partition;

    public TopicIdAndPartition(Uuid topicId, int partition) {
        this.topicId = Objects.requireNonNull(topicId, "topicId can not be null");
        this.partition = partition;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public int partition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicIdAndPartition that = (TopicIdAndPartition)o;
        return this.topicId.equals(that.topicId) && this.partition == that.partition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.topicId.hashCode();
        result = 31 * result + this.partition;
        return result;
    }

    public String toString() {
        return String.valueOf(this.topicId) + "-" + this.partition;
    }
}

