/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public class ShareAcknowledgementMode {
    private final AcknowledgementMode acknowledgementMode;
    public static final ShareAcknowledgementMode IMPLICIT = new ShareAcknowledgementMode(AcknowledgementMode.IMPLICIT);
    public static final ShareAcknowledgementMode EXPLICIT = new ShareAcknowledgementMode(AcknowledgementMode.EXPLICIT);

    private ShareAcknowledgementMode(AcknowledgementMode acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public static ShareAcknowledgementMode fromString(String acknowledgementMode) {
        if (acknowledgementMode == null) {
            throw new IllegalArgumentException("Acknowledgement mode is null");
        }
        if (Arrays.asList(Utils.enumOptions(AcknowledgementMode.class)).contains(acknowledgementMode)) {
            AcknowledgementMode mode = AcknowledgementMode.valueOf(acknowledgementMode.toUpperCase(Locale.ROOT));
            switch (mode) {
                case IMPLICIT: {
                    return IMPLICIT;
                }
                case EXPLICIT: {
                    return EXPLICIT;
                }
            }
            throw new IllegalArgumentException("Invalid acknowledgement mode: " + acknowledgementMode);
        }
        throw new IllegalArgumentException("Invalid acknowledgement mode: " + acknowledgementMode);
    }

    public String name() {
        return this.acknowledgementMode.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShareAcknowledgementMode that = (ShareAcknowledgementMode)o;
        return this.acknowledgementMode == that.acknowledgementMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acknowledgementMode});
    }

    public String toString() {
        return "ShareAcknowledgementMode{mode=" + String.valueOf((Object)this.acknowledgementMode) + "}";
    }

    public static enum AcknowledgementMode {
        IMPLICIT,
        EXPLICIT;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static class Validator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            String acknowledgementMode = (String)value;
            try {
                ShareAcknowledgementMode.fromString(acknowledgementMode);
            }
            catch (Exception e) {
                throw new ConfigException(name, value, "Invalid value `" + acknowledgementMode + "` for configuration " + name + ". The value must either be 'implicit' or 'explicit'.");
            }
        }

        public String toString() {
            String values = Arrays.stream(AcknowledgementMode.values()).map(AcknowledgementMode::toString).collect(Collectors.joining(", "));
            return "[" + values + "]";
        }
    }
}

