/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

import static org.apache.kafka.common.protocol.types.Field.TaggedFieldsSection;


public class StreamsGroupHeartbeatResponseData implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    String memberId;
    int memberEpoch;
    int heartbeatIntervalMs;
    int acceptableRecoveryLag;
    int taskOffsetIntervalMs;
    List<Status> status;
    List<TaskIds> activeTasks;
    List<TaskIds> standbyTasks;
    List<TaskIds> warmupTasks;
    int endpointInformationEpoch;
    List<EndpointToPartitions> partitionsByUserEndpoint;
    private List<RawTaggedField> _unknownTaggedFields;
    
    public static final Schema SCHEMA_0 =
        new Schema(
            new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."),
            new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error"),
            new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The top-level error message, or null if there was no error."),
            new Field("member_id", Type.COMPACT_STRING, "The member id is always generated by the streams consumer."),
            new Field("member_epoch", Type.INT32, "The member epoch."),
            new Field("heartbeat_interval_ms", Type.INT32, "The heartbeat interval in milliseconds."),
            new Field("acceptable_recovery_lag", Type.INT32, "The maximal lag a warm-up task can have to be considered caught-up."),
            new Field("task_offset_interval_ms", Type.INT32, "The interval in which the task changelog offsets on a client are updated on the broker. The offsets are sent with the next heartbeat after this time has passed."),
            new Field("status", CompactArrayOf.nullable(Status.SCHEMA_0), "Indicate zero or more status for the group.  Null if unchanged since last heartbeat."),
            new Field("active_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Assigned active tasks for this client. Null if unchanged since last heartbeat."),
            new Field("standby_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Assigned standby tasks for this client. Null if unchanged since last heartbeat."),
            new Field("warmup_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Assigned warm-up tasks for this client. Null if unchanged since last heartbeat."),
            new Field("endpoint_information_epoch", Type.INT32, "The endpoint epoch set in the response"),
            new Field("partitions_by_user_endpoint", CompactArrayOf.nullable(EndpointToPartitions.SCHEMA_0), "Global assignment information used for IQ. Null if unchanged since last heartbeat."),
            TaggedFieldsSection.of(
            )
        );
    
    public static final Schema[] SCHEMAS = new Schema[] {
        SCHEMA_0
    };
    
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;
    
    public StreamsGroupHeartbeatResponseData(Readable _readable, short _version) {
        read(_readable, _version);
    }
    
    public StreamsGroupHeartbeatResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = (short) 0;
        this.errorMessage = null;
        this.memberId = "";
        this.memberEpoch = 0;
        this.heartbeatIntervalMs = 0;
        this.acceptableRecoveryLag = 0;
        this.taskOffsetIntervalMs = 0;
        this.status = null;
        this.activeTasks = null;
        this.standbyTasks = null;
        this.warmupTasks = null;
        this.endpointInformationEpoch = 0;
        this.partitionsByUserEndpoint = null;
    }
    
    @Override
    public short apiKey() {
        return 88;
    }
    
    @Override
    public short lowestSupportedVersion() {
        return 0;
    }
    
    @Override
    public short highestSupportedVersion() {
        return 0;
    }
    
    @Override
    public final void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            } else {
                this.errorMessage = _readable.readString(length);
            }
        }
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            } else {
                this.memberId = _readable.readString(length);
            }
        }
        this.memberEpoch = _readable.readInt();
        this.heartbeatIntervalMs = _readable.readInt();
        this.acceptableRecoveryLag = _readable.readInt();
        this.taskOffsetIntervalMs = _readable.readInt();
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.status = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<Status> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    newCollection.add(new Status(_readable, _version));
                }
                this.status = newCollection;
            }
        }
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.activeTasks = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<TaskIds> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    newCollection.add(new TaskIds(_readable, _version));
                }
                this.activeTasks = newCollection;
            }
        }
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.standbyTasks = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<TaskIds> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    newCollection.add(new TaskIds(_readable, _version));
                }
                this.standbyTasks = newCollection;
            }
        }
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.warmupTasks = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<TaskIds> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    newCollection.add(new TaskIds(_readable, _version));
                }
                this.warmupTasks = newCollection;
            }
        }
        this.endpointInformationEpoch = _readable.readInt();
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.partitionsByUserEndpoint = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<EndpointToPartitions> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    newCollection.add(new EndpointToPartitions(_readable, _version));
                }
                this.partitionsByUserEndpoint = newCollection;
            }
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; _i++) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default:
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    break;
            }
        }
    }
    
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(throttleTimeMs);
        _writable.writeShort(errorCode);
        if (errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(errorMessage);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        {
            byte[] _stringBytes = _cache.getSerializedValue(memberId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeInt(memberEpoch);
        _writable.writeInt(heartbeatIntervalMs);
        _writable.writeInt(acceptableRecoveryLag);
        _writable.writeInt(taskOffsetIntervalMs);
        if (status == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(status.size() + 1);
            for (Status statusElement : status) {
                statusElement.write(_writable, _cache, _version);
            }
        }
        if (activeTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(activeTasks.size() + 1);
            for (TaskIds activeTasksElement : activeTasks) {
                activeTasksElement.write(_writable, _cache, _version);
            }
        }
        if (standbyTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(standbyTasks.size() + 1);
            for (TaskIds standbyTasksElement : standbyTasks) {
                standbyTasksElement.write(_writable, _cache, _version);
            }
        }
        if (warmupTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(warmupTasks.size() + 1);
            for (TaskIds warmupTasksElement : warmupTasks) {
                warmupTasksElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(endpointInformationEpoch);
        if (partitionsByUserEndpoint == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(partitionsByUserEndpoint.size() + 1);
            for (EndpointToPartitions partitionsByUserEndpointElement : partitionsByUserEndpoint) {
                partitionsByUserEndpointElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        _writable.writeUnsignedVarint(_numTaggedFields);
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }
    
    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        {
            byte[] _stringBytes = memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        if (status == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(status.size() + 1));
            for (Status statusElement : status) {
                statusElement.addSize(_size, _cache, _version);
            }
        }
        if (activeTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(activeTasks.size() + 1));
            for (TaskIds activeTasksElement : activeTasks) {
                activeTasksElement.addSize(_size, _cache, _version);
            }
        }
        if (standbyTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(standbyTasks.size() + 1));
            for (TaskIds standbyTasksElement : standbyTasks) {
                standbyTasksElement.addSize(_size, _cache, _version);
            }
        }
        if (warmupTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(warmupTasks.size() + 1));
            for (TaskIds warmupTasksElement : warmupTasks) {
                warmupTasksElement.addSize(_size, _cache, _version);
            }
        }
        _size.addBytes(4);
        if (partitionsByUserEndpoint == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(partitionsByUserEndpoint.size() + 1));
            for (EndpointToPartitions partitionsByUserEndpointElement : partitionsByUserEndpoint) {
                partitionsByUserEndpointElement.addSize(_size, _cache, _version);
            }
        }
        if (_unknownTaggedFields != null) {
            _numTaggedFields += _unknownTaggedFields.size();
            for (RawTaggedField _field : _unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StreamsGroupHeartbeatResponseData)) return false;
        StreamsGroupHeartbeatResponseData other = (StreamsGroupHeartbeatResponseData) obj;
        if (throttleTimeMs != other.throttleTimeMs) return false;
        if (errorCode != other.errorCode) return false;
        if (this.errorMessage == null) {
            if (other.errorMessage != null) return false;
        } else {
            if (!this.errorMessage.equals(other.errorMessage)) return false;
        }
        if (this.memberId == null) {
            if (other.memberId != null) return false;
        } else {
            if (!this.memberId.equals(other.memberId)) return false;
        }
        if (memberEpoch != other.memberEpoch) return false;
        if (heartbeatIntervalMs != other.heartbeatIntervalMs) return false;
        if (acceptableRecoveryLag != other.acceptableRecoveryLag) return false;
        if (taskOffsetIntervalMs != other.taskOffsetIntervalMs) return false;
        if (this.status == null) {
            if (other.status != null) return false;
        } else {
            if (!this.status.equals(other.status)) return false;
        }
        if (this.activeTasks == null) {
            if (other.activeTasks != null) return false;
        } else {
            if (!this.activeTasks.equals(other.activeTasks)) return false;
        }
        if (this.standbyTasks == null) {
            if (other.standbyTasks != null) return false;
        } else {
            if (!this.standbyTasks.equals(other.standbyTasks)) return false;
        }
        if (this.warmupTasks == null) {
            if (other.warmupTasks != null) return false;
        } else {
            if (!this.warmupTasks.equals(other.warmupTasks)) return false;
        }
        if (endpointInformationEpoch != other.endpointInformationEpoch) return false;
        if (this.partitionsByUserEndpoint == null) {
            if (other.partitionsByUserEndpoint != null) return false;
        } else {
            if (!this.partitionsByUserEndpoint.equals(other.partitionsByUserEndpoint)) return false;
        }
        return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
    }
    
    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + throttleTimeMs;
        hashCode = 31 * hashCode + errorCode;
        hashCode = 31 * hashCode + (errorMessage == null ? 0 : errorMessage.hashCode());
        hashCode = 31 * hashCode + (memberId == null ? 0 : memberId.hashCode());
        hashCode = 31 * hashCode + memberEpoch;
        hashCode = 31 * hashCode + heartbeatIntervalMs;
        hashCode = 31 * hashCode + acceptableRecoveryLag;
        hashCode = 31 * hashCode + taskOffsetIntervalMs;
        hashCode = 31 * hashCode + (status == null ? 0 : status.hashCode());
        hashCode = 31 * hashCode + (activeTasks == null ? 0 : activeTasks.hashCode());
        hashCode = 31 * hashCode + (standbyTasks == null ? 0 : standbyTasks.hashCode());
        hashCode = 31 * hashCode + (warmupTasks == null ? 0 : warmupTasks.hashCode());
        hashCode = 31 * hashCode + endpointInformationEpoch;
        hashCode = 31 * hashCode + (partitionsByUserEndpoint == null ? 0 : partitionsByUserEndpoint.hashCode());
        return hashCode;
    }
    
    @Override
    public StreamsGroupHeartbeatResponseData duplicate() {
        StreamsGroupHeartbeatResponseData _duplicate = new StreamsGroupHeartbeatResponseData();
        _duplicate.throttleTimeMs = throttleTimeMs;
        _duplicate.errorCode = errorCode;
        if (errorMessage == null) {
            _duplicate.errorMessage = null;
        } else {
            _duplicate.errorMessage = errorMessage;
        }
        _duplicate.memberId = memberId;
        _duplicate.memberEpoch = memberEpoch;
        _duplicate.heartbeatIntervalMs = heartbeatIntervalMs;
        _duplicate.acceptableRecoveryLag = acceptableRecoveryLag;
        _duplicate.taskOffsetIntervalMs = taskOffsetIntervalMs;
        if (status == null) {
            _duplicate.status = null;
        } else {
            ArrayList<Status> newStatus = new ArrayList<Status>(status.size());
            for (Status _element : status) {
                newStatus.add(_element.duplicate());
            }
            _duplicate.status = newStatus;
        }
        if (activeTasks == null) {
            _duplicate.activeTasks = null;
        } else {
            ArrayList<TaskIds> newActiveTasks = new ArrayList<TaskIds>(activeTasks.size());
            for (TaskIds _element : activeTasks) {
                newActiveTasks.add(_element.duplicate());
            }
            _duplicate.activeTasks = newActiveTasks;
        }
        if (standbyTasks == null) {
            _duplicate.standbyTasks = null;
        } else {
            ArrayList<TaskIds> newStandbyTasks = new ArrayList<TaskIds>(standbyTasks.size());
            for (TaskIds _element : standbyTasks) {
                newStandbyTasks.add(_element.duplicate());
            }
            _duplicate.standbyTasks = newStandbyTasks;
        }
        if (warmupTasks == null) {
            _duplicate.warmupTasks = null;
        } else {
            ArrayList<TaskIds> newWarmupTasks = new ArrayList<TaskIds>(warmupTasks.size());
            for (TaskIds _element : warmupTasks) {
                newWarmupTasks.add(_element.duplicate());
            }
            _duplicate.warmupTasks = newWarmupTasks;
        }
        _duplicate.endpointInformationEpoch = endpointInformationEpoch;
        if (partitionsByUserEndpoint == null) {
            _duplicate.partitionsByUserEndpoint = null;
        } else {
            ArrayList<EndpointToPartitions> newPartitionsByUserEndpoint = new ArrayList<EndpointToPartitions>(partitionsByUserEndpoint.size());
            for (EndpointToPartitions _element : partitionsByUserEndpoint) {
                newPartitionsByUserEndpoint.add(_element.duplicate());
            }
            _duplicate.partitionsByUserEndpoint = newPartitionsByUserEndpoint;
        }
        return _duplicate;
    }
    
    @Override
    public String toString() {
        return "StreamsGroupHeartbeatResponseData("
            + "throttleTimeMs=" + throttleTimeMs
            + ", errorCode=" + errorCode
            + ", errorMessage=" + ((errorMessage == null) ? "null" : "'" + errorMessage.toString() + "'")
            + ", memberId=" + ((memberId == null) ? "null" : "'" + memberId.toString() + "'")
            + ", memberEpoch=" + memberEpoch
            + ", heartbeatIntervalMs=" + heartbeatIntervalMs
            + ", acceptableRecoveryLag=" + acceptableRecoveryLag
            + ", taskOffsetIntervalMs=" + taskOffsetIntervalMs
            + ", status=" + ((status == null) ? "null" : MessageUtil.deepToString(status.iterator()))
            + ", activeTasks=" + ((activeTasks == null) ? "null" : MessageUtil.deepToString(activeTasks.iterator()))
            + ", standbyTasks=" + ((standbyTasks == null) ? "null" : MessageUtil.deepToString(standbyTasks.iterator()))
            + ", warmupTasks=" + ((warmupTasks == null) ? "null" : MessageUtil.deepToString(warmupTasks.iterator()))
            + ", endpointInformationEpoch=" + endpointInformationEpoch
            + ", partitionsByUserEndpoint=" + ((partitionsByUserEndpoint == null) ? "null" : MessageUtil.deepToString(partitionsByUserEndpoint.iterator()))
            + ")";
    }
    
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }
    
    public short errorCode() {
        return this.errorCode;
    }
    
    public String errorMessage() {
        return this.errorMessage;
    }
    
    public String memberId() {
        return this.memberId;
    }
    
    public int memberEpoch() {
        return this.memberEpoch;
    }
    
    public int heartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }
    
    public int acceptableRecoveryLag() {
        return this.acceptableRecoveryLag;
    }
    
    public int taskOffsetIntervalMs() {
        return this.taskOffsetIntervalMs;
    }
    
    public List<Status> status() {
        return this.status;
    }
    
    public List<TaskIds> activeTasks() {
        return this.activeTasks;
    }
    
    public List<TaskIds> standbyTasks() {
        return this.standbyTasks;
    }
    
    public List<TaskIds> warmupTasks() {
        return this.warmupTasks;
    }
    
    public int endpointInformationEpoch() {
        return this.endpointInformationEpoch;
    }
    
    public List<EndpointToPartitions> partitionsByUserEndpoint() {
        return this.partitionsByUserEndpoint;
    }
    
    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (_unknownTaggedFields == null) {
            _unknownTaggedFields = new ArrayList<>(0);
        }
        return _unknownTaggedFields;
    }
    
    public StreamsGroupHeartbeatResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setMemberId(String v) {
        this.memberId = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setHeartbeatIntervalMs(int v) {
        this.heartbeatIntervalMs = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setAcceptableRecoveryLag(int v) {
        this.acceptableRecoveryLag = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setTaskOffsetIntervalMs(int v) {
        this.taskOffsetIntervalMs = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setStatus(List<Status> v) {
        this.status = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setActiveTasks(List<TaskIds> v) {
        this.activeTasks = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setStandbyTasks(List<TaskIds> v) {
        this.standbyTasks = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setWarmupTasks(List<TaskIds> v) {
        this.warmupTasks = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setEndpointInformationEpoch(int v) {
        this.endpointInformationEpoch = v;
        return this;
    }
    
    public StreamsGroupHeartbeatResponseData setPartitionsByUserEndpoint(List<EndpointToPartitions> v) {
        this.partitionsByUserEndpoint = v;
        return this;
    }
    
    public static class EndpointToPartitions implements Message {
        Endpoint userEndpoint;
        List<TopicPartition> activePartitions;
        List<TopicPartition> standbyPartitions;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("user_endpoint", Endpoint.SCHEMA_0, "User-defined endpoint to connect to the node"),
                new Field("active_partitions", new CompactArrayOf(TopicPartition.SCHEMA_0), "All topic partitions materialized by active tasks on the node"),
                new Field("standby_partitions", new CompactArrayOf(TopicPartition.SCHEMA_0), "All topic partitions materialized by standby tasks on the node"),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public EndpointToPartitions(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public EndpointToPartitions() {
            this.userEndpoint = new Endpoint();
            this.activePartitions = new ArrayList<TopicPartition>(0);
            this.standbyPartitions = new ArrayList<TopicPartition>(0);
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 0;
        }
        
        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EndpointToPartitions");
            }
            {
                this.userEndpoint = new Endpoint(_readable, _version);
            }
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field activePartitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<TopicPartition> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(new TopicPartition(_readable, _version));
                    }
                    this.activePartitions = newCollection;
                }
            }
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field standbyPartitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<TopicPartition> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(new TopicPartition(_readable, _version));
                    }
                    this.standbyPartitions = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            userEndpoint.write(_writable, _cache, _version);
            _writable.writeUnsignedVarint(activePartitions.size() + 1);
            for (TopicPartition activePartitionsElement : activePartitions) {
                activePartitionsElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(standbyPartitions.size() + 1);
            for (TopicPartition standbyPartitionsElement : standbyPartitions) {
                standbyPartitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EndpointToPartitions");
            }
            {
                this.userEndpoint.addSize(_size, _cache, _version);
            }
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(activePartitions.size() + 1));
                for (TopicPartition activePartitionsElement : activePartitions) {
                    activePartitionsElement.addSize(_size, _cache, _version);
                }
            }
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(standbyPartitions.size() + 1));
                for (TopicPartition standbyPartitionsElement : standbyPartitions) {
                    standbyPartitionsElement.addSize(_size, _cache, _version);
                }
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EndpointToPartitions)) return false;
            EndpointToPartitions other = (EndpointToPartitions) obj;
            if (this.userEndpoint == null) {
                if (other.userEndpoint != null) return false;
            } else {
                if (!this.userEndpoint.equals(other.userEndpoint)) return false;
            }
            if (this.activePartitions == null) {
                if (other.activePartitions != null) return false;
            } else {
                if (!this.activePartitions.equals(other.activePartitions)) return false;
            }
            if (this.standbyPartitions == null) {
                if (other.standbyPartitions != null) return false;
            } else {
                if (!this.standbyPartitions.equals(other.standbyPartitions)) return false;
            }
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (userEndpoint == null ? 0 : userEndpoint.hashCode());
            hashCode = 31 * hashCode + (activePartitions == null ? 0 : activePartitions.hashCode());
            hashCode = 31 * hashCode + (standbyPartitions == null ? 0 : standbyPartitions.hashCode());
            return hashCode;
        }
        
        @Override
        public EndpointToPartitions duplicate() {
            EndpointToPartitions _duplicate = new EndpointToPartitions();
            _duplicate.userEndpoint = userEndpoint.duplicate();
            ArrayList<TopicPartition> newActivePartitions = new ArrayList<TopicPartition>(activePartitions.size());
            for (TopicPartition _element : activePartitions) {
                newActivePartitions.add(_element.duplicate());
            }
            _duplicate.activePartitions = newActivePartitions;
            ArrayList<TopicPartition> newStandbyPartitions = new ArrayList<TopicPartition>(standbyPartitions.size());
            for (TopicPartition _element : standbyPartitions) {
                newStandbyPartitions.add(_element.duplicate());
            }
            _duplicate.standbyPartitions = newStandbyPartitions;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "EndpointToPartitions("
                + "userEndpoint=" + userEndpoint.toString()
                + ", activePartitions=" + MessageUtil.deepToString(activePartitions.iterator())
                + ", standbyPartitions=" + MessageUtil.deepToString(standbyPartitions.iterator())
                + ")";
        }
        
        public Endpoint userEndpoint() {
            return this.userEndpoint;
        }
        
        public List<TopicPartition> activePartitions() {
            return this.activePartitions;
        }
        
        public List<TopicPartition> standbyPartitions() {
            return this.standbyPartitions;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public EndpointToPartitions setUserEndpoint(Endpoint v) {
            this.userEndpoint = v;
            return this;
        }
        
        public EndpointToPartitions setActivePartitions(List<TopicPartition> v) {
            this.activePartitions = v;
            return this;
        }
        
        public EndpointToPartitions setStandbyPartitions(List<TopicPartition> v) {
            this.standbyPartitions = v;
            return this;
        }
    }
    
    public static class Endpoint implements Message {
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("host", Type.COMPACT_STRING, "host of the endpoint"),
                new Field("port", Type.UINT16, "port of the endpoint"),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public Endpoint(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public Endpoint() {
            this.host = "";
            this.port = 0;
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 32767;
        }
        
        @Override
        public final void read(Readable _readable, short _version) {
            {
                int length;
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field host was serialized as null");
                } else if (length > 0x7fff) {
                    throw new RuntimeException("string field host had invalid length " + length);
                } else {
                    this.host = _readable.readString(length);
                }
            }
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            {
                byte[] _stringBytes = _cache.getSerializedValue(host);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedShort(port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            {
                byte[] _stringBytes = host.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > 0x7fff) {
                    throw new RuntimeException("'host' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(host, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(2);
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Endpoint)) return false;
            Endpoint other = (Endpoint) obj;
            if (this.host == null) {
                if (other.host != null) return false;
            } else {
                if (!this.host.equals(other.host)) return false;
            }
            if (port != other.port) return false;
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (host == null ? 0 : host.hashCode());
            hashCode = 31 * hashCode + port;
            return hashCode;
        }
        
        @Override
        public Endpoint duplicate() {
            Endpoint _duplicate = new Endpoint();
            _duplicate.host = host;
            _duplicate.port = port;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "Endpoint("
                + "host=" + ((host == null) ? "null" : "'" + host.toString() + "'")
                + ", port=" + port
                + ")";
        }
        
        public String host() {
            return this.host;
        }
        
        public int port() {
            return this.port;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public Endpoint setHost(String v) {
            this.host = v;
            return this;
        }
        
        public Endpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }
    }
    
    public static class Status implements Message {
        byte statusCode;
        String statusDetail;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("status_code", Type.INT8, "A code to indicate that a particular status is active for the group membership"),
                new Field("status_detail", Type.COMPACT_STRING, "A string representation of the status."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public Status(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public Status() {
            this.statusCode = (byte) 0;
            this.statusDetail = "";
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 32767;
        }
        
        @Override
        public final void read(Readable _readable, short _version) {
            this.statusCode = _readable.readByte();
            {
                int length;
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field statusDetail was serialized as null");
                } else if (length > 0x7fff) {
                    throw new RuntimeException("string field statusDetail had invalid length " + length);
                } else {
                    this.statusDetail = _readable.readString(length);
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeByte(statusCode);
            {
                byte[] _stringBytes = _cache.getSerializedValue(statusDetail);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(1);
            {
                byte[] _stringBytes = statusDetail.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > 0x7fff) {
                    throw new RuntimeException("'statusDetail' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(statusDetail, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Status)) return false;
            Status other = (Status) obj;
            if (statusCode != other.statusCode) return false;
            if (this.statusDetail == null) {
                if (other.statusDetail != null) return false;
            } else {
                if (!this.statusDetail.equals(other.statusDetail)) return false;
            }
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + statusCode;
            hashCode = 31 * hashCode + (statusDetail == null ? 0 : statusDetail.hashCode());
            return hashCode;
        }
        
        @Override
        public Status duplicate() {
            Status _duplicate = new Status();
            _duplicate.statusCode = statusCode;
            _duplicate.statusDetail = statusDetail;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "Status("
                + "statusCode=" + statusCode
                + ", statusDetail=" + ((statusDetail == null) ? "null" : "'" + statusDetail.toString() + "'")
                + ")";
        }
        
        public byte statusCode() {
            return this.statusCode;
        }
        
        public String statusDetail() {
            return this.statusDetail;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public Status setStatusCode(byte v) {
            this.statusCode = v;
            return this;
        }
        
        public Status setStatusDetail(String v) {
            this.statusDetail = v;
            return this;
        }
    }
    
    public static class TaskIds implements Message {
        String subtopologyId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("subtopology_id", Type.COMPACT_STRING, "The subtopology identifier."),
                new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions of the input topics processed by this member."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public TaskIds(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public TaskIds() {
            this.subtopologyId = "";
            this.partitions = new ArrayList<Integer>(0);
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 32767;
        }
        
        @Override
        public final void read(Readable _readable, short _version) {
            {
                int length;
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
                } else if (length > 0x7fff) {
                    throw new RuntimeException("string field subtopologyId had invalid length " + length);
                } else {
                    this.subtopologyId = _readable.readString(length);
                }
            }
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(_readable.readInt());
                    }
                    this.partitions = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            {
                byte[] _stringBytes = _cache.getSerializedValue(subtopologyId);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(partitions.size() + 1);
            for (Integer partitionsElement : partitions) {
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            {
                byte[] _stringBytes = subtopologyId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > 0x7fff) {
                    throw new RuntimeException("'subtopologyId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(subtopologyId, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(partitions.size() + 1));
                _size.addBytes(partitions.size() * 4);
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TaskIds)) return false;
            TaskIds other = (TaskIds) obj;
            if (this.subtopologyId == null) {
                if (other.subtopologyId != null) return false;
            } else {
                if (!this.subtopologyId.equals(other.subtopologyId)) return false;
            }
            if (this.partitions == null) {
                if (other.partitions != null) return false;
            } else {
                if (!this.partitions.equals(other.partitions)) return false;
            }
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (subtopologyId == null ? 0 : subtopologyId.hashCode());
            hashCode = 31 * hashCode + (partitions == null ? 0 : partitions.hashCode());
            return hashCode;
        }
        
        @Override
        public TaskIds duplicate() {
            TaskIds _duplicate = new TaskIds();
            _duplicate.subtopologyId = subtopologyId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(partitions.size());
            for (Integer _element : partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "TaskIds("
                + "subtopologyId=" + ((subtopologyId == null) ? "null" : "'" + subtopologyId.toString() + "'")
                + ", partitions=" + MessageUtil.deepToString(partitions.iterator())
                + ")";
        }
        
        public String subtopologyId() {
            return this.subtopologyId;
        }
        
        public List<Integer> partitions() {
            return this.partitions;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public TaskIds setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }
        
        public TaskIds setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }
    
    public static class TopicPartition implements Message {
        String topic;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("topic", Type.COMPACT_STRING, "topic name"),
                new Field("partitions", new CompactArrayOf(Type.INT32), "partitions"),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public TopicPartition(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public TopicPartition() {
            this.topic = "";
            this.partitions = new ArrayList<Integer>(0);
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 32767;
        }
        
        @Override
        public final void read(Readable _readable, short _version) {
            {
                int length;
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topic was serialized as null");
                } else if (length > 0x7fff) {
                    throw new RuntimeException("string field topic had invalid length " + length);
                } else {
                    this.topic = _readable.readString(length);
                }
            }
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(_readable.readInt());
                    }
                    this.partitions = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            {
                byte[] _stringBytes = _cache.getSerializedValue(topic);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(partitions.size() + 1);
            for (Integer partitionsElement : partitions) {
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            {
                byte[] _stringBytes = topic.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > 0x7fff) {
                    throw new RuntimeException("'topic' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(topic, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(partitions.size() + 1));
                _size.addBytes(partitions.size() * 4);
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartition)) return false;
            TopicPartition other = (TopicPartition) obj;
            if (this.topic == null) {
                if (other.topic != null) return false;
            } else {
                if (!this.topic.equals(other.topic)) return false;
            }
            if (this.partitions == null) {
                if (other.partitions != null) return false;
            } else {
                if (!this.partitions.equals(other.partitions)) return false;
            }
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (topic == null ? 0 : topic.hashCode());
            hashCode = 31 * hashCode + (partitions == null ? 0 : partitions.hashCode());
            return hashCode;
        }
        
        @Override
        public TopicPartition duplicate() {
            TopicPartition _duplicate = new TopicPartition();
            _duplicate.topic = topic;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(partitions.size());
            for (Integer _element : partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "TopicPartition("
                + "topic=" + ((topic == null) ? "null" : "'" + topic.toString() + "'")
                + ", partitions=" + MessageUtil.deepToString(partitions.iterator())
                + ")";
        }
        
        public String topic() {
            return this.topic;
        }
        
        public List<Integer> partitions() {
            return this.partitions;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public TopicPartition setTopic(String v) {
            this.topic = v;
            return this;
        }
        
        public TopicPartition setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }
}
