/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.common.message.ListConfigResourcesResponseData.*;

public class ListConfigResourcesResponseDataJsonConverter {
    public static ListConfigResourcesResponseData read(JsonNode _node, short _version) {
        ListConfigResourcesResponseData _object = new ListConfigResourcesResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("ListConfigResourcesResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        } else {
            _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "ListConfigResourcesResponseData");
        }
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("ListConfigResourcesResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        } else {
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "ListConfigResourcesResponseData");
        }
        JsonNode _configResourcesNode = _node.get("configResources");
        if (_configResourcesNode == null) {
            throw new RuntimeException("ListConfigResourcesResponseData: unable to locate field 'configResources', which is mandatory in version " + _version);
        } else {
            if (!_configResourcesNode.isArray()) {
                throw new RuntimeException("ListConfigResourcesResponseData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<ConfigResource> _collection = new ArrayList<ConfigResource>(_configResourcesNode.size());
            _object.configResources = _collection;
            for (JsonNode _element : _configResourcesNode) {
                _collection.add(ConfigResourceJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }
    public static JsonNode write(ListConfigResourcesResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", new IntNode(_object.throttleTimeMs));
        _node.set("errorCode", new ShortNode(_object.errorCode));
        ArrayNode _configResourcesArray = new ArrayNode(JsonNodeFactory.instance);
        for (ConfigResource _element : _object.configResources) {
            _configResourcesArray.add(ConfigResourceJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("configResources", _configResourcesArray);
        return _node;
    }
    public static JsonNode write(ListConfigResourcesResponseData _object, short _version) {
        return write(_object, _version, true);
    }
    
    public static class ConfigResourceJsonConverter {
        public static ConfigResource read(JsonNode _node, short _version) {
            ConfigResource _object = new ConfigResource();
            JsonNode _resourceNameNode = _node.get("resourceName");
            if (_resourceNameNode == null) {
                throw new RuntimeException("ConfigResource: unable to locate field 'resourceName', which is mandatory in version " + _version);
            } else {
                if (!_resourceNameNode.isTextual()) {
                    throw new RuntimeException("ConfigResource expected a string type, but got " + _node.getNodeType());
                }
                _object.resourceName = _resourceNameNode.asText();
            }
            JsonNode _resourceTypeNode = _node.get("resourceType");
            if (_resourceTypeNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("ConfigResource: unable to locate field 'resourceType', which is mandatory in version " + _version);
                } else {
                    _object.resourceType = (byte) 16;
                }
            } else {
                _object.resourceType = MessageUtil.jsonNodeToByte(_resourceTypeNode, "ConfigResource");
            }
            return _object;
        }
        public static JsonNode write(ConfigResource _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("resourceName", new TextNode(_object.resourceName));
            if (_version >= 1) {
                _node.set("resourceType", new ShortNode(_object.resourceType));
            }
            return _node;
        }
        public static JsonNode write(ConfigResource _object, short _version) {
            return write(_object, _version, true);
        }
    }
}
