/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ReportClusterLinkStatusRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ReportClusterLinkStatusResponse;

public class ReportClusterLinkStatusRequest
extends AbstractRequest {
    private final ReportClusterLinkStatusRequestData data;

    public ReportClusterLinkStatusRequest(ReportClusterLinkStatusRequestData data, short version) {
        super(ApiKeys.REPORT_CLUSTER_LINK_STATUS, version);
        this.data = data;
    }

    public static ReportClusterLinkStatusRequest parse(Readable readable, short version, MessageContext context) {
        return new ReportClusterLinkStatusRequest(new ReportClusterLinkStatusRequestData(readable, version, context), version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new ReportClusterLinkStatusResponse(throttleTimeMs, e);
    }

    @Override
    public ReportClusterLinkStatusRequestData data() {
        return this.data;
    }

    public Optional<List<ClusterLinkMirrorState>> clusterLinkMirrorStates() {
        return Optional.of(this.data.linkMirrorStates().stream().map(linkMirrorState -> new ClusterLinkMirrorState(linkMirrorState.linkName(), linkMirrorState.mirrorStates().stream().map(mirrorState -> new PartitionMirrorState(mirrorState.partitionId(), mirrorState.topicName(), ReplicaStatus.MirrorInfo.State.valueOf(mirrorState.mirrorState()))).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    public Optional<List<String>> linkNames() {
        return Optional.of(this.data.linkMirrorStates().stream().map(ReportClusterLinkStatusRequestData.LinkMirrorState::linkName).collect(Collectors.toList()));
    }

    public int publisherBrokerId() {
        return this.data.brokerId();
    }

    public static class ClusterLinkMirrorState {
        private final String linkName;
        private final List<PartitionMirrorState> partitionStates;

        public ClusterLinkMirrorState(String linkName, List<PartitionMirrorState> partitionStates) {
            this.linkName = linkName;
            this.partitionStates = partitionStates;
        }

        public String linkName() {
            return this.linkName;
        }

        public List<PartitionMirrorState> partitionStates() {
            return this.partitionStates;
        }

        public String toString() {
            return "ClusterLinkMirrorState{linkName='" + this.linkName + "', partitionStates=" + String.valueOf(this.partitionStates) + "}";
        }
    }

    public static class PartitionMirrorState {
        private final int partitionId;
        private final String topicName;
        private final ReplicaStatus.MirrorInfo.State state;

        public PartitionMirrorState(int partitionId, String topicName, ReplicaStatus.MirrorInfo.State state) {
            this.partitionId = partitionId;
            this.topicName = topicName;
            this.state = state;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public ReplicaStatus.MirrorInfo.State state() {
            return this.state;
        }

        public String topicName() {
            return this.topicName;
        }

        public String toString() {
            return "PartitionMirrorState{partitionId=" + this.partitionId + ", topicName='" + this.topicName + "', state=" + String.valueOf((Object)this.state) + "}";
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<ReportClusterLinkStatusRequest> {
        private final ReportClusterLinkStatusRequestData data = new ReportClusterLinkStatusRequestData();

        public Builder(int publisherBrokerId, int timeoutMs, List<ClusterLinkMirrorState> states) {
            super(ApiKeys.REPORT_CLUSTER_LINK_STATUS);
            this.data.setBrokerId(publisherBrokerId).setTimeoutMs(timeoutMs).setLinkMirrorStates(states.stream().map(linkState -> new ReportClusterLinkStatusRequestData.LinkMirrorState().setLinkName(linkState.linkName).setMirrorStates(linkState.partitionStates.stream().map(state -> new ReportClusterLinkStatusRequestData.MirrorState().setPartitionId(state.partitionId).setTopicName(state.topicName).setMirrorState(state.state.name())).collect(Collectors.toList()))).collect(Collectors.toList()));
        }

        @Override
        public ReportClusterLinkStatusRequest build(short version) {
            return new ReportClusterLinkStatusRequest(this.data, version);
        }
    }
}

