/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchSnapshotResponse;

public final class FetchSnapshotRequest
extends AbstractRequest {
    private final FetchSnapshotRequestData data;

    public FetchSnapshotRequest(FetchSnapshotRequestData data, short version) {
        super(ApiKeys.FETCH_SNAPSHOT, version);
        this.data = data;
    }

    @Override
    public FetchSnapshotResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new FetchSnapshotResponse(new FetchSnapshotResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()));
    }

    @Override
    public FetchSnapshotRequestData data() {
        return this.data;
    }

    public static Optional<FetchSnapshotRequestData.PartitionSnapshot> forTopicPartition(FetchSnapshotRequestData data, TopicPartition topicPartition) {
        return data.topics().stream().filter(topic -> topic.name().equals(topicPartition.topic())).flatMap(topic -> topic.partitions().stream()).filter(partition -> partition.partition() == topicPartition.partition()).findAny();
    }

    public static FetchSnapshotRequest parse(Readable readable, short version, MessageContext context) {
        return new FetchSnapshotRequest(new FetchSnapshotRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<FetchSnapshotRequest> {
        private final FetchSnapshotRequestData data;

        public Builder(FetchSnapshotRequestData data) {
            super(ApiKeys.FETCH_SNAPSHOT);
            this.data = data;
        }

        @Override
        public FetchSnapshotRequest build(short version) {
            return new FetchSnapshotRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

