/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;

public class DescribeAclsRequest
extends AbstractRequest {
    private final DescribeAclsRequestData data;

    private DescribeAclsRequest(DescribeAclsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_ACLS, version);
        this.data = data;
        this.normalizeAndValidate(version);
    }

    private void normalizeAndValidate(short version) {
        if (version == 0) {
            PatternType patternType = PatternType.fromCode(this.data.patternTypeFilter());
            if (patternType == PatternType.ANY) {
                this.data.setPatternTypeFilter(PatternType.LITERAL.code());
            } else if (patternType != PatternType.LITERAL) {
                throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
            }
        }
        if (this.data.patternTypeFilter() == PatternType.UNKNOWN.code() || this.data.resourceTypeFilter() == ResourceType.UNKNOWN.code() || this.data.permissionType() == AclPermissionType.UNKNOWN.code() || this.data.operation() == AclOperation.UNKNOWN.code() || this.data.aclState() == AclState.UNKNOWN.code()) {
            throw new IllegalArgumentException("DescribeAclsRequest contains UNKNOWN elements: " + String.valueOf(this.data));
        }
    }

    @Override
    public DescribeAclsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        ApiError error = ApiError.fromThrowable(throwable);
        DescribeAclsResponseData response = new DescribeAclsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.error().code()).setErrorMessage(error.message());
        return new DescribeAclsResponse(response, this.version());
    }

    public static DescribeAclsRequest parse(Readable readable, short version, MessageContext context) {
        DescribeAclsRequestData requestData = new DescribeAclsRequestData(readable, version, context);
        DescribeAclsRequestData processedData = (DescribeAclsRequestData)context.read(EntityType.ACL_RESOURCE_FILTER, requestData);
        return new DescribeAclsRequest(processedData, version);
    }

    public AclBindingFilter filter() {
        ResourcePatternFilter rpf = new ResourcePatternFilter(ResourceType.fromCode(this.data.resourceTypeFilter()), this.data.resourceNameFilter(), PatternType.fromCode(this.data.patternTypeFilter()));
        AccessControlEntryFilter acef = new AccessControlEntryFilter(this.data.principalFilter(), this.data.hostFilter(), AclOperation.fromCode(this.data.operation()), AclPermissionType.fromCode(this.data.permissionType()), this.data.clusterLinkIds());
        return new AclBindingFilter(rpf, acef);
    }

    public AclState aclState() {
        AclState aclState = AclState.fromCode(this.data.aclState());
        return aclState;
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeAclsRequest> {
        private final DescribeAclsRequestData data;

        public Builder(AclBindingFilter filter) {
            super(ApiKeys.DESCRIBE_ACLS);
            ResourcePatternFilter patternFilter = filter.patternFilter();
            AccessControlEntryFilter entryFilter = filter.entryFilter();
            this.data = new DescribeAclsRequestData().setHostFilter(entryFilter.host()).setOperation(entryFilter.operation().code()).setPermissionType(entryFilter.permissionType().code()).setPrincipalFilter(entryFilter.principal()).setClusterLinkIds(new ArrayList<Uuid>(entryFilter.clusterLinkIds())).setResourceNameFilter(patternFilter.name()).setPatternTypeFilter(patternFilter.patternType().code()).setResourceTypeFilter(patternFilter.resourceType().code());
        }

        public Builder setAclState(AclState aclState) {
            this.data.setAclState(aclState.code());
            return this;
        }

        @Override
        public DescribeAclsRequest build(short version) {
            return new DescribeAclsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

