/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class ApiVersionsResponse
extends AbstractResponse {
    public static final long UNKNOWN_FINALIZED_FEATURES_EPOCH = -1L;
    private final ApiVersionsResponseData data;

    public ApiVersionsResponse(ApiVersionsResponseData data) {
        super(ApiKeys.API_VERSIONS);
        this.data = data;
    }

    @Override
    public ApiVersionsResponseData data() {
        return this.data;
    }

    public ApiVersionsResponseData.ApiVersion apiVersion(short apiKey) {
        return this.data.apiKeys().find(apiKey);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return ApiVersionsResponse.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public boolean zkMigrationReady() {
        return this.data.zkMigrationReady();
    }

    public static ApiVersionsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        int prev = buffer.position();
        try {
            return new ApiVersionsResponse(new ApiVersionsResponseData(new ByteBufferAccessor(buffer), version, context));
        }
        catch (RuntimeException e) {
            buffer.position(prev);
            if (version != 0) {
                return new ApiVersionsResponse(new ApiVersionsResponseData(new ByteBufferAccessor(buffer), 0, context));
            }
            throw e;
        }
    }

    public static ApiVersionsResponseData.ApiVersionCollection controllerApiVersions(NodeApiVersions controllerApiVersions, ApiMessageType.ListenerType listenerType, boolean enableUnstableLastVersion, boolean clientTelemetryEnabled, ApiMessageType.ApiVisibility apiVisibility, boolean describeTopicPartitionsEnabled) {
        return ApiVersionsResponse.intersectForwardableApis(listenerType, controllerApiVersions.allSupportedApiVersions(), enableUnstableLastVersion, apiVisibility, clientTelemetryEnabled, describeTopicPartitionsEnabled);
    }

    public static ApiVersionsResponseData.ApiVersionCollection brokerApiVersions(ApiMessageType.ListenerType listenerType, boolean enableUnstableLastVersion, boolean clientTelemetryEnabled, ApiMessageType.ApiVisibility apiVisibility, boolean describeTopicPartitionsEnabled) {
        return ApiVersionsResponse.filterApis(listenerType, enableUnstableLastVersion, apiVisibility, clientTelemetryEnabled, describeTopicPartitionsEnabled);
    }

    public static ApiVersionsResponseData.ApiVersionCollection filterApis(ApiMessageType.ListenerType listenerType, boolean enableUnstableLastVersion, ApiMessageType.ApiVisibility apiVisibility, boolean clientTelemetryEnabled, boolean describeTopicPartitionsEnabled) {
        ApiVersionsResponseData.ApiVersionCollection apiKeys = new ApiVersionsResponseData.ApiVersionCollection();
        for (ApiKeys apiKey : ApiKeys.apisForListener(listenerType)) {
            if ((apiKey == ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS || apiKey == ApiKeys.PUSH_TELEMETRY) && !clientTelemetryEnabled || apiKey == ApiKeys.DESCRIBE_TOPIC_PARTITIONS && !describeTopicPartitionsEnabled || !apiKey.isApiVisible(apiVisibility)) continue;
            apiKey.toApiVersionForApiResponse(enableUnstableLastVersion, listenerType).ifPresent(apiKeys::add);
        }
        return apiKeys;
    }

    public static ApiVersionsResponseData.ApiVersionCollection collectApis(ApiMessageType.ListenerType listenerType, Set<ApiKeys> apiKeys, boolean enableUnstableLastVersion, ApiMessageType.ApiVisibility apiVisibility) {
        ApiVersionsResponseData.ApiVersionCollection res = new ApiVersionsResponseData.ApiVersionCollection();
        for (ApiKeys apiKey : apiKeys) {
            if (!apiKey.isApiVisible(apiVisibility)) continue;
            apiKey.toApiVersionForApiResponse(enableUnstableLastVersion, listenerType).ifPresent(res::add);
        }
        return res;
    }

    public static ApiVersionsResponseData.ApiVersionCollection intersectForwardableApis(ApiMessageType.ListenerType listenerType, Map<ApiKeys, ApiVersionsResponseData.ApiVersion> activeControllerApiVersions, boolean enableUnstableLastVersion, ApiMessageType.ApiVisibility apiVisibility, boolean clientTelemetryEnabled, boolean describeTopicPartitionsEnabled) {
        ApiVersionsResponseData.ApiVersionCollection apiKeys = new ApiVersionsResponseData.ApiVersionCollection();
        for (ApiKeys apiKey : ApiKeys.apisForListener(listenerType)) {
            ApiVersionsResponseData.ApiVersion finalApiVersion;
            Optional<ApiVersionsResponseData.ApiVersion> brokerApiVersion;
            if (!apiKey.isApiVisible(apiVisibility) || (brokerApiVersion = apiKey.toApiVersionForApiResponse(enableUnstableLastVersion, listenerType)).isEmpty() || (apiKey == ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS || apiKey == ApiKeys.PUSH_TELEMETRY) && !clientTelemetryEnabled || apiKey == ApiKeys.DESCRIBE_TOPIC_PARTITIONS && !describeTopicPartitionsEnabled) continue;
            if (!apiKey.forwardable) {
                finalApiVersion = brokerApiVersion.get();
            } else {
                Optional<ApiVersionsResponseData.ApiVersion> intersectVersion = ApiVersionsResponse.intersect(brokerApiVersion.get(), activeControllerApiVersions.getOrDefault((Object)apiKey, null));
                if (!intersectVersion.isPresent()) continue;
                finalApiVersion = intersectVersion.get();
            }
            apiKeys.add(finalApiVersion.duplicate());
        }
        return apiKeys;
    }

    private static ApiVersionsResponseData.SupportedFeatureKeyCollection maybeFilterSupportedFeatureKeys(Features<SupportedVersionRange> latestSupportedFeatures, boolean alterV0) {
        ApiVersionsResponseData.SupportedFeatureKeyCollection converted = new ApiVersionsResponseData.SupportedFeatureKeyCollection();
        for (Map.Entry<String, SupportedVersionRange> feature : latestSupportedFeatures.features().entrySet()) {
            SupportedVersionRange versionRange = feature.getValue();
            if (alterV0 && versionRange.min() == 0) continue;
            ApiVersionsResponseData.SupportedFeatureKey key = new ApiVersionsResponseData.SupportedFeatureKey();
            key.setName(feature.getKey());
            key.setMinVersion(versionRange.min());
            key.setMaxVersion(versionRange.max());
            converted.add(key);
        }
        return converted;
    }

    private static ApiVersionsResponseData.FinalizedFeatureKeyCollection createFinalizedFeatureKeys(Map<String, Short> finalizedFeatures) {
        ApiVersionsResponseData.FinalizedFeatureKeyCollection converted = new ApiVersionsResponseData.FinalizedFeatureKeyCollection();
        for (Map.Entry<String, Short> feature : finalizedFeatures.entrySet()) {
            ApiVersionsResponseData.FinalizedFeatureKey key = new ApiVersionsResponseData.FinalizedFeatureKey();
            short versionLevel = feature.getValue();
            if (versionLevel == 0) continue;
            key.setName(feature.getKey());
            key.setMinVersionLevel(versionLevel);
            key.setMaxVersionLevel(versionLevel);
            converted.add(key);
        }
        return converted;
    }

    public static Optional<ApiVersionsResponseData.ApiVersion> intersect(ApiVersionsResponseData.ApiVersion thisVersion, ApiVersionsResponseData.ApiVersion other) {
        short maxVersion;
        if (thisVersion == null || other == null) {
            return Optional.empty();
        }
        if (thisVersion.apiKey() != other.apiKey()) {
            throw new IllegalArgumentException("thisVersion.apiKey: " + thisVersion.apiKey() + " must be equal to other.apiKey: " + other.apiKey());
        }
        short minVersion = (short)Math.max(thisVersion.minVersion(), other.minVersion());
        return minVersion > (maxVersion = (short)Math.min(thisVersion.maxVersion(), other.maxVersion())) ? Optional.empty() : Optional.of(new ApiVersionsResponseData.ApiVersion().setApiKey(thisVersion.apiKey()).setMinVersion(minVersion).setMaxVersion(maxVersion));
    }

    public static ApiVersionsResponseData.ApiVersion toApiVersion(ApiKeys apiKey) {
        return new ApiVersionsResponseData.ApiVersion().setApiKey(apiKey.id).setMinVersion(apiKey.oldestVersion()).setMaxVersion(apiKey.latestVersion());
    }

    public static class Builder {
        private Errors error = Errors.NONE;
        private int throttleTimeMs = 0;
        private ApiVersionsResponseData.ApiVersionCollection apiVersions = null;
        private Features<SupportedVersionRange> supportedFeatures = null;
        private Map<String, Short> finalizedFeatures = null;
        private long finalizedFeaturesEpoch = 0L;
        private boolean zkMigrationEnabled = false;
        private boolean alterFeatureLevel0 = false;

        public Builder setError(Errors error) {
            this.error = error;
            return this;
        }

        public Builder setThrottleTimeMs(int throttleTimeMs) {
            this.throttleTimeMs = throttleTimeMs;
            return this;
        }

        public Builder setApiVersions(ApiVersionsResponseData.ApiVersionCollection apiVersions) {
            this.apiVersions = apiVersions;
            return this;
        }

        public Builder setSupportedFeatures(Features<SupportedVersionRange> supportedFeatures) {
            this.supportedFeatures = supportedFeatures;
            return this;
        }

        public Builder setFinalizedFeatures(Map<String, Short> finalizedFeatures) {
            this.finalizedFeatures = finalizedFeatures;
            return this;
        }

        public Builder setFinalizedFeaturesEpoch(long finalizedFeaturesEpoch) {
            this.finalizedFeaturesEpoch = finalizedFeaturesEpoch;
            return this;
        }

        public Builder setZkMigrationEnabled(boolean zkMigrationEnabled) {
            this.zkMigrationEnabled = zkMigrationEnabled;
            return this;
        }

        public Builder setAlterFeatureLevel0(boolean alterFeatureLevel0) {
            this.alterFeatureLevel0 = alterFeatureLevel0;
            return this;
        }

        public ApiVersionsResponse build() {
            ApiVersionsResponseData data = new ApiVersionsResponseData();
            data.setErrorCode(this.error.code());
            data.setApiKeys(Objects.requireNonNull(this.apiVersions));
            data.setThrottleTimeMs(this.throttleTimeMs);
            data.setSupportedFeatures(ApiVersionsResponse.maybeFilterSupportedFeatureKeys(Objects.requireNonNull(this.supportedFeatures), this.alterFeatureLevel0));
            data.setFinalizedFeatures(ApiVersionsResponse.createFinalizedFeatureKeys(Objects.requireNonNull(this.finalizedFeatures)));
            data.setFinalizedFeaturesEpoch(this.finalizedFeaturesEpoch);
            data.setZkMigrationReady(this.zkMigrationEnabled);
            return new ApiVersionsResponse(data);
        }
    }
}

