/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.audit;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.kafka.common.utils.Lazy;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;

public class DefaultKafkaRequestEvent
implements KafkaRequestEvent {
    private final Instant timestamp;
    private final String requestSourceCrn;
    private final JsonNode requestPayload;
    private final JsonNode responsePayload;
    private final AuthorizableRequestContext requestContext;
    private final Lazy<UUID> lazyUUID;
    private Map<String, Object> data = Collections.emptyMap();

    public DefaultKafkaRequestEvent(String requestSourceCrn, AuthorizableRequestContext requestContext, JsonNode requestPayload, JsonNode responsePayload) {
        this.requestSourceCrn = requestSourceCrn;
        this.requestContext = requestContext;
        this.requestPayload = requestPayload;
        this.responsePayload = responsePayload;
        this.lazyUUID = new Lazy();
        this.timestamp = Instant.now();
    }

    @Override
    public String requestSourceCrn() {
        return this.requestSourceCrn;
    }

    @Override
    public AuthorizableRequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public JsonNode requestPayload() {
        return this.requestPayload;
    }

    @Override
    public JsonNode responsePayload() {
        return this.responsePayload;
    }

    @Override
    public UUID uuid() {
        return this.lazyUUID.getOrCompute(UUID::randomUUID);
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public AuditEventType type() {
        return AuditEventType.KAFKA_REQUEST;
    }

    @Override
    public AuditEventStatus status() {
        return AuditEventStatus.SUCCESS;
    }

    @Override
    public Map<String, Object> data() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultKafkaRequestEvent that = (DefaultKafkaRequestEvent)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.requestSourceCrn, that.requestSourceCrn) && Objects.equals(this.requestPayload, that.requestPayload) && Objects.equals(this.responsePayload, that.responsePayload) && Objects.equals(this.requestContext, that.requestContext) && Objects.equals(this.lazyUUID, that.lazyUUID) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.requestSourceCrn, this.requestPayload, this.responsePayload, this.requestContext, this.lazyUUID, this.data);
    }
}

