/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeClusterLinksResponse
extends AbstractResponse {
    private final DescribeClusterLinksResponseData data;

    public DescribeClusterLinksResponse(DescribeClusterLinksResponseData data) {
        super(ApiKeys.DESCRIBE_CLUSTER_LINKS);
        this.data = data;
    }

    public DescribeClusterLinksResponse(int throttleTimeMs, Throwable e) {
        super(ApiKeys.DESCRIBE_CLUSTER_LINKS);
        this.data = new DescribeClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setErrorMessage(e.getMessage());
    }

    public void complete(KafkaFutureImpl<Collection<ClusterLinkDescription>> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            result.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        ArrayList<ClusterLinkDescription> clusterLinks = new ArrayList<ClusterLinkDescription>(this.data.entries().size());
        for (DescribeClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            clusterLinks.add(DescribeClusterLinksResponse.toAdminClientLinkDescription(entryData));
        }
        result.complete(clusterLinks);
    }

    public static ClusterLinkDescription toAdminClientLinkDescription(DescribeClusterLinksResponseData.EntryData entryData) {
        ClusterLinkDescription linkDescription = new ClusterLinkDescription.Builder().setLinkName(entryData.linkName()).setLinkId(entryData.linkId()).setRemoteClusterId(entryData.remoteClusterId()).setLocalClusterId(entryData.localClusterId()).setTopics(entryData.topics()).setLinkState(ClusterLinkDescription.LinkState.fromShort(entryData.linkState())).setLinkMode(ClusterLinkDescription.LinkMode.fromShort(entryData.linkMode())).setConnectionMode(ClusterLinkDescription.ConnectionMode.fromShort(entryData.connectionMode())).setClusterLinkError(ClusterLinkError.fromShort(entryData.linkErrorCode())).setLinkErrorMessage(entryData.linkErrorMessage()).setLinkCoordinator(new Node(entryData.linkCoordinatorId(), entryData.linkCoordinatorHost(), entryData.linkCoordinatorPort())).setRemoteLinkState(ClusterLinkDescription.LinkState.fromShort(entryData.remoteLinkState())).setRemoteLinkError(ClusterLinkError.fromShort(entryData.remoteLinkErrorCode())).setRemoteLinkErrorMessage(entryData.remoteLinkErrorMessage()).setRemoteLinkState(ClusterLinkDescription.LinkState.fromShort(entryData.remoteLinkState())).setRemoteLinkStateTimeMs(entryData.remoteLinkStateTimeMs()).setTaskDescriptions(DescribeClusterLinksResponse.toAdminClientLinkTaskDescriptions(entryData.tasks())).setPartitionStateCategoryCounts(DescribeClusterLinksResponse.toCategoryCounts(entryData.partitionMirrorStateCategoryCounts())).build();
        return linkDescription;
    }

    public static List<ClusterLinkTaskDescription> toAdminClientLinkTaskDescriptions(List<DescribeClusterLinksResponseData.TaskData> taskDataList) {
        List<ClusterLinkTaskDescription> result = taskDataList == null ? Collections.emptyList() : taskDataList.stream().map(taskData -> {
            String name = taskData.name();
            ClusterLinkTaskDescription.ClusterLinkTaskState state = ClusterLinkTaskDescription.ClusterLinkTaskState.fromShort(taskData.state());
            List<ClusterLinkTaskError> errs = taskData.errors() == null ? Collections.emptyList() : taskData.errors().stream().map(err -> new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.fromShort(err.errorCode()), err.errorMessage())).collect(Collectors.toList());
            return new ClusterLinkTaskDescription(name, state, errs);
        }).collect(Collectors.toList());
        return result;
    }

    public static Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> toCategoryCounts(List<DescribeClusterLinksResponseData.PartitionMirrorStateCategoryCount> categoryCounts) {
        return categoryCounts.stream().collect(Collectors.toMap(categoryCount -> ReplicaStatus.MirrorInfo.StateCategory.valueOf(categoryCount.partitionMirrorStateCategory()), DescribeClusterLinksResponseData.PartitionMirrorStateCategoryCount::count));
    }

    public Set<String> clusterLinkNames() {
        HashSet<String> clusterLinkNames = new HashSet<String>();
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            return clusterLinkNames;
        }
        for (DescribeClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            clusterLinkNames.add(entryData.linkName());
        }
        return clusterLinkNames;
    }

    @Override
    public DescribeClusterLinksResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    public static DescribeClusterLinksResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeClusterLinksResponse(new DescribeClusterLinksResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

