/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.CreateClusterLinksResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class CreateClusterLinksResponse
extends AbstractResponse {
    private final CreateClusterLinksResponseData data;

    public CreateClusterLinksResponse(Map<String, ApiErrorAndOriginalThrowable> results, int throttleTimeMs) {
        super(ApiKeys.CREATE_CLUSTER_LINKS);
        ArrayList<CreateClusterLinksResponseData.EntryData> entryDatas = new ArrayList<CreateClusterLinksResponseData.EntryData>(results.size());
        for (Map.Entry<String, ApiErrorAndOriginalThrowable> resultsEntry : results.entrySet()) {
            ApiError e = resultsEntry.getValue().apiError;
            Errors errors = e.error();
            CreateClusterLinksResponseData.EntryData entryData = new CreateClusterLinksResponseData.EntryData().setErrorCode(errors.code()).setErrorMessage(e.message()).setLinkName(resultsEntry.getKey());
            CreateClusterLinksResponse.maybeAddLinkErrorInfo(entryData, resultsEntry.getValue().throwable);
            entryDatas.add(entryData);
        }
        this.data = new CreateClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entryDatas);
    }

    public CreateClusterLinksResponse(Collection<String> linkNames, int throttleTimeMs, Throwable e) {
        super(ApiKeys.CREATE_CLUSTER_LINKS);
        ApiError error = ApiError.fromThrowable(e);
        Errors errors = error.error();
        short errorCode = errors.code();
        String errorMessage = error.message();
        ArrayList<CreateClusterLinksResponseData.EntryData> entryDatas = new ArrayList<CreateClusterLinksResponseData.EntryData>(linkNames.size());
        for (String linkName : linkNames) {
            CreateClusterLinksResponseData.EntryData entryData = new CreateClusterLinksResponseData.EntryData().setErrorCode(errorCode).setErrorMessage(errorMessage).setLinkName(linkName);
            CreateClusterLinksResponse.maybeAddLinkErrorInfo(entryData, e);
            entryDatas.add(entryData);
        }
        this.data = new CreateClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entryDatas);
    }

    public CreateClusterLinksResponse updateResponseWithValidationErrors(Map<String, ApiErrorAndOriginalThrowable> validationErrors, int throttleMs) {
        if (validationErrors.isEmpty()) {
            return this;
        }
        ArrayList<CreateClusterLinksResponseData.EntryData> updatedEntries = new ArrayList<CreateClusterLinksResponseData.EntryData>(this.data.entries());
        for (Map.Entry<String, ApiErrorAndOriginalThrowable> entry : validationErrors.entrySet()) {
            String linkName = entry.getKey();
            ApiError apiError = entry.getValue().apiError;
            Errors error = apiError.error();
            String errorMessage = apiError.message();
            CreateClusterLinksResponseData.EntryData errorEntry = new CreateClusterLinksResponseData.EntryData().setLinkName(linkName).setErrorCode(error.code()).setErrorMessage(errorMessage);
            CreateClusterLinksResponse.maybeAddLinkErrorInfo(errorEntry, entry.getValue().throwable);
            updatedEntries.add(errorEntry);
        }
        CreateClusterLinksResponseData newData = new CreateClusterLinksResponseData().setEntries(updatedEntries).setThrottleTimeMs(throttleMs);
        return new CreateClusterLinksResponse(newData);
    }

    public static void maybeAddLinkErrorInfo(CreateClusterLinksResponseData.EntryData data, Throwable original) {
        Throwable unwrapped;
        if (original != null && (unwrapped = Errors.maybeUnwrapException(original)) instanceof InvalidClusterLinkException) {
            InvalidClusterLinkException exception = (InvalidClusterLinkException)unwrapped;
            data.setLinkErrorCode(exception.clusterLinkError().getValue());
            data.setLinkErrorMessage(exception.linkErrorMessage());
        }
    }

    public CreateClusterLinksResponse(CreateClusterLinksResponseData data) {
        super(ApiKeys.CREATE_CLUSTER_LINKS);
        this.data = data;
    }

    public void complete(Map<String, KafkaFutureImpl<Void>> results) {
        for (CreateClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            String linkName = entryData.linkName();
            KafkaFutureImpl<Void> future = results.get(linkName);
            if (future == null) {
                throw new IllegalArgumentException("Result must contain link with name: " + linkName);
            }
            Errors error = Errors.forCode(entryData.errorCode());
            if (error == Errors.NONE) {
                future.complete(null);
                continue;
            }
            if (entryData.errorCode() == Errors.INVALID_CLUSTER_LINK.code()) {
                future.completeExceptionally(new InvalidClusterLinkException(ClusterLinkError.fromShort(entryData.linkErrorCode()), entryData.linkErrorMessage(), entryData.errorMessage()));
                continue;
            }
            future.completeExceptionally(error.exception(entryData.errorMessage()));
        }
    }

    @Override
    public CreateClusterLinksResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (CreateClusterLinksResponseData.EntryData entry : this.data.entries()) {
            Errors error = Errors.forCode(entry.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    public static CreateClusterLinksResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new CreateClusterLinksResponse(new CreateClusterLinksResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    public static class ApiErrorAndOriginalThrowable {
        ApiError apiError;
        Throwable throwable;

        public ApiErrorAndOriginalThrowable(ApiError apiError, Throwable throwable) {
            this.apiError = apiError;
            this.throwable = throwable;
        }
    }
}

