/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ShareConsumerDelegate;
import org.apache.kafka.clients.consumer.internals.ShareConsumerImpl;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public class ShareConsumerDelegateCreator {
    public <K, V> ShareConsumerDelegate<K, V> create(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        try {
            LogContext logContext = new LogContext();
            Logger log = logContext.logger(this.getClass());
            log.warn("Share groups and KafkaShareConsumer are part of the early access of KIP-932 and MUST NOT be used in production.");
            return new ShareConsumerImpl<K, V>(config, keyDeserializer, valueDeserializer);
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Throwable t2) {
            throw new KafkaException("Failed to construct Kafka share consumer", t2);
        }
    }

    public <K, V> ShareConsumerDelegate<K, V> create(LogContext logContext, String clientId, String groupId, ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Time time, KafkaClient client, SubscriptionState subscriptions, ConsumerMetadata metadata) {
        try {
            Logger log = logContext.logger(this.getClass());
            log.warn("Share groups and KafkaShareConsumer are part of the early access of KIP-932 and MUST NOT be used in production.");
            return new ShareConsumerImpl<K, V>(logContext, clientId, groupId, config, keyDeserializer, valueDeserializer, time, client, subscriptions, metadata);
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Throwable t2) {
            throw new KafkaException("Failed to construct Kafka share consumer", t2);
        }
    }
}

