/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;

public enum TieredFragmentType {
    SEGMENT(0),
    OFFSET_INDEX(1),
    TRANSACTION_INDEX(2);

    private final byte value;
    private static final Map<Byte, TieredFragmentType> BYTE_ENUM_MAP;

    private TieredFragmentType(byte value) {
        this.value = value;
    }

    public byte getByte() {
        return this.value;
    }

    public static TieredFragmentType toType(byte b) {
        TieredFragmentType type = BYTE_ENUM_MAP.get(b);
        if (type == null) {
            throw new IllegalArgumentException(String.format("No TieredFragmentType exists with byte value %02x", b));
        }
        return type;
    }

    static {
        BYTE_ENUM_MAP = new HashMap<Byte, TieredFragmentType>();
        for (TieredFragmentType type : TieredFragmentType.values()) {
            BYTE_ENUM_MAP.put(type.getByte(), type);
        }
    }
}

