/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ErrorEvent;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class NetworkClientDelegateTest {
    private static final int REQUEST_TIMEOUT_MS = 5000;
    private static final String GROUP_ID = "group";
    private static final long DEFAULT_REQUEST_TIMEOUT_MS = 500L;
    private MockTime time;
    private MockClient client;
    private Metadata metadata;
    private BackgroundEventHandler backgroundEventHandler;

    @BeforeEach
    public void setup() {
        this.time = new MockTime(0L);
        this.metadata = (Metadata)Mockito.mock(Metadata.class);
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class);
        this.client = new MockClient((Time)this.time, Collections.singletonList(this.mockNode()));
    }

    @Test
    void testPollResultTimer() throws Exception {
        try (NetworkClientDelegate ncd = this.newNetworkClientDelegate();){
            NetworkClientDelegate.UnsentRequest req = new NetworkClientDelegate.UnsentRequest((AbstractRequest.Builder)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id()).setKey("foobar")), Optional.empty());
            req.setTimer((Time)this.time, 500L);
            NetworkClientDelegate.PollResult success = new NetworkClientDelegate.PollResult(10L, Collections.singletonList(req));
            Assertions.assertEquals((long)10L, (long)ncd.addAll(success));
            NetworkClientDelegate.PollResult failure = new NetworkClientDelegate.PollResult(10L, new ArrayList());
            Assertions.assertEquals((long)10L, (long)ncd.addAll(failure));
        }
    }

    @Test
    public void testSuccessfulResponse() throws Exception {
        try (NetworkClientDelegate ncd = this.newNetworkClientDelegate();){
            NetworkClientDelegate.UnsentRequest unsentRequest = this.newUnsentFindCoordinatorRequest();
            this.prepareFindCoordinatorResponse(Errors.NONE);
            ncd.add(unsentRequest);
            ncd.poll(0L, this.time.milliseconds());
            Assertions.assertTrue((boolean)unsentRequest.future().isDone());
            Assertions.assertNotNull(unsentRequest.future().get());
        }
    }

    @Test
    public void testTimeoutBeforeSend() throws Exception {
        try (NetworkClientDelegate ncd = this.newNetworkClientDelegate();){
            this.client.setUnreachable(this.mockNode(), 5000L);
            NetworkClientDelegate.UnsentRequest unsentRequest = this.newUnsentFindCoordinatorRequest();
            ncd.add(unsentRequest);
            ncd.poll(0L, this.time.milliseconds());
            this.time.sleep(5000L);
            ncd.poll(0L, this.time.milliseconds());
            Assertions.assertTrue((boolean)unsentRequest.future().isDone());
            TestUtils.assertFutureThrows(unsentRequest.future(), TimeoutException.class);
        }
    }

    @Test
    public void testTimeoutAfterSend() throws Exception {
        try (NetworkClientDelegate ncd = this.newNetworkClientDelegate();){
            NetworkClientDelegate.UnsentRequest unsentRequest = this.newUnsentFindCoordinatorRequest();
            ncd.add(unsentRequest);
            ncd.poll(0L, this.time.milliseconds());
            this.time.sleep(5000L);
            ncd.poll(0L, this.time.milliseconds());
            Assertions.assertTrue((boolean)unsentRequest.future().isDone());
            TestUtils.assertFutureThrows(unsentRequest.future(), DisconnectException.class);
        }
    }

    @Test
    public void testEnsureCorrectCompletionTimeOnFailure() {
        NetworkClientDelegate.UnsentRequest unsentRequest = this.newUnsentFindCoordinatorRequest();
        long timeMs = this.time.milliseconds();
        unsentRequest.handler().onFailure(timeMs, (RuntimeException)((Object)new TimeoutException()));
        this.time.sleep(100L);
        Assertions.assertEquals((long)timeMs, (long)unsentRequest.handler().completionTimeMs());
    }

    @Test
    public void testEnsureCorrectCompletionTimeOnComplete() {
        NetworkClientDelegate.UnsentRequest unsentRequest = this.newUnsentFindCoordinatorRequest();
        long timeMs = this.time.milliseconds();
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        Mockito.when((Object)response.receivedTimeMs()).thenReturn((Object)timeMs);
        unsentRequest.handler().onComplete(response);
        this.time.sleep(100L);
        Assertions.assertEquals((long)timeMs, (long)unsentRequest.handler().completionTimeMs());
    }

    @Test
    public void testEnsureTimerSetOnAdd() {
        NetworkClientDelegate ncd = this.newNetworkClientDelegate();
        NetworkClientDelegate.UnsentRequest findCoordRequest = this.newUnsentFindCoordinatorRequest();
        Assertions.assertNull((Object)findCoordRequest.timer());
        ncd.add(findCoordRequest);
        Assertions.assertEquals((int)1, (int)ncd.unsentRequests().size());
        Assertions.assertEquals((long)5000L, (long)((NetworkClientDelegate.UnsentRequest)ncd.unsentRequests().poll()).timer().timeoutMs());
        ncd.addAll(Collections.singletonList(findCoordRequest));
        Assertions.assertEquals((int)1, (int)ncd.unsentRequests().size());
        Assertions.assertEquals((long)5000L, (long)((NetworkClientDelegate.UnsentRequest)ncd.unsentRequests().poll()).timer().timeoutMs());
    }

    @Test
    public void testHasAnyPendingRequests() throws Exception {
        try (NetworkClientDelegate networkClientDelegate = this.newNetworkClientDelegate();){
            NetworkClientDelegate.UnsentRequest unsentRequest = this.newUnsentFindCoordinatorRequest();
            networkClientDelegate.add(unsentRequest);
            Assertions.assertTrue((boolean)networkClientDelegate.hasAnyPendingRequests());
            Assertions.assertFalse((boolean)networkClientDelegate.unsentRequests().isEmpty());
            Assertions.assertFalse((boolean)this.client.hasInFlightRequests());
            networkClientDelegate.poll(0L, this.time.milliseconds());
            Assertions.assertTrue((boolean)networkClientDelegate.hasAnyPendingRequests());
            Assertions.assertTrue((boolean)networkClientDelegate.unsentRequests().isEmpty());
            Assertions.assertTrue((boolean)this.client.hasInFlightRequests());
            this.client.respond((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)GROUP_ID, (Node)this.mockNode()));
            networkClientDelegate.poll(0L, this.time.milliseconds());
            Assertions.assertFalse((boolean)networkClientDelegate.hasAnyPendingRequests());
            Assertions.assertTrue((boolean)networkClientDelegate.unsentRequests().isEmpty());
            Assertions.assertFalse((boolean)this.client.hasInFlightRequests());
        }
    }

    @Test
    public void testPropagateMetadataError() {
        AuthenticationException authException = new AuthenticationException("Test Auth Exception");
        ((Metadata)Mockito.doThrow((Throwable[])new Throwable[]{authException}).when((Object)this.metadata)).maybeThrowAnyException();
        LinkedList backgroundEventQueue = new LinkedList();
        this.backgroundEventHandler = new BackgroundEventHandler(backgroundEventQueue);
        NetworkClientDelegate networkClientDelegate = this.newNetworkClientDelegate();
        Assertions.assertEquals((int)0, (int)backgroundEventQueue.size());
        networkClientDelegate.poll(0L, this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)backgroundEventQueue.size());
        BackgroundEvent event = (BackgroundEvent)backgroundEventQueue.poll();
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals((Object)BackgroundEvent.Type.ERROR, (Object)event.type());
        Assertions.assertEquals((Object)((Object)authException), (Object)((ErrorEvent)event).error());
    }

    public NetworkClientDelegate newNetworkClientDelegate() {
        LogContext logContext = new LogContext();
        Properties properties = new Properties();
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        properties.put("group.id", GROUP_ID);
        properties.put("request.timeout.ms", (Object)5000);
        return new NetworkClientDelegate((Time)this.time, new ConsumerConfig(properties), logContext, (KafkaClient)this.client, this.metadata, this.backgroundEventHandler);
    }

    public NetworkClientDelegate.UnsentRequest newUnsentFindCoordinatorRequest() {
        Objects.requireNonNull(GROUP_ID);
        return new NetworkClientDelegate.UnsentRequest((AbstractRequest.Builder)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKey(GROUP_ID).setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id())), Optional.empty());
    }

    public void prepareFindCoordinatorResponse(Errors error) {
        FindCoordinatorResponse findCoordinatorResponse = FindCoordinatorResponse.prepareResponse((Errors)error, (String)GROUP_ID, (Node)this.mockNode());
        this.client.prepareResponse((AbstractResponse)findCoordinatorResponse);
    }

    private Node mockNode() {
        return new Node(0, "localhost", 99);
    }
}

