/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;

public class CounterConsumerRebalanceListener
implements ConsumerRebalanceListener {
    private final AtomicInteger revokedCounter = new AtomicInteger();
    private final AtomicInteger assignedCounter = new AtomicInteger();
    private final AtomicInteger lostCounter = new AtomicInteger();
    private final Optional<RuntimeException> revokedError;
    private final Optional<RuntimeException> assignedError;
    private final Optional<RuntimeException> lostError;

    public CounterConsumerRebalanceListener() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public CounterConsumerRebalanceListener(Optional<RuntimeException> revokedError, Optional<RuntimeException> assignedError, Optional<RuntimeException> lostError) {
        this.revokedError = revokedError;
        this.assignedError = assignedError;
        this.lostError = lostError;
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        try {
            if (this.revokedError.isPresent()) {
                throw this.revokedError.get();
            }
        }
        finally {
            this.revokedCounter.incrementAndGet();
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        try {
            if (this.assignedError.isPresent()) {
                throw this.assignedError.get();
            }
        }
        finally {
            this.assignedCounter.incrementAndGet();
        }
    }

    public void onPartitionsLost(Collection<TopicPartition> partitions) {
        try {
            if (this.lostError.isPresent()) {
                throw this.lostError.get();
            }
        }
        finally {
            this.lostCounter.incrementAndGet();
        }
    }

    public int revokedCount() {
        return this.revokedCounter.get();
    }

    public int assignedCount() {
        return this.assignedCounter.get();
    }

    public int lostCount() {
        return this.lostCounter.get();
    }
}

