/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.kafka.clients.AddressChangeHostResolver;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.MockedConstruction;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ClientUtilsTest {
    @Test
    public void testParseAndValidateAddresses() {
        this.checkWithoutLookup("127.0.0.1:8000");
        this.checkWithoutLookup("localhost:8080");
        this.checkWithoutLookup("[::1]:8000");
        this.checkWithoutLookup("[2001:db8:85a3:8d3:1319:8a2e:370:7348]:1234", "localhost:10000");
        List<InetSocketAddress> validatedAddresses = this.checkWithoutLookup("localhost:10000");
        Assertions.assertEquals((int)1, (int)validatedAddresses.size());
        InetSocketAddress onlyAddress = validatedAddresses.get(0);
        Assertions.assertEquals((Object)"localhost", (Object)onlyAddress.getHostName());
        Assertions.assertEquals((int)10000, (int)onlyAddress.getPort());
    }

    @Test
    public void testParseAndValidateAddressesWithReverseLookup() {
        this.checkWithoutLookup("127.0.0.1:8000");
        this.checkWithoutLookup("localhost:8080");
        this.checkWithoutLookup("[::1]:8000");
        this.checkWithoutLookup("[2001:db8:85a3:8d3:1319:8a2e:370:7348]:1234", "localhost:10000");
        String hostname = "example.com";
        Integer port = 10000;
        String canonicalHostname1 = "canonical_hostname1";
        String canonicalHostname2 = "canonical_hostname2";
        try (MockedStatic inetAddress = Mockito.mockStatic(InetAddress.class);){
            InetAddress inetAddress1 = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)inetAddress1.getCanonicalHostName()).thenReturn((Object)canonicalHostname1);
            InetAddress inetAddress2 = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)inetAddress2.getCanonicalHostName()).thenReturn((Object)canonicalHostname2);
            inetAddress.when(() -> InetAddress.getAllByName(hostname)).thenReturn((Object)new InetAddress[]{inetAddress1, inetAddress2});
            try (MockedConstruction inetSocketAddress = Mockito.mockConstruction(InetSocketAddress.class, (mock, context) -> {
                Mockito.when((Object)mock.isUnresolved()).thenReturn((Object)false);
                Mockito.when((Object)mock.getHostName()).thenReturn((Object)((String)context.arguments().get(0)));
                Mockito.when((Object)mock.getPort()).thenReturn((Object)((Integer)context.arguments().get(1)));
            });){
                List<InetSocketAddress> validatedAddresses = this.checkWithLookup(Collections.singletonList(hostname + ":" + port));
                Assertions.assertEquals((int)2, (int)inetSocketAddress.constructed().size());
                Assertions.assertEquals((int)2, (int)validatedAddresses.size());
                Assertions.assertTrue((boolean)validatedAddresses.containsAll(Arrays.asList((InetSocketAddress)inetSocketAddress.constructed().get(0), (InetSocketAddress)inetSocketAddress.constructed().get(1))));
                validatedAddresses.forEach(address -> Assertions.assertEquals((Integer)port, (int)address.getPort()));
                validatedAddresses.stream().map(InetSocketAddress::getHostName).forEach(hostName -> Assertions.assertTrue((boolean)Arrays.asList(canonicalHostname1, canonicalHostname2).contains(hostName)));
            }
        }
    }

    static Stream<List<String>> provideValidBrokerAddressTestCases() {
        return Stream.of(Arrays.asList("localhost:9997", "localhost:9998", "localhost:9999"), Arrays.asList("localhost:9997", "localhost:9998", " localhost:9999"), Arrays.asList("localhost:9997 localhost:9998 localhost:9999"));
    }

    @ParameterizedTest
    @MethodSource(value={"provideValidBrokerAddressTestCases"})
    public void testValidBrokerAddress(List<String> addresses) {
        Assertions.assertDoesNotThrow(() -> ClientUtils.parseAndValidateAddresses((List)addresses, (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS));
    }

    @Test
    public void testInvalidBrokerAddress() {
        List<String> invalidBrokerAddress = Collections.singletonList("localhost:9997\nlocalhost:9998\nlocalhost:9999");
        Assertions.assertThrows(ConfigException.class, () -> ClientUtils.parseAndValidateAddresses((List)invalidBrokerAddress, (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS));
    }

    @Test
    public void testInvalidConfig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientUtils.parseAndValidateAddresses(Collections.singletonList("localhost:10000"), (String)"random.value"));
    }

    @Test
    public void testNoPort() {
        Assertions.assertThrows(ConfigException.class, () -> this.checkWithoutLookup("127.0.0.1"));
    }

    @Test
    public void testInvalidPort() {
        Assertions.assertThrows(ConfigException.class, () -> this.checkWithoutLookup("localhost:70000"));
    }

    @Test
    public void testOnlyBadHostname() {
        try (MockedConstruction inetSocketAddress = Mockito.mockConstruction(InetSocketAddress.class, (mock, context) -> Mockito.when((Object)mock.isUnresolved()).thenReturn((Object)true));){
            Exception exception = (Exception)Assertions.assertThrows(ConfigException.class, () -> this.checkWithoutLookup("some.invalid.hostname.foo.bar.local:9999"));
            Assertions.assertEquals((Object)"No resolvable bootstrap urls given in bootstrap.servers", (Object)exception.getMessage());
        }
    }

    @Test
    public void testFilterPreferredAddresses() throws UnknownHostException {
        InetAddress ipv4 = InetAddress.getByName("192.0.0.1");
        InetAddress ipv6 = InetAddress.getByName("::1");
        InetAddress[] ipv4First = new InetAddress[]{ipv4, ipv6, ipv4};
        List result = ClientUtils.filterPreferredAddresses((InetAddress[])ipv4First);
        Assertions.assertTrue((boolean)result.contains(ipv4));
        Assertions.assertFalse((boolean)result.contains(ipv6));
        Assertions.assertEquals((int)2, (int)result.size());
        InetAddress[] ipv6First = new InetAddress[]{ipv6, ipv4, ipv4};
        result = ClientUtils.filterPreferredAddresses((InetAddress[])ipv6First);
        Assertions.assertTrue((boolean)result.contains(ipv6));
        Assertions.assertFalse((boolean)result.contains(ipv4));
        Assertions.assertEquals((int)1, (int)result.size());
    }

    @Test
    public void testResolveUnknownHostException() {
        HostResolver throwingHostResolver = host -> {
            throw new UnknownHostException();
        };
        Assertions.assertThrows(UnknownHostException.class, () -> ClientUtils.resolve((String)"some.invalid.hostname.foo.bar.local", (HostResolver)throwingHostResolver));
    }

    @Test
    public void testResolveDnsLookup() throws UnknownHostException {
        InetAddress[] addresses = new InetAddress[]{InetAddress.getByName("198.51.100.0"), InetAddress.getByName("198.51.100.5")};
        AddressChangeHostResolver hostResolver = new AddressChangeHostResolver(addresses, addresses);
        Assertions.assertEquals(Arrays.asList(addresses), (Object)ClientUtils.resolve((String)"kafka.apache.org", (HostResolver)hostResolver));
    }

    private List<InetSocketAddress> checkWithoutLookup(String ... url) {
        return ClientUtils.parseAndValidateAddresses(Arrays.asList(url), (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS);
    }

    private List<InetSocketAddress> checkWithLookup(List<String> url) {
        return ClientUtils.parseAndValidateAddresses(url, (ClientDnsLookup)ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY);
    }
}

