/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.datapolicy;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDataPolicyStore {
    private static final Map<String, DefaultDataPolicyStore> INSTANCES = new HashMap<String, DefaultDataPolicyStore>();
    private final Map<String, Boolean> policies = new ConcurrentHashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultDataPolicyStore getInstance(String brokerSessionUuid) {
        Map<String, DefaultDataPolicyStore> map = INSTANCES;
        synchronized (map) {
            return INSTANCES.computeIfAbsent(brokerSessionUuid, k -> new DefaultDataPolicyStore());
        }
    }

    public boolean containsPolicy(String environmentId) {
        return this.policies.containsKey(environmentId);
    }

    public boolean getPolicy(String environmentId) {
        return this.policies.getOrDefault(environmentId, false);
    }

    public void addPolicy(String environmentId, boolean defaultDataPolicy) {
        this.policies.put(environmentId, defaultDataPolicy);
    }

    public void removePolicy(String environmentId) {
        this.policies.remove(environmentId);
    }

    public static boolean getPolicy(String brokerSessionUuid, String environmentId) {
        return DefaultDataPolicyStore.getInstance(brokerSessionUuid).getPolicy(environmentId);
    }

    public static void addPolicy(String brokerSessionUuid, String environmentId, boolean defaultDataPolicy) {
        DefaultDataPolicyStore.getInstance(brokerSessionUuid).addPolicy(environmentId, defaultDataPolicy);
    }

    public static void removePolicy(String brokerSessionUuid, String environmentId) {
        DefaultDataPolicyStore.getInstance(brokerSessionUuid).removePolicy(environmentId);
    }
}

