/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaThread
extends Thread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean trackStuckIO = false;

    public static KafkaThread daemon(String name, Runnable runnable) {
        return new KafkaThread(name, runnable, true);
    }

    public static KafkaThread nonDaemon(String name, Runnable runnable) {
        return new KafkaThread(name, runnable, false);
    }

    public KafkaThread(String name, boolean daemon) {
        super(name);
        this.configureThread(name, daemon);
    }

    public KafkaThread(String name, Runnable runnable, boolean daemon) {
        super(runnable, name);
        this.configureThread(name, daemon);
    }

    public KafkaThread(String name, Runnable runnable, boolean daemon, boolean trackStuckIO) {
        this(name, runnable, daemon);
        this.trackStuckIO = trackStuckIO;
    }

    private void configureThread(String name, boolean daemon) {
        this.setDaemon(daemon);
        this.setUncaughtExceptionHandler((t, e) -> this.log.error("Uncaught exception in thread '{}':", (Object)name, (Object)e));
    }

    @Override
    public void run() {
        if (this.trackStuckIO) {
            ThreadCountersManager.LocalCounters.setThreadType(ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD);
        }
        super.run();
    }
}

