/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.common.utils.FileWatchService;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSslEngineFactory
implements SslEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultSslEngineFactory.class);
    public static final String PEM_TYPE = "PEM";
    private static final FileWatchService FILE_STORE_WATCH_SERVICE = new FileWatchService();
    private Map<String, ?> configs;
    private String protocol;
    private String provider;
    private String kmfAlgorithm;
    private String tmfAlgorithm;
    private SecurityStore keystore;
    private SecurityStore truststore;
    private FileStoreWatchListener keyStoreFileWatchListener = null;
    private FileStoreWatchListener trustStoreFileWatchListener = null;
    private String[] cipherSuites;
    private String[] enabledProtocols;
    private SecureRandom secureRandomImplementation;
    private AtomicReference<SSLContext> sslContext = new AtomicReference<Object>(null);
    private SslClientAuth sslClientAuth;

    @Override
    public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
        return this.createSslEngine(Mode.CLIENT, peerHost, peerPort, endpointIdentification);
    }

    @Override
    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        return this.createSslEngine(Mode.SERVER, peerHost, peerPort, null);
    }

    @Override
    public boolean shouldBeRebuilt(Map<String, Object> nextConfigs) {
        if (!nextConfigs.equals(this.configs)) {
            return true;
        }
        if (this.truststore != null && this.truststore.modified()) {
            return true;
        }
        return this.keystore != null && this.keystore.modified();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SslConfigs.RECONFIGURABLE_CONFIGS;
    }

    @Override
    public KeyStore keystore() {
        return this.keystore != null ? this.keystore.get() : null;
    }

    @Override
    public KeyStore truststore() {
        return this.truststore != null ? this.truststore.get() : null;
    }

    String tmfAlgorithm() {
        return this.tmfAlgorithm != null ? this.tmfAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = Collections.unmodifiableMap(configs);
        this.protocol = (String)configs.get("ssl.protocol");
        this.provider = (String)configs.get("ssl.provider");
        SecurityUtils.addConfiguredSecurityProviders(this.configs);
        List cipherSuitesList = (List)configs.get("ssl.cipher.suites");
        this.cipherSuites = cipherSuitesList != null && !cipherSuitesList.isEmpty() ? cipherSuitesList.toArray(new String[0]) : null;
        List enabledProtocolsList = (List)configs.get("ssl.enabled.protocols");
        this.enabledProtocols = enabledProtocolsList != null && !enabledProtocolsList.isEmpty() ? enabledProtocolsList.toArray(new String[0]) : null;
        this.secureRandomImplementation = this.createSecureRandom((String)configs.get("ssl.secure.random.implementation"));
        this.sslClientAuth = DefaultSslEngineFactory.createSslClientAuth((String)configs.get("ssl.client.auth"));
        this.kmfAlgorithm = (String)configs.get("ssl.keymanager.algorithm");
        this.tmfAlgorithm = (String)configs.get("ssl.trustmanager.algorithm");
        this.keystore = this.createKeystore((String)configs.get("ssl.keystore.type"), (String)configs.get("ssl.keystore.location"), (Password)configs.get("ssl.keystore.password"), (Password)configs.get("ssl.key.password"), (Password)configs.get("ssl.keystore.key"), (Password)configs.get("ssl.keystore.certificate.chain"), this.useBcfks());
        this.truststore = DefaultSslEngineFactory.createTruststore((String)configs.get("ssl.truststore.type"), (String)configs.get("ssl.truststore.location"), (Password)configs.get("ssl.truststore.password"), (Password)configs.get("ssl.truststore.certificates"), this.useBcfks(), ConfluentConfigs.getMTlsEnable(configs));
        this.registerFileWatchListeners(configs);
        this.createAndSetSSLContext();
    }

    private void registerFileWatchListeners(Map<String, ?> configs) {
        String enableDynamicStoreUpdate = (String)configs.get("confluent.ssl.enable.dynamic.store.update");
        String keyStoreLocation = (String)configs.get("ssl.keystore.location");
        String trustStoreLocation = (String)configs.get("ssl.truststore.location");
        if (Boolean.parseBoolean(enableDynamicStoreUpdate)) {
            if (keyStoreLocation != null) {
                this.keyStoreFileWatchListener = new FileStoreWatchListener(this.keystore, keyStoreLocation, this::createAndSetSSLContext);
                FILE_STORE_WATCH_SERVICE.add(this.keyStoreFileWatchListener);
                log.info("Enabled ssl.enable.dynamic.store.update for keystore : {}", (Object)this.keystore);
            }
            if (trustStoreLocation != null) {
                this.trustStoreFileWatchListener = new FileStoreWatchListener(this.truststore, trustStoreLocation, this::createAndSetSSLContext);
                FILE_STORE_WATCH_SERVICE.add(this.trustStoreFileWatchListener);
                log.info("Enabled ssl.enable.dynamic.store.update for truststore : {}", (Object)this.truststore);
            }
        }
    }

    protected void createAndSetSSLContext() {
        this.sslContext.set(this.createSSLContext(this.keystore, this.truststore));
    }

    @Override
    public void close() {
        this.sslContext = null;
        if (this.keyStoreFileWatchListener != null) {
            FILE_STORE_WATCH_SERVICE.remove(this.keyStoreFileWatchListener);
        }
        if (this.trustStoreFileWatchListener != null) {
            FILE_STORE_WATCH_SERVICE.remove(this.trustStoreFileWatchListener);
        }
    }

    public SSLContext sslContext() {
        return this.sslContext.get();
    }

    FileStoreWatchListener keyStoreFileWatchListener() {
        return this.keyStoreFileWatchListener;
    }

    FileStoreWatchListener trustStoreFileWatchListener() {
        return this.trustStoreFileWatchListener;
    }

    private SSLEngine createSslEngine(Mode mode, String peerHost, int peerPort, String endpointIdentification) {
        SSLEngine sslEngine = this.sslContext().createSSLEngine(peerHost, peerPort);
        if (this.cipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        if (mode == Mode.SERVER) {
            sslEngine.setUseClientMode(false);
            switch (this.sslClientAuth) {
                case REQUIRED: {
                    sslEngine.setNeedClientAuth(true);
                    break;
                }
                case REQUESTED: {
                    sslEngine.setWantClientAuth(true);
                    break;
                }
            }
        } else {
            sslEngine.setUseClientMode(true);
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm(endpointIdentification);
            sslEngine.setSSLParameters(sslParams);
        }
        return sslEngine;
    }

    private static SslClientAuth createSslClientAuth(String key) {
        SslClientAuth auth = SslClientAuth.forConfig(key);
        if (auth != null) {
            return auth;
        }
        log.warn("Unrecognized client authentication configuration {}.  Falling back to NONE.  Recognized client authentication configurations are {}.", (Object)key, (Object)SslClientAuth.VALUES.stream().map(Enum::name).collect(Collectors.joining(", ")));
        return SslClientAuth.NONE;
    }

    private SecureRandom createSecureRandom(String key) {
        if (key == null) {
            return null;
        }
        try {
            return SecurityFactory.getSecureRandomInstance(key, this.useBcfks());
        }
        catch (GeneralSecurityException e) {
            throw new KafkaException(e);
        }
    }

    private SSLContext createSSLContext(SecurityStore keystore, SecurityStore truststore) {
        try {
            SSLContext sslContext = this.provider != null ? SSLContext.getInstance(this.protocol, this.provider) : SSLContext.getInstance(this.protocol);
            KeyManager[] keyManagers = null;
            if (keystore != null || this.kmfAlgorithm != null) {
                String kmfAlgorithm = this.kmfAlgorithm != null ? this.kmfAlgorithm : KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfAlgorithm);
                if (keystore != null) {
                    kmf.init(keystore.get(), keystore.keyPassword());
                } else {
                    kmf.init(null, null);
                }
                keyManagers = kmf.getKeyManagers();
            }
            String tmfAlgorithm = this.tmfAlgorithm != null ? this.tmfAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
            TrustManager[] trustManagers = this.getTrustManagers(truststore, tmfAlgorithm);
            sslContext.init(keyManagers, trustManagers, this.secureRandomImplementation);
            log.debug("Created SSL context with keystore {}, truststore {}, provider {}.", new Object[]{keystore, truststore, sslContext.getProvider().getName()});
            return sslContext;
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    protected TrustManager[] getTrustManagers(SecurityStore truststore, String tmfAlgorithm) throws NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        KeyStore ts = truststore == null ? null : truststore.get();
        tmf.init(ts);
        return tmf.getTrustManagers();
    }

    protected SecurityStore createKeystore(String type, String path, Password password, Password keyPassword, Password privateKey, Password certificateChain, boolean useBcfks) {
        if (privateKey != null) {
            if (!PEM_TYPE.equals(type)) {
                throw new InvalidConfigurationException("SSL private key can be specified only for PEM, but key store type is " + type + ".");
            }
            if (certificateChain == null) {
                throw new InvalidConfigurationException("SSL private key is specified, but certificate chain is not specified.");
            }
            if (path != null) {
                throw new InvalidConfigurationException("Both SSL key store location and separate private key are specified.");
            }
            if (password != null) {
                throw new InvalidConfigurationException("SSL key store password cannot be specified with PEM format, only key password may be specified.");
            }
            return new PemStore(certificateChain, privateKey, keyPassword, useBcfks);
        }
        if (certificateChain != null) {
            throw new InvalidConfigurationException("SSL certificate chain is specified, but private key is not specified");
        }
        if (PEM_TYPE.equals(type) && path != null) {
            if (password != null) {
                throw new InvalidConfigurationException("SSL key store password cannot be specified with PEM format, only key password may be specified");
            }
            return new FileBasedPemStore(path, keyPassword, true, useBcfks);
        }
        if (path == null && password != null) {
            throw new InvalidConfigurationException("SSL key store is not specified, but key store password is specified.");
        }
        if (path != null && password == null) {
            throw new InvalidConfigurationException("SSL key store is specified, but key store password is not specified.");
        }
        if (path != null && password != null) {
            return new FileBasedStore(type, path, password, keyPassword, true, useBcfks);
        }
        return null;
    }

    private static SecurityStore createTruststore(String type, String path, Password password, Password trustStoreCerts, boolean useBcfks, boolean mTlsEnabled) {
        if (trustStoreCerts != null) {
            if (!PEM_TYPE.equals(type)) {
                throw new InvalidConfigurationException("SSL trust store certs can be specified only for PEM, but trust store type is " + type + ".");
            }
            if (path != null) {
                throw new InvalidConfigurationException("Both SSL trust store location and separate trust certificates are specified.");
            }
            if (password != null) {
                throw new InvalidConfigurationException("SSL trust store password cannot be specified for PEM format.");
            }
            return new PemStore(trustStoreCerts, useBcfks);
        }
        if (PEM_TYPE.equals(type) && path != null) {
            if (password != null) {
                throw new InvalidConfigurationException("SSL trust store password cannot be specified for PEM format.");
            }
            return new FileBasedPemStore(path, null, false, useBcfks);
        }
        if (path == null && password != null) {
            throw new InvalidConfigurationException("SSL trust store is not specified, but trust store password is specified.");
        }
        if (path != null) {
            return new FileBasedStore(type, path, password, null, false, useBcfks, mTlsEnabled);
        }
        return null;
    }

    boolean useBcfks() {
        Object securityProviders;
        if (this.provider != null && (securityProviders = this.configs.get("security.providers")) instanceof String) {
            return this.provider.equalsIgnoreCase("BCJSSE") && ((String)securityProviders).toLowerCase(Locale.ROOT).contains("BCFIPS".toLowerCase(Locale.ROOT));
        }
        return false;
    }

    Map<String, Object> configs() {
        return this.configs;
    }

    String[] cipherSuites() {
        return this.cipherSuites;
    }

    String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    SslClientAuth sslClientAuth() {
        return this.sslClientAuth;
    }

    SecurityStore securityKeyStore() {
        return this.keystore;
    }

    public static DefaultSslEngineFactory castOrThrow(SslEngineFactory factory) {
        if (factory instanceof DefaultSslEngineFactory) {
            return (DefaultSslEngineFactory)factory;
        }
        throw new RuntimeException("Expected ssl engine factory to be DefaultSslEngineFactory, but saw " + factory.getClass());
    }

    private static class SecurityFactory {
        private SecurityFactory() {
        }

        public static SecureRandom getSecureRandomInstance(String key, boolean isFips) throws NoSuchProviderException, NoSuchAlgorithmException {
            return isFips ? SecureRandom.getInstance(key, "BCFIPS") : SecureRandom.getInstance(key);
        }

        public static KeyStore getKeyStoreInstance(String type, boolean isFips) throws KeyStoreException, NoSuchProviderException {
            return isFips ? KeyStore.getInstance(type, "BCFIPS") : KeyStore.getInstance(type);
        }

        public static KeyStore getKeyStoreInstance(boolean isFips) throws KeyStoreException, NoSuchProviderException {
            return isFips ? SecurityFactory.getKeyStoreInstance("BCFKS", true) : SecurityFactory.getKeyStoreInstance("PKCS12", false);
        }

        public static CertificateFactory getCertificateFactoryInstance(String type, boolean isFips) throws CertificateException, NoSuchProviderException {
            return isFips ? CertificateFactory.getInstance(type, "BCFIPS") : CertificateFactory.getInstance(type);
        }

        public static SecretKeyFactory getSecretKeyFactoryInstance(String algorithm, boolean isFips) throws NoSuchAlgorithmException, NoSuchProviderException {
            return isFips ? SecretKeyFactory.getInstance(algorithm, "BCFIPS") : SecretKeyFactory.getInstance(algorithm);
        }

        public static Cipher getCipherInstance(String algorithm, boolean isFips) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
            return isFips ? Cipher.getInstance(algorithm, "BCFIPS") : Cipher.getInstance(algorithm);
        }

        public static KeyFactory getKeyFactory(String algorithm, boolean isFips) throws NoSuchAlgorithmException, NoSuchProviderException {
            return isFips ? KeyFactory.getInstance(algorithm, "BCFIPS") : KeyFactory.getInstance(algorithm);
        }
    }

    class FileStoreWatchListener
    implements FileWatchService.Listener {
        private final AtomicReference<Exception> lastLoadFailure = new AtomicReference<Object>(null);
        private final SecurityStore secretStore;
        private final File watchFile;
        private final Runnable createAndSetSSLContext;
        private boolean initCompleted;

        public FileStoreWatchListener(SecurityStore secretStore, String secretStoreLocation, Runnable createAndSetSSLContext) {
            this.secretStore = secretStore;
            Path filePath = Paths.get(secretStoreLocation, new String[0]);
            this.watchFile = filePath.toFile();
            this.createAndSetSSLContext = createAndSetSSLContext;
        }

        @Override
        public File file() {
            return this.watchFile;
        }

        @Override
        public void onInit() {
            this.initCompleted = true;
        }

        @Override
        public void onUpdate() {
            try {
                if (this.maybeReloadStore(this.secretStore)) {
                    this.createAndSetSSLContext.run();
                }
            }
            catch (Exception e) {
                log.error("Error while reloading the security store : {}", (Object)this.secretStore, (Object)e);
            }
        }

        private boolean maybeReloadStore(SecurityStore store) {
            try {
                if (this.isKeyStore(store) && ConfluentConfigs.requireCompatibleKeystores(DefaultSslEngineFactory.this.configs)) {
                    this.validateKeyStoreCompatibility();
                }
                if (!(store instanceof FileBasedStore)) {
                    throw new IllegalStateException("Store " + store + " is expected to be file-based for reloading.");
                }
                ((FileBasedStore)store).reloadStore(this.isKeyStore(store));
                log.info("isKeyStore = {}, Reloaded  store {}", (Object)this.isKeyStore(store), (Object)store);
                this.lastLoadFailure.set(null);
                return true;
            }
            catch (Exception e) {
                log.error("Error while reloading the security store : {}", (Object)store, (Object)e);
                this.lastLoadFailure.set(e);
                return false;
            }
        }

        private boolean isKeyStore(SecurityStore store) {
            return store == DefaultSslEngineFactory.this.keystore;
        }

        private void validateKeyStoreCompatibility() throws GeneralSecurityException {
            SecurityStore newKeyStore = DefaultSslEngineFactory.this.createKeystore((String)DefaultSslEngineFactory.this.configs.get("ssl.keystore.type"), (String)DefaultSslEngineFactory.this.configs.get("ssl.keystore.location"), (Password)DefaultSslEngineFactory.this.configs.get("ssl.keystore.password"), (Password)DefaultSslEngineFactory.this.configs.get("ssl.key.password"), (Password)DefaultSslEngineFactory.this.configs.get("ssl.keystore.key"), (Password)DefaultSslEngineFactory.this.configs.get("ssl.keystore.certificate.chain"), DefaultSslEngineFactory.this.useBcfks());
            HashMap<String, Object> nextConfigs = new HashMap<String, Object>(DefaultSslEngineFactory.this.configs);
            boolean allowDnChanges = ConfigUtils.getBoolean(nextConfigs, "ssl.allow.dn.changes", false);
            boolean allowSanChanges = ConfigUtils.getBoolean(nextConfigs, "ssl.allow.san.changes", false);
            SslFactory.CertificateEntries.ensureCompatible(newKeyStore.get(), DefaultSslEngineFactory.this.keystore.get(), allowDnChanges, allowSanChanges);
        }

        Exception lastLoadFailure() {
            return this.lastLoadFailure.get();
        }

        boolean initCompleted() {
            return this.initCompleted;
        }
    }

    public static class PemStore
    implements SecurityStore {
        private static final Utils.PemParser CERTIFICATE_PARSER = new Utils.PemParser("CERTIFICATE");
        private static final Utils.PemParser PRIVATE_KEY_PARSER = new Utils.PemParser("PRIVATE KEY");
        private final List<KeyFactory> keyFactories = Arrays.asList(this.keyFactory("RSA"), this.keyFactory("DSA"), this.keyFactory("EC"));
        private final char[] keyPassword;
        private final KeyStore keyStore;
        private final boolean useBcfks;

        public PemStore(Password certificateChain, Password privateKey, Password keyPassword, boolean useBcfks) {
            this.keyPassword = keyPassword == null ? null : keyPassword.value().toCharArray();
            this.useBcfks = useBcfks;
            this.keyStore = this.createKeyStoreFromPem(privateKey.value(), certificateChain.value(), this.keyPassword);
        }

        public PemStore(Password trustStoreCerts, boolean useBcfks) {
            this.keyPassword = null;
            this.useBcfks = useBcfks;
            this.keyStore = this.createTrustStoreFromPem(trustStoreCerts.value());
        }

        @Override
        public KeyStore get() {
            return this.keyStore;
        }

        @Override
        public char[] keyPassword() {
            return this.keyPassword;
        }

        @Override
        public boolean modified() {
            return false;
        }

        private KeyStore getIntermediateStore() throws Exception {
            return SecurityFactory.getKeyStoreInstance(this.useBcfks);
        }

        private KeyStore createKeyStoreFromPem(String privateKeyPem, String certChainPem, char[] keyPassword) {
            try {
                KeyStore ks = this.getIntermediateStore();
                ks.load(null, null);
                PrivateKey key = this.privateKey(privateKeyPem, keyPassword);
                Certificate[] certChain = this.certs(certChainPem);
                ks.setKeyEntry("kafka", key, keyPassword, certChain);
                return ks;
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid PEM keystore configs", e);
            }
        }

        private KeyStore createTrustStoreFromPem(String trustedCertsPem) {
            try {
                KeyStore ts = this.getIntermediateStore();
                ts.load(null, null);
                Certificate[] certs = this.certs(trustedCertsPem);
                for (int i = 0; i < certs.length; ++i) {
                    ts.setCertificateEntry("kafka" + i, certs[i]);
                }
                return ts;
            }
            catch (InvalidConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid PEM truststore configs", e);
            }
        }

        private Certificate[] certs(String pem) throws GeneralSecurityException {
            List<byte[]> certEntries = CERTIFICATE_PARSER.pemEntries(pem);
            if (certEntries.isEmpty()) {
                throw new InvalidConfigurationException("At least one certificate expected, but none found");
            }
            Certificate[] certs = new Certificate[certEntries.size()];
            CertificateFactory certificateFactory = SecurityFactory.getCertificateFactoryInstance("X.509", this.useBcfks);
            for (int i = 0; i < certs.length; ++i) {
                certs[i] = certificateFactory.generateCertificate(new ByteArrayInputStream(certEntries.get(i)));
            }
            return certs;
        }

        private PrivateKey privateKey(String pem, char[] keyPassword) throws Exception {
            PKCS8EncodedKeySpec keySpec;
            List<byte[]> keyEntries = PRIVATE_KEY_PARSER.pemEntries(pem);
            if (keyEntries.isEmpty()) {
                throw new InvalidConfigurationException("Private key not provided");
            }
            if (keyEntries.size() != 1) {
                throw new InvalidConfigurationException("Expected one private key, but found " + keyEntries.size());
            }
            byte[] keyBytes = keyEntries.get(0);
            if (keyPassword == null) {
                keySpec = new PKCS8EncodedKeySpec(keyBytes);
            } else {
                EncryptedPrivateKeyInfo keyInfo = new EncryptedPrivateKeyInfo(keyBytes);
                String algorithm = keyInfo.getAlgName();
                SecretKeyFactory keyFactory = SecurityFactory.getSecretKeyFactoryInstance(algorithm, this.useBcfks);
                SecretKey pbeKey = keyFactory.generateSecret(new PBEKeySpec(keyPassword));
                Cipher cipher = SecurityFactory.getCipherInstance(algorithm, this.useBcfks);
                cipher.init(2, (Key)pbeKey, keyInfo.getAlgParameters());
                keySpec = keyInfo.getKeySpec(cipher);
            }
            InvalidKeySpecException firstException = null;
            for (KeyFactory factory : this.keyFactories) {
                try {
                    return factory.generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            throw new InvalidConfigurationException("Private key could not be loaded", firstException);
        }

        private KeyFactory keyFactory(String algorithm) {
            try {
                return SecurityFactory.getKeyFactory(algorithm, this.useBcfks);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Could not create key factory for algorithm " + algorithm, e);
            }
        }
    }

    public static class FileBasedPemStore
    extends FileBasedStore {
        public FileBasedPemStore(String path, Password keyPassword, boolean isKeyStore, boolean useBcfks) {
            super(DefaultSslEngineFactory.PEM_TYPE, path, null, keyPassword, isKeyStore, useBcfks);
        }

        @Override
        protected KeyStore load(boolean isKeyStore) {
            try {
                Password storeContents = new Password(Utils.readFileAsString(this.path));
                PemStore pemStore = isKeyStore ? new PemStore(storeContents, storeContents, this.keyPassword, this.useBcfks) : new PemStore(storeContents, this.useBcfks);
                return pemStore.keyStore;
            }
            catch (Exception e) {
                log.error("Failed to load store, isKeyStore : {}, path {}", new Object[]{isKeyStore, this.path, e});
                throw new InvalidConfigurationException("Failed to load PEM SSL keystore " + this.path, e);
            }
        }
    }

    static class FileBasedStore
    implements SecurityStore {
        private final String type;
        protected final String path;
        private final Password password;
        protected final Password keyPassword;
        private Long fileLastModifiedMs;
        private KeyStore keyStore;
        protected final boolean useBcfks;
        protected final boolean mTlsEnabled;

        FileBasedStore(String type, String path, Password password, Password keyPassword, boolean isKeyStore, boolean useBcfks) {
            this(type, path, password, keyPassword, isKeyStore, useBcfks, false);
        }

        FileBasedStore(String type, String path, Password password, Password keyPassword, boolean isKeyStore, boolean useBcfks, boolean mTlsEnabled) {
            Objects.requireNonNull(type, "type must not be null");
            this.type = type;
            this.path = path;
            this.password = password;
            this.keyPassword = keyPassword;
            this.useBcfks = useBcfks;
            this.mTlsEnabled = mTlsEnabled;
            this.reloadStore(isKeyStore);
        }

        public void reloadStore(boolean isKeyStore) {
            this.fileLastModifiedMs = this.lastModifiedMs(this.path);
            this.keyStore = this.load(isKeyStore);
        }

        @Override
        public KeyStore get() {
            return this.keyStore;
        }

        @Override
        public char[] keyPassword() {
            Password passwd = this.keyPassword != null ? this.keyPassword : this.password;
            return passwd == null ? null : passwd.value().toCharArray();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected KeyStore load(boolean isKeyStore) {
            if (this.mTlsEnabled && !isKeyStore && !this.filePathExistsAndNotEmpty()) {
                this.createEmptyTruststore();
            }
            try (InputStream in = Files.newInputStream(Paths.get(this.path, new String[0]), new OpenOption[0]);){
                KeyStore ks = SecurityFactory.getKeyStoreInstance(this.type, this.useBcfks);
                char[] passwordChars = this.password != null ? this.password.value().toCharArray() : null;
                ks.load(in, passwordChars);
                KeyStore keyStore = ks;
                return keyStore;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new KafkaException("Failed to load SSL keystore " + this.path + " of type " + this.type, e);
            }
        }

        private boolean filePathExistsAndNotEmpty() {
            try {
                Path filePath = Paths.get(this.path, new String[0]);
                return Files.exists(filePath, new LinkOption[0]) && Files.size(filePath) > 0L;
            }
            catch (IOException e) {
                return false;
            }
        }

        private void createEmptyTruststore() {
            try {
                KeyStore ks = SecurityFactory.getKeyStoreInstance(this.type, this.useBcfks);
                char[] passwordChars = this.password != null ? this.password.value().toCharArray() : null;
                ks.load(null, passwordChars);
                try (OutputStream fos = Files.newOutputStream(Paths.get(this.path, new String[0]), new OpenOption[0]);){
                    ks.store(fos, passwordChars);
                }
            }
            catch (IOException | GeneralSecurityException e) {
                throw new KafkaException("Failed to create SSL truststore " + this.path + " of type " + this.type, e);
            }
        }

        private Long lastModifiedMs(String path) {
            try {
                return Files.getLastModifiedTime(Paths.get(path, new String[0]), new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                log.error("Modification time of key store could not be obtained: " + path, (Throwable)e);
                return null;
            }
        }

        @Override
        public boolean modified() {
            Long modifiedMs = this.lastModifiedMs(this.path);
            return modifiedMs != null && !Objects.equals(modifiedMs, this.fileLastModifiedMs);
        }

        public String toString() {
            return "SecurityStore(path=" + this.path + ", modificationTime=" + (this.fileLastModifiedMs == null ? null : new Date(this.fileLastModifiedMs)) + ")";
        }
    }

    static interface SecurityStore {
        public KeyStore get();

        public char[] keyPassword();

        public boolean modified();
    }

    static class PrivateKeyData {
        private final PrivateKey key;
        private final X509Certificate[] certificateChain;

        PrivateKeyData(PrivateKey key, X509Certificate[] certificateChain) {
            this.key = key;
            this.certificateChain = certificateChain;
        }

        PrivateKey key() {
            return this.key;
        }

        X509Certificate[] certificateChain() {
            return this.certificateChain;
        }
    }
}

