/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.auth;

import java.net.InetAddress;
import java.util.Optional;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class SaslAuthenticationContext
implements AuthenticationContext {
    private final SaslServer server;
    private final SecurityProtocol securityProtocol;
    private final InetAddress clientAddress;
    private final String listenerName;
    private final Optional<SSLSession> sslSession;
    private long sessionId;
    private boolean isMTlsSession;

    public SaslAuthenticationContext(long sessionId, SaslServer server, SecurityProtocol securityProtocol, InetAddress clientAddress, String listenerName) {
        this(sessionId, server, securityProtocol, clientAddress, listenerName, Optional.empty(), false);
    }

    public SaslAuthenticationContext(SaslServer server, SecurityProtocol securityProtocol, InetAddress clientAddress, String listenerName) {
        this(-1L, server, securityProtocol, clientAddress, listenerName, Optional.empty(), false);
    }

    public SaslAuthenticationContext(long sessionId, SaslServer server, SecurityProtocol securityProtocol, InetAddress clientAddress, String listenerName, Optional<SSLSession> sslSession, boolean isMTlsSession) {
        this.sessionId = sessionId;
        this.server = server;
        this.securityProtocol = securityProtocol;
        this.clientAddress = clientAddress;
        this.listenerName = listenerName;
        this.sslSession = sslSession;
        this.isMTlsSession = isMTlsSession;
    }

    public SaslServer server() {
        return this.server;
    }

    public Optional<SSLSession> sslSession() {
        return this.sslSession;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    @Override
    public InetAddress clientAddress() {
        return this.clientAddress;
    }

    @Override
    public String listenerName() {
        return this.listenerName;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    public boolean isMTlsSession() {
        return this.isMTlsSession;
    }
}

