/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.common.message.AppendRecordsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.AppendRecordsResponse;

public class AppendRecordsRequest
extends AbstractRequest {
    private final AppendRecordsRequestData data;

    AppendRecordsRequest(AppendRecordsRequestData data, short version) {
        super(ApiKeys.APPEND_RECORDS, version);
        this.data = data;
    }

    @Override
    public AppendRecordsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        AppendRecordsResponseData data = new AppendRecordsResponseData().setThrottleTimeMs(throttleTimeMs);
        data.setErrorCode(apiError.error().code());
        return new AppendRecordsResponse(data);
    }

    @Override
    public AppendRecordsRequestData data() {
        return this.data;
    }

    public static MemoryRecords memoryRecords(AppendRecordsRequestData.PartitionData partition) {
        if (partition.records() == null) {
            return MemoryRecords.EMPTY;
        }
        return (MemoryRecords)partition.records();
    }

    public static AppendRecordsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AppendRecordsRequest(new AppendRecordsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AppendRecordsRequest> {
        private final AppendRecordsRequestData data;

        public Builder(AppendRecordsRequestData data) {
            super(ApiKeys.APPEND_RECORDS);
            this.data = data;
        }

        @Override
        public AppendRecordsRequest build(short version) {
            return new AppendRecordsRequest(this.data, version);
        }
    }
}

