/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NoOpProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV1Engine;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;
import org.apache.kafka.common.utils.LogContext;

public class ProxyProtocolEngineFactory {
    private final Supplier<ProxyProtocolEngine> proxyProtocolEngineSupplier;

    public ProxyProtocolEngineFactory(ProxyProtocol proxyProtocol) {
        this(proxyProtocol, Collections.emptyMap(), Mode.SERVER, new LogContext());
    }

    ProxyProtocolEngineFactory(Supplier<ProxyProtocolEngine> proxyProtocolEngineSupplier) {
        this.proxyProtocolEngineSupplier = proxyProtocolEngineSupplier;
    }

    public ProxyProtocolEngineFactory(ProxyProtocol proxyProtocol, Map<String, Object> configs, Mode mode, LogContext logContext) {
        this.proxyProtocolEngineSupplier = () -> {
            ProxyProtocolEngine engine;
            switch (proxyProtocol) {
                case V1: {
                    engine = new ProxyProtocolV1Engine(mode, logContext);
                    break;
                }
                case V2: {
                    engine = new ProxyProtocolV2Engine(mode, logContext);
                    break;
                }
                case NONE: {
                    engine = new NoOpProxyProtocolEngine(mode);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized PROXY protocol version " + (Object)((Object)proxyProtocol));
                }
            }
            engine.configure(configs);
            return engine;
        };
    }

    ProxyProtocolEngine createProxyProtocolEngine() {
        return this.proxyProtocolEngineSupplier.get();
    }
}

