/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ConfluentBrokenPrincipalData
implements ApiMessage {
    String type;
    String name;
    boolean tokenAuthenticated;
    String saslAuthenticationId;
    String tenantName;
    String clusterId;
    String organizationId;
    String environmentId;
    String userResourceId;
    boolean serviceAccount;
    boolean apiKeyAuthenticated;
    boolean healthcheckTenant;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("type", Type.COMPACT_STRING, "The principal type"), new Field("name", Type.COMPACT_STRING, "The principal name"), new Field("token_authenticated", Type.BOOLEAN, "Whether the principal was authenticated by a delegation token on the forwarding broker."), new Field("sasl_authentication_id", Type.COMPACT_NULLABLE_STRING, "The SASL Authentication ID."), new Field("tenant_name", Type.COMPACT_NULLABLE_STRING, "The tenant name."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The clusterId of the tenant's physical Kafka cluster."), new Field("organization_id", Type.COMPACT_NULLABLE_STRING, "The tenant's organization ID."), new Field("environment_id", Type.COMPACT_NULLABLE_STRING, "The tenant's Environment ID."), new Field("user_resource_id", Type.COMPACT_NULLABLE_STRING, "User resource ID."), new Field("service_account", Type.BOOLEAN, "Whether the principal is a service account or not."), new Field("api_key_authenticated", Type.BOOLEAN, "Whether the tenant authenticated via an API Key or not."), new Field("healthcheck_tenant", Type.BOOLEAN, "Whether the tenant is a healthcheck tenant or not."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ConfluentBrokenPrincipalData(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public ConfluentBrokenPrincipalData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ConfluentBrokenPrincipalData() {
        this.type = "";
        this.name = "";
        this.tokenAuthenticated = false;
        this.saslAuthenticationId = "";
        this.tenantName = "";
        this.clusterId = "";
        this.organizationId = "";
        this.environmentId = "";
        this.userResourceId = "";
        this.serviceAccount = false;
        this.apiKeyAuthenticated = false;
        this.healthcheckTenant = false;
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field type was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field type had invalid length " + length);
        }
        this.type = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field name was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field name had invalid length " + length);
        }
        this.name = _readable.readString(length);
        this.tokenAuthenticated = _readable.readByte() != 0;
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.saslAuthenticationId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field saslAuthenticationId had invalid length " + length);
            }
            this.saslAuthenticationId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.tenantName = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field tenantName had invalid length " + length);
            }
            this.tenantName = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.clusterId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clusterId had invalid length " + length);
            }
            this.clusterId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.organizationId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field organizationId had invalid length " + length);
            }
            this.organizationId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.environmentId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field environmentId had invalid length " + length);
            }
            this.environmentId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.userResourceId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field userResourceId had invalid length " + length);
            }
            this.userResourceId = _readable.readString(length);
        }
        this.serviceAccount = _readable.readByte() != 0;
        this.apiKeyAuthenticated = _readable.readByte() != 0;
        this.healthcheckTenant = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue(this.type);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue(this.name);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeByte(this.tokenAuthenticated ? (byte)1 : 0);
        if (this.saslAuthenticationId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.saslAuthenticationId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (this.tenantName == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.tenantName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (this.clusterId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.clusterId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (this.organizationId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.organizationId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (this.environmentId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.environmentId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (this.userResourceId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.userResourceId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.serviceAccount ? (byte)1 : 0);
        _writable.writeByte(this.apiKeyAuthenticated ? (byte)1 : 0);
        _writable.writeByte(this.healthcheckTenant ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.type.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'type' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.type, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'name' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.name, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(1);
        if (this.saslAuthenticationId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.saslAuthenticationId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'saslAuthenticationId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.saslAuthenticationId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.tenantName == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.tenantName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tenantName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.tenantName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.clusterId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.organizationId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.organizationId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'organizationId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.organizationId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.environmentId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.environmentId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'environmentId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.environmentId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.userResourceId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.userResourceId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'userResourceId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.userResourceId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(1);
        _size.addBytes(1);
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfluentBrokenPrincipalData)) {
            return false;
        }
        ConfluentBrokenPrincipalData other = (ConfluentBrokenPrincipalData)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.tokenAuthenticated != other.tokenAuthenticated) {
            return false;
        }
        if (this.saslAuthenticationId == null ? other.saslAuthenticationId != null : !this.saslAuthenticationId.equals(other.saslAuthenticationId)) {
            return false;
        }
        if (this.tenantName == null ? other.tenantName != null : !this.tenantName.equals(other.tenantName)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.organizationId == null ? other.organizationId != null : !this.organizationId.equals(other.organizationId)) {
            return false;
        }
        if (this.environmentId == null ? other.environmentId != null : !this.environmentId.equals(other.environmentId)) {
            return false;
        }
        if (this.userResourceId == null ? other.userResourceId != null : !this.userResourceId.equals(other.userResourceId)) {
            return false;
        }
        if (this.serviceAccount != other.serviceAccount) {
            return false;
        }
        if (this.apiKeyAuthenticated != other.apiKeyAuthenticated) {
            return false;
        }
        if (this.healthcheckTenant != other.healthcheckTenant) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.type == null ? 0 : this.type.hashCode());
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        hashCode = 31 * hashCode + (this.tokenAuthenticated ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.saslAuthenticationId == null ? 0 : this.saslAuthenticationId.hashCode());
        hashCode = 31 * hashCode + (this.tenantName == null ? 0 : this.tenantName.hashCode());
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + (this.organizationId == null ? 0 : this.organizationId.hashCode());
        hashCode = 31 * hashCode + (this.environmentId == null ? 0 : this.environmentId.hashCode());
        hashCode = 31 * hashCode + (this.userResourceId == null ? 0 : this.userResourceId.hashCode());
        hashCode = 31 * hashCode + (this.serviceAccount ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.apiKeyAuthenticated ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.healthcheckTenant ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public ConfluentBrokenPrincipalData duplicate() {
        ConfluentBrokenPrincipalData _duplicate = new ConfluentBrokenPrincipalData();
        _duplicate.type = this.type;
        _duplicate.name = this.name;
        _duplicate.tokenAuthenticated = this.tokenAuthenticated;
        _duplicate.saslAuthenticationId = this.saslAuthenticationId == null ? null : this.saslAuthenticationId;
        _duplicate.tenantName = this.tenantName == null ? null : this.tenantName;
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.organizationId = this.organizationId == null ? null : this.organizationId;
        _duplicate.environmentId = this.environmentId == null ? null : this.environmentId;
        _duplicate.userResourceId = this.userResourceId == null ? null : this.userResourceId;
        _duplicate.serviceAccount = this.serviceAccount;
        _duplicate.apiKeyAuthenticated = this.apiKeyAuthenticated;
        _duplicate.healthcheckTenant = this.healthcheckTenant;
        return _duplicate;
    }

    public String toString() {
        return "ConfluentBrokenPrincipalData(type=" + (this.type == null ? "null" : "'" + this.type.toString() + "'") + ", name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", tokenAuthenticated=" + (this.tokenAuthenticated ? "true" : "false") + ", saslAuthenticationId=" + (this.saslAuthenticationId == null ? "null" : "'" + this.saslAuthenticationId.toString() + "'") + ", tenantName=" + (this.tenantName == null ? "null" : "'" + this.tenantName.toString() + "'") + ", clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", organizationId=" + (this.organizationId == null ? "null" : "'" + this.organizationId.toString() + "'") + ", environmentId=" + (this.environmentId == null ? "null" : "'" + this.environmentId.toString() + "'") + ", userResourceId=" + (this.userResourceId == null ? "null" : "'" + this.userResourceId.toString() + "'") + ", serviceAccount=" + (this.serviceAccount ? "true" : "false") + ", apiKeyAuthenticated=" + (this.apiKeyAuthenticated ? "true" : "false") + ", healthcheckTenant=" + (this.healthcheckTenant ? "true" : "false") + ")";
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public boolean tokenAuthenticated() {
        return this.tokenAuthenticated;
    }

    public String saslAuthenticationId() {
        return this.saslAuthenticationId;
    }

    public String tenantName() {
        return this.tenantName;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String userResourceId() {
        return this.userResourceId;
    }

    public boolean serviceAccount() {
        return this.serviceAccount;
    }

    public boolean apiKeyAuthenticated() {
        return this.apiKeyAuthenticated;
    }

    public boolean healthcheckTenant() {
        return this.healthcheckTenant;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConfluentBrokenPrincipalData setType(String v) {
        this.type = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setName(String v) {
        this.name = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setTokenAuthenticated(boolean v) {
        this.tokenAuthenticated = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setSaslAuthenticationId(String v) {
        this.saslAuthenticationId = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setTenantName(String v) {
        this.tenantName = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setOrganizationId(String v) {
        this.organizationId = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setEnvironmentId(String v) {
        this.environmentId = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setUserResourceId(String v) {
        this.userResourceId = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setServiceAccount(boolean v) {
        this.serviceAccount = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setApiKeyAuthenticated(boolean v) {
        this.apiKeyAuthenticated = v;
        return this;
    }

    public ConfluentBrokenPrincipalData setHealthcheckTenant(boolean v) {
        this.healthcheckTenant = v;
        return this;
    }
}

