/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PartitionPlacementStrategy {
    PARTITION_IN_CELL(0),
    TENANT_IN_CELL(1),
    CLUSTER_WIDE(2);

    private static final Map<Integer, PartitionPlacementStrategy> CODE_TO_CELL_PLACEMENT;
    private final Integer code;

    public Integer code() {
        return this.code;
    }

    private PartitionPlacementStrategy(Integer code) {
        this.code = code;
    }

    public static PartitionPlacementStrategy toEnum(Integer code) {
        return CODE_TO_CELL_PLACEMENT.getOrDefault(code, PARTITION_IN_CELL);
    }

    static {
        CODE_TO_CELL_PLACEMENT = Arrays.stream(PartitionPlacementStrategy.values()).collect(Collectors.toMap(PartitionPlacementStrategy::code, Function.identity()));
    }
}

