/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.DefaultChannelMetadataRegistry;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerCallbackHandler;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class SaslServerAuthenticatorTest {
    @Test
    public void testOversizeRequest() throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)new DefaultChannelMetadataRegistry());
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(524289);
            return 4;
        });
        Assert.assertThrows(SaslAuthenticationException.class, () -> ((SaslServerAuthenticator)authenticator).authenticate());
        ((TransportLayer)Mockito.verify((Object)transportLayer)).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void testUnexpectedRequestType() throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)new DefaultChannelMetadataRegistry());
        RequestHeader header = new RequestHeader(ApiKeys.METADATA, 0, "clientId", 13243);
        Struct headerStruct = header.toStruct();
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(headerStruct.sizeOf());
            return 4;
        }).then(invocation -> {
            headerStruct.writeTo((ByteBuffer)invocation.getArgument(0));
            return headerStruct.sizeOf();
        });
        try {
            authenticator.authenticate();
            Assert.fail((String)"Expected authenticate() to raise an exception");
        }
        catch (IllegalSaslStateException illegalSaslStateException) {
            // empty catch block
        }
        ((TransportLayer)Mockito.verify((Object)transportLayer, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void testOldestApiVersionsRequest() throws IOException {
        this.testApiVersionsRequest(ApiKeys.API_VERSIONS.oldestVersion(), "unknown", "unknown");
    }

    @Test
    public void testLatestApiVersionsRequest() throws IOException {
        this.testApiVersionsRequest(ApiKeys.API_VERSIONS.latestVersion(), "apache-kafka-java", AppInfoParser.getVersion());
    }

    public void testApiVersionsRequest(short version, String expectedSoftwareName, String expectedSoftwareVersion) throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        DefaultChannelMetadataRegistry metadataRegistry = new DefaultChannelMetadataRegistry();
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)metadataRegistry);
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, version, "clientId", 0);
        Struct headerStruct = header.toStruct();
        ApiVersionsRequest request = new ApiVersionsRequest.Builder().build(version);
        Struct requestStruct = request.data.toStruct(version);
        Mockito.when((Object)transportLayer.socketChannel().socket().getInetAddress()).thenReturn((Object)InetAddress.getLoopbackAddress());
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(headerStruct.sizeOf() + requestStruct.sizeOf());
            return 4;
        }).then(invocation -> {
            headerStruct.writeTo((ByteBuffer)invocation.getArgument(0));
            requestStruct.writeTo((ByteBuffer)invocation.getArgument(0));
            return headerStruct.sizeOf() + requestStruct.sizeOf();
        });
        authenticator.authenticate();
        Assert.assertEquals((Object)expectedSoftwareName, (Object)metadataRegistry.clientInformation().softwareName());
        Assert.assertEquals((Object)expectedSoftwareVersion, (Object)metadataRegistry.clientInformation().softwareVersion());
        ((TransportLayer)Mockito.verify((Object)transportLayer, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    private SaslServerAuthenticator setupAuthenticator(Map<String, ?> configs, TransportLayer transportLayer, String mechanism, ChannelMetadataRegistry metadataRegistry) throws IOException {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        Map<String, Subject> subjects = Collections.singletonMap(mechanism, new Subject());
        Map<String, SaslServerCallbackHandler> callbackHandlers = Collections.singletonMap(mechanism, new SaslServerCallbackHandler());
        return new SaslServerAuthenticator(configs, callbackHandlers, "node", subjects, null, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, transportLayer, Collections.emptyMap(), metadataRegistry, Time.SYSTEM);
    }
}

