/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;

public class RequestContextTest {
    @Test
    public void testSerdeUnsupportedApiVersionRequest() throws Exception {
        int correlationId = 23423;
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, Short.MAX_VALUE, "", correlationId);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY);
        Assert.assertEquals((long)0L, (long)context.apiVersion());
        ByteBuffer requestBuffer = ByteBuffer.allocate(8);
        requestBuffer.putInt(3709234);
        requestBuffer.putInt(29034);
        requestBuffer.flip();
        RequestAndSize requestAndSize = context.parseRequest(requestBuffer);
        Assert.assertTrue((boolean)(requestAndSize.request instanceof ApiVersionsRequest));
        ApiVersionsRequest request = (ApiVersionsRequest)requestAndSize.request;
        Assert.assertTrue((boolean)request.hasUnsupportedRequestVersion());
        Send send = context.buildResponse((AbstractResponse)new ApiVersionsResponse(new ApiVersionsResponseData().setThrottleTimeMs(0).setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setApiKeys(new ApiVersionsResponseData.ApiVersionsResponseKeyCollection())));
        ByteBufferChannel channel = new ByteBufferChannel(256L);
        send.writeTo((GatheringByteChannel)channel);
        ByteBuffer responseBuffer = channel.buffer();
        responseBuffer.flip();
        responseBuffer.getInt();
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer, (short)ApiKeys.API_VERSIONS.responseHeaderVersion(header.apiVersion()));
        Assert.assertEquals((long)correlationId, (long)responseHeader.correlationId());
        Struct struct = ApiKeys.API_VERSIONS.parseResponse((short)0, responseBuffer);
        ApiVersionsResponse response = (ApiVersionsResponse)AbstractResponse.parseResponse((ApiKeys)ApiKeys.API_VERSIONS, (Struct)struct, (short)0);
        Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)response.data.errorCode());
        Assert.assertTrue((boolean)response.data.apiKeys().isEmpty());
    }

    @Test
    public void testInvalidRequestForImplicitHashCollection() throws UnknownHostException {
        short version = 5;
        ByteBuffer corruptBuffer = this.produceRequest(version);
        corruptBuffer.putInt(8, 0x3FFFFFFF);
        RequestHeader header = new RequestHeader(ApiKeys.PRODUCE, version, "console-producer", 3);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY);
        String msg = ((InvalidRequestException)Assert.assertThrows(InvalidRequestException.class, () -> context.parseRequest(corruptBuffer))).getCause().getMessage();
        Assert.assertEquals((Object)"Error reading field 'topic_data': Error reading array of size 1073741823, only 17 bytes available", (Object)msg);
    }

    @Test
    public void testInvalidRequestForArrayList() throws UnknownHostException {
        short version = 5;
        ByteBuffer corruptBuffer = this.produceRequest(version);
        corruptBuffer.putInt(17, Integer.MAX_VALUE);
        RequestHeader header = new RequestHeader(ApiKeys.PRODUCE, version, "console-producer", 3);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY);
        String msg = ((InvalidRequestException)Assert.assertThrows(InvalidRequestException.class, () -> context.parseRequest(corruptBuffer))).getCause().getMessage();
        Assert.assertEquals((Object)"Error reading field 'topic_data': Error reading field 'data': Error reading array of size 2147483647, only 8 bytes available", (Object)msg);
    }

    private ByteBuffer produceRequest(short version) {
        ProduceRequestData data = new ProduceRequestData().setAcks((short)-1).setTimeoutMs(1);
        List<ProduceRequestData.TopicProduceData> topicProduceData = Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("foo").setPartitions(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setPartitionIndex(42))));
        data.setTopics(topicProduceData);
        return this.serialize(version, data);
    }

    private ByteBuffer serialize(short version, ApiMessage data) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        data.size(cache, version);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        data.write((Writable)new ByteBufferAccessor(buffer), cache, version);
        buffer.flip();
        return buffer;
    }

    @Test
    public void testInvalidRequestForByteArray() throws UnknownHostException {
        short version = 1;
        ByteBuffer corruptBuffer = this.serialize(version, new SaslAuthenticateRequestData().setAuthBytes(new byte[0]));
        corruptBuffer.putInt(0, Integer.MAX_VALUE);
        RequestHeader header = new RequestHeader(ApiKeys.SASL_AUTHENTICATE, version, "console-producer", 1);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY);
        String msg = ((InvalidRequestException)Assert.assertThrows(InvalidRequestException.class, () -> context.parseRequest(corruptBuffer))).getCause().getMessage();
        Assert.assertEquals((Object)"Error reading field 'auth_bytes': Error reading bytes of size 2147483647, only 0 bytes available", (Object)msg);
    }
}

