/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SimpleExampleMessageData
implements ApiMessage {
    UUID processId;
    List<Integer> myTaggedIntArray;
    String myNullableString;
    short myInt16;
    double myFloat64;
    String myString;
    byte[] myBytes;
    UUID taggedUuid;
    long taggedLong;
    ByteBuffer zeroCopyByteBuffer;
    ByteBuffer nullableZeroCopyByteBuffer;
    MyStruct myStruct;
    TaggedStruct myTaggedStruct;
    TestCommonStruct myCommonStruct;
    TestCommonStruct myOtherCommonStruct;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("my_common_struct", (Type)TestCommonStruct.SCHEMA_0, ""), new Field("my_other_common_struct", (Type)TestCommonStruct.SCHEMA_0, "")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("process_id", (Type)Type.UUID, ""), new Field("zero_copy_byte_buffer", (Type)Type.COMPACT_BYTES, ""), new Field("nullable_zero_copy_byte_buffer", (Type)Type.COMPACT_NULLABLE_BYTES, ""), new Field("my_common_struct", (Type)TestCommonStruct.SCHEMA_1, ""), new Field("my_other_common_struct", (Type)TestCommonStruct.SCHEMA_1, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("my_tagged_int_array", (Type)new CompactArrayOf((Type)Type.INT32), ""), 1, new Field("my_nullable_string", (Type)Type.COMPACT_NULLABLE_STRING, ""), 2, new Field("my_int16", (Type)Type.INT16, ""), 3, new Field("my_float64", (Type)Type.FLOAT64, ""), 4, new Field("my_string", (Type)Type.COMPACT_STRING, ""), 5, new Field("my_bytes", (Type)Type.COMPACT_NULLABLE_BYTES, ""), 6, new Field("tagged_uuid", (Type)Type.UUID, ""), 7, new Field("tagged_long", (Type)Type.INT64, "")})});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("process_id", (Type)Type.UUID, ""), new Field("my_struct", (Type)MyStruct.SCHEMA_2, "Test Struct field"), new Field("my_common_struct", (Type)TestCommonStruct.SCHEMA_1, ""), new Field("my_other_common_struct", (Type)TestCommonStruct.SCHEMA_1, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("my_tagged_int_array", (Type)new CompactArrayOf((Type)Type.INT32), ""), 1, new Field("my_nullable_string", (Type)Type.COMPACT_NULLABLE_STRING, ""), 2, new Field("my_int16", (Type)Type.INT16, ""), 3, new Field("my_float64", (Type)Type.FLOAT64, ""), 4, new Field("my_string", (Type)Type.COMPACT_STRING, ""), 5, new Field("my_bytes", (Type)Type.COMPACT_NULLABLE_BYTES, ""), 6, new Field("tagged_uuid", (Type)Type.UUID, ""), 7, new Field("tagged_long", (Type)Type.INT64, ""), 8, new Field("my_tagged_struct", (Type)TaggedStruct.SCHEMA_2, "Test Tagged Struct field")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public SimpleExampleMessageData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SimpleExampleMessageData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public SimpleExampleMessageData() {
        this.processId = MessageUtil.ZERO_UUID;
        this.myTaggedIntArray = new ArrayList<Integer>(0);
        this.myNullableString = null;
        this.myInt16 = (short)123;
        this.myFloat64 = Double.parseDouble("12.34");
        this.myString = "";
        this.myBytes = Bytes.EMPTY;
        this.taggedUuid = UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367");
        this.taggedLong = 0xCAFCACAFCACAFCAL;
        this.zeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        this.nullableZeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        this.myStruct = new MyStruct();
        this.myTaggedStruct = new TaggedStruct();
        this.myCommonStruct = new TestCommonStruct();
        this.myOtherCommonStruct = new TestCommonStruct();
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version) {
        int length;
        this.processId = _version >= 1 ? _readable.readUUID() : MessageUtil.ZERO_UUID;
        this.myTaggedIntArray = new ArrayList<Integer>(0);
        this.myNullableString = null;
        this.myInt16 = (short)123;
        this.myFloat64 = Double.parseDouble("12.34");
        this.myString = "";
        this.myBytes = Bytes.EMPTY;
        this.taggedUuid = UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367");
        this.taggedLong = 0xCAFCACAFCACAFCAL;
        if (_version >= 1 && _version <= 1) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field zeroCopyByteBuffer was serialized as null");
            }
            this.zeroCopyByteBuffer = _readable.readByteBuffer(length);
        } else {
            this.zeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        }
        this.nullableZeroCopyByteBuffer = _version >= 1 && _version <= 1 ? ((length = _readable.readUnsignedVarint() - 1) < 0 ? null : _readable.readByteBuffer(length)) : ByteUtils.EMPTY_BUF;
        this.myStruct = _version >= 2 ? new MyStruct(_readable, _version) : new MyStruct();
        this.myTaggedStruct = new TaggedStruct();
        this.myCommonStruct = new TestCommonStruct(_readable, _version);
        this.myOtherCommonStruct = new TestCommonStruct(_readable, _version);
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block11: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            throw new RuntimeException("non-nullable field myTaggedIntArray was serialized as null");
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readInt());
                        }
                        this.myTaggedIntArray = newCollection;
                        continue block11;
                    }
                    case 1: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.myNullableString = null;
                            continue block11;
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field myNullableString had invalid length " + length2);
                        }
                        this.myNullableString = _readable.readString(length2);
                        continue block11;
                    }
                    case 2: {
                        this.myInt16 = _readable.readShort();
                        continue block11;
                    }
                    case 3: {
                        this.myFloat64 = _readable.readDouble();
                        continue block11;
                    }
                    case 4: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            throw new RuntimeException("non-nullable field myString was serialized as null");
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field myString had invalid length " + length2);
                        }
                        this.myString = _readable.readString(length2);
                        continue block11;
                    }
                    case 5: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.myBytes = null;
                            continue block11;
                        }
                        byte[] newBytes = _readable.readArray(length2);
                        this.myBytes = newBytes;
                        continue block11;
                    }
                    case 6: {
                        this.taggedUuid = _readable.readUUID();
                        continue block11;
                    }
                    case 7: {
                        this.taggedLong = _readable.readLong();
                        continue block11;
                    }
                    case 8: {
                        if (_version >= 2) {
                            this.myTaggedStruct = new TaggedStruct(_readable, _version);
                            continue block11;
                        }
                        throw new RuntimeException("Tag 8 is not valid for version " + _version);
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeUUID(this.processId);
        } else if (!this.processId.equals(MessageUtil.ZERO_UUID)) {
            throw new UnsupportedVersionException("Attempted to write a non-default processId at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myTaggedIntArray.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.myTaggedIntArray.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedIntArray at version " + _version);
        }
        if (_version >= 1) {
            if (this.myNullableString != null) {
                ++_numTaggedFields;
            }
        } else if (this.myNullableString != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default myNullableString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myInt16 != 123) {
                ++_numTaggedFields;
            }
        } else if (this.myInt16 != 123) {
            throw new UnsupportedVersionException("Attempted to write a non-default myInt16 at version " + _version);
        }
        if (_version >= 1) {
            if (this.myFloat64 != Double.parseDouble("12.34")) {
                ++_numTaggedFields;
            }
        } else if (this.myFloat64 != Double.parseDouble("12.34")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myFloat64 at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myString.equals("")) {
                ++_numTaggedFields;
            }
        } else if (!this.myString.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myBytes == null || this.myBytes.length != 0) {
                ++_numTaggedFields;
            }
        } else if (this.myBytes == null || this.myBytes.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default myBytes at version " + _version);
        }
        if (_version >= 1) {
            if (!this.taggedUuid.equals(UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367"))) {
                ++_numTaggedFields;
            }
        } else if (!this.taggedUuid.equals(UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367"))) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedUuid at version " + _version);
        }
        if (_version >= 1) {
            if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
                ++_numTaggedFields;
            }
        } else if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedLong at version " + _version);
        }
        if (_version >= 1 && _version <= 1) {
            _writable.writeUnsignedVarint(this.zeroCopyByteBuffer.remaining() + 1);
            _writable.writeByteBuffer(this.zeroCopyByteBuffer);
        } else if (this.zeroCopyByteBuffer.hasRemaining()) {
            throw new UnsupportedVersionException("Attempted to write a non-default zeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 1 && _version <= 1) {
            if (this.nullableZeroCopyByteBuffer == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.nullableZeroCopyByteBuffer.remaining() + 1);
                _writable.writeByteBuffer(this.nullableZeroCopyByteBuffer);
            }
        } else if (this.nullableZeroCopyByteBuffer == null || this.nullableZeroCopyByteBuffer.remaining() > 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default nullableZeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 2) {
            this.myStruct.write(_writable, _cache, _version);
        } else if (!this.myStruct.equals(new MyStruct())) {
            throw new UnsupportedVersionException("Attempted to write a non-default myStruct at version " + _version);
        }
        if (_version >= 2) {
            if (!this.myTaggedStruct.equals(new TaggedStruct())) {
                ++_numTaggedFields;
            }
        } else if (!this.myTaggedStruct.equals(new TaggedStruct())) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedStruct at version " + _version);
        }
        this.myCommonStruct.write(_writable, _cache, _version);
        this.myOtherCommonStruct.write(_writable, _cache, _version);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 1) {
            byte[] _stringBytes;
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (!this.myTaggedIntArray.isEmpty()) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.myTaggedIntArray));
                _writable.writeUnsignedVarint(this.myTaggedIntArray.size() + 1);
                for (Integer myTaggedIntArrayElement : this.myTaggedIntArray) {
                    _writable.writeInt(myTaggedIntArrayElement.intValue());
                }
            }
            if (this.myNullableString != null) {
                _writable.writeUnsignedVarint(1);
                _stringBytes = _cache.getSerializedValue((Object)this.myNullableString);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.myInt16 != 123) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(2);
                _writable.writeShort(this.myInt16);
            }
            if (this.myFloat64 != Double.parseDouble("12.34")) {
                _writable.writeUnsignedVarint(3);
                _writable.writeUnsignedVarint(8);
                _writable.writeDouble(this.myFloat64);
            }
            if (!this.myString.equals("")) {
                _writable.writeUnsignedVarint(4);
                _stringBytes = _cache.getSerializedValue((Object)this.myString);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.myBytes == null) {
                _writable.writeUnsignedVarint(5);
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(0);
            } else if (this.myBytes.length != 0) {
                _writable.writeUnsignedVarint(5);
                _writable.writeUnsignedVarint(this.myBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(this.myBytes.length + 1)));
                _writable.writeUnsignedVarint(this.myBytes.length + 1);
                _writable.writeByteArray(this.myBytes);
            }
            if (!this.taggedUuid.equals(UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367"))) {
                _writable.writeUnsignedVarint(6);
                _writable.writeUnsignedVarint(16);
                _writable.writeUUID(this.taggedUuid);
            }
            if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
                _writable.writeUnsignedVarint(7);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.taggedLong);
            }
            if (!this.myTaggedStruct.equals(new TaggedStruct())) {
                _writable.writeUnsignedVarint(8);
                _writable.writeUnsignedVarint(this.myTaggedStruct.size(_cache, _version));
                this.myTaggedStruct.write(_writable, _cache, _version);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        ByteBuffer _byteBuffer;
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.processId = _version >= 1 ? struct.getUUID("process_id") : MessageUtil.ZERO_UUID;
        if (_version >= 1) {
            if (_taggedFields.containsKey(0)) {
                Object[] _nestedObjects = (Object[])_taggedFields.remove(0);
                this.myTaggedIntArray = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.myTaggedIntArray.add((Integer)nestedObject);
                }
            } else {
                this.myTaggedIntArray = new ArrayList<Integer>(0);
            }
        } else {
            this.myTaggedIntArray = new ArrayList<Integer>(0);
        }
        this.myNullableString = _version >= 1 ? (_taggedFields.containsKey(1) ? (String)_taggedFields.remove(1) : null) : null;
        this.myInt16 = _version >= 1 ? (_taggedFields.containsKey(2) ? (Short)_taggedFields.remove(2) : (short)123) : (short)123;
        this.myFloat64 = _version >= 1 ? (_taggedFields.containsKey(3) ? (Double)_taggedFields.remove(3) : Double.parseDouble("12.34")) : Double.parseDouble("12.34");
        this.myString = _version >= 1 ? (_taggedFields.containsKey(4) ? (String)_taggedFields.remove(4) : "") : "";
        this.myBytes = _version >= 1 ? (_taggedFields.containsKey(5) ? (Object)((_byteBuffer = (ByteBuffer)_taggedFields.remove(5)) == null ? null : MessageUtil.byteBufferToArray((ByteBuffer)_byteBuffer)) : Bytes.EMPTY) : Bytes.EMPTY;
        this.taggedUuid = _version >= 1 ? (_taggedFields.containsKey(6) ? (UUID)_taggedFields.remove(6) : UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367")) : UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367");
        this.taggedLong = _version >= 1 ? (_taggedFields.containsKey(7) ? (Long)_taggedFields.remove(7) : 0xCAFCACAFCACAFCAL) : 0xCAFCACAFCACAFCAL;
        this.zeroCopyByteBuffer = _version >= 1 && _version <= 1 ? struct.getBytes("zero_copy_byte_buffer") : ByteUtils.EMPTY_BUF;
        this.nullableZeroCopyByteBuffer = _version >= 1 && _version <= 1 ? struct.getBytes("nullable_zero_copy_byte_buffer") : ByteUtils.EMPTY_BUF;
        this.myStruct = _version >= 2 ? new MyStruct((Struct)struct.get("my_struct"), _version) : new MyStruct();
        this.myTaggedStruct = _version >= 2 ? (_taggedFields.containsKey(8) ? new TaggedStruct((Struct)_taggedFields.remove(8), _version) : new TaggedStruct()) : new TaggedStruct();
        this.myCommonStruct = new TestCommonStruct((Struct)struct.get("my_common_struct"), _version);
        this.myOtherCommonStruct = new TestCommonStruct((Struct)struct.get("my_other_common_struct"), _version);
        if (_version >= 1 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap<Integer, Object> _taggedFields = null;
        if (_version >= 1) {
            _taggedFields = new TreeMap<Integer, Object>();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("process_id", (Object)this.processId);
        } else if (!this.processId.equals(MessageUtil.ZERO_UUID)) {
            throw new UnsupportedVersionException("Attempted to write a non-default processId at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myTaggedIntArray.isEmpty()) {
                Integer[] _nestedObjects = new Integer[this.myTaggedIntArray.size()];
                int i = 0;
                for (Integer element : this.myTaggedIntArray) {
                    _nestedObjects[i++] = element;
                }
                _taggedFields.put(0, _nestedObjects);
            }
        } else if (!this.myTaggedIntArray.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedIntArray at version " + _version);
        }
        if (_version >= 1) {
            if (this.myNullableString != null) {
                _taggedFields.put(1, this.myNullableString);
            }
        } else if (this.myNullableString != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default myNullableString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myInt16 != 123) {
                _taggedFields.put(2, this.myInt16);
            }
        } else if (this.myInt16 != 123) {
            throw new UnsupportedVersionException("Attempted to write a non-default myInt16 at version " + _version);
        }
        if (_version >= 1) {
            if (this.myFloat64 != Double.parseDouble("12.34")) {
                _taggedFields.put(3, this.myFloat64);
            }
        } else if (this.myFloat64 != Double.parseDouble("12.34")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myFloat64 at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myString.equals("")) {
                _taggedFields.put(4, this.myString);
            }
        } else if (!this.myString.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myBytes == null || this.myBytes.length != 0) {
                _taggedFields.put(5, this.myBytes == null ? null : ByteBuffer.wrap(this.myBytes));
            }
        } else if (this.myBytes == null || this.myBytes.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default myBytes at version " + _version);
        }
        if (_version >= 1) {
            if (!this.taggedUuid.equals(UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367"))) {
                _taggedFields.put(6, this.taggedUuid);
            }
        } else if (!this.taggedUuid.equals(UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367"))) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedUuid at version " + _version);
        }
        if (_version >= 1) {
            if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
                _taggedFields.put(7, this.taggedLong);
            }
        } else if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedLong at version " + _version);
        }
        if (_version >= 1 && _version <= 1) {
            struct.set("zero_copy_byte_buffer", (Object)this.zeroCopyByteBuffer);
        } else if (this.zeroCopyByteBuffer.hasRemaining()) {
            throw new UnsupportedVersionException("Attempted to write a non-default zeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 1 && _version <= 1) {
            struct.set("nullable_zero_copy_byte_buffer", (Object)this.nullableZeroCopyByteBuffer);
        } else if (this.nullableZeroCopyByteBuffer == null || this.nullableZeroCopyByteBuffer.remaining() > 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default nullableZeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 2) {
            struct.set("my_struct", (Object)this.myStruct.toStruct(_version));
        } else if (!this.myStruct.equals(new MyStruct())) {
            throw new UnsupportedVersionException("Attempted to write a non-default myStruct at version " + _version);
        }
        if (_version >= 2) {
            if (!this.myTaggedStruct.equals(new TaggedStruct())) {
                _taggedFields.put(8, this.myTaggedStruct.toStruct(_version));
            }
        } else if (!this.myTaggedStruct.equals(new TaggedStruct())) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedStruct at version " + _version);
        }
        struct.set("my_common_struct", (Object)this.myCommonStruct.toStruct(_version));
        struct.set("my_other_common_struct", (Object)this.myOtherCommonStruct.toStruct(_version));
        if (_version >= 1) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _stringPrefixSize;
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 16;
        }
        if (_version >= 1 && !this.myTaggedIntArray.isEmpty()) {
            ++_numTaggedFields;
            ++_size;
            int _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.myTaggedIntArray.size() + 1));
            _cache.setArraySizeInBytes(this.myTaggedIntArray, _arraySize += this.myTaggedIntArray.size() * 4);
            _size += _arraySize + ByteUtils.sizeOfUnsignedVarint((int)_arraySize);
        }
        if (_version >= 1 && this.myNullableString != null) {
            ++_numTaggedFields;
            ++_size;
            byte[] _stringBytes = this.myNullableString.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'myNullableString' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.myNullableString, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length));
        }
        if (_version >= 1 && this.myInt16 != 123) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 2;
        }
        if (_version >= 1 && this.myFloat64 != Double.parseDouble("12.34")) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 8;
        }
        if (_version >= 1 && !this.myString.equals("")) {
            ++_numTaggedFields;
            ++_size;
            byte[] _stringBytes = this.myString.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'myString' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.myString, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length));
        }
        if (_version >= 1) {
            if (this.myBytes == null) {
                ++_numTaggedFields;
                ++_size;
                ++_size;
                ++_size;
            } else if (this.myBytes.length != 0) {
                ++_numTaggedFields;
                ++_size;
                int _bytesSize = this.myBytes.length;
                _size += (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.myBytes.length + 1))) + ByteUtils.sizeOfUnsignedVarint((int)_bytesSize);
            }
        }
        if (_version >= 1 && !this.taggedUuid.equals(UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367"))) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 16;
        }
        if (_version >= 1 && this.taggedLong != 0xCAFCACAFCACAFCAL) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 8;
        }
        if (_version >= 1 && _version <= 1) {
            int _bytesSize = this.zeroCopyByteBuffer.remaining();
            _size += (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.zeroCopyByteBuffer.remaining() + 1)));
        }
        if (_version >= 1 && _version <= 1) {
            if (this.nullableZeroCopyByteBuffer == null) {
                ++_size;
            } else {
                int _bytesSize = this.nullableZeroCopyByteBuffer.remaining();
                _size += (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.nullableZeroCopyByteBuffer.remaining() + 1)));
            }
        }
        if (_version >= 2) {
            int size = this.myStruct.size(_cache, _version);
            _size += size;
        }
        if (_version >= 2 && !this.myTaggedStruct.equals(new TaggedStruct())) {
            ++_numTaggedFields;
            ++_size;
            int size = this.myTaggedStruct.size(_cache, _version);
            _size += ByteUtils.sizeOfUnsignedVarint((int)size);
            _size += size;
        }
        int size = this.myCommonStruct.size(_cache, _version);
        _size += size;
        size = this.myOtherCommonStruct.size(_cache, _version);
        _size += size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 1) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleExampleMessageData)) {
            return false;
        }
        SimpleExampleMessageData other = (SimpleExampleMessageData)obj;
        if (!this.processId.equals(other.processId)) {
            return false;
        }
        if (this.myTaggedIntArray == null ? other.myTaggedIntArray != null : !this.myTaggedIntArray.equals(other.myTaggedIntArray)) {
            return false;
        }
        if (this.myNullableString == null ? other.myNullableString != null : !this.myNullableString.equals(other.myNullableString)) {
            return false;
        }
        if (this.myInt16 != other.myInt16) {
            return false;
        }
        if (this.myFloat64 != other.myFloat64) {
            return false;
        }
        if (this.myString == null ? other.myString != null : !this.myString.equals(other.myString)) {
            return false;
        }
        if (!Arrays.equals(this.myBytes, other.myBytes)) {
            return false;
        }
        if (!this.taggedUuid.equals(other.taggedUuid)) {
            return false;
        }
        if (this.taggedLong != other.taggedLong) {
            return false;
        }
        if (!Objects.equals(this.zeroCopyByteBuffer, other.zeroCopyByteBuffer)) {
            return false;
        }
        if (!Objects.equals(this.nullableZeroCopyByteBuffer, other.nullableZeroCopyByteBuffer)) {
            return false;
        }
        if (this.myStruct == null ? other.myStruct != null : !this.myStruct.equals(other.myStruct)) {
            return false;
        }
        if (this.myTaggedStruct == null ? other.myTaggedStruct != null : !this.myTaggedStruct.equals(other.myTaggedStruct)) {
            return false;
        }
        if (this.myCommonStruct == null ? other.myCommonStruct != null : !this.myCommonStruct.equals(other.myCommonStruct)) {
            return false;
        }
        if (this.myOtherCommonStruct == null ? other.myOtherCommonStruct != null : !this.myOtherCommonStruct.equals(other.myOtherCommonStruct)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.processId.hashCode();
        hashCode = 31 * hashCode + (this.myTaggedIntArray == null ? 0 : this.myTaggedIntArray.hashCode());
        hashCode = 31 * hashCode + (this.myNullableString == null ? 0 : this.myNullableString.hashCode());
        hashCode = 31 * hashCode + this.myInt16;
        hashCode = 31 * hashCode + Double.hashCode(this.myFloat64);
        hashCode = 31 * hashCode + (this.myString == null ? 0 : this.myString.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.myBytes);
        hashCode = 31 * hashCode + this.taggedUuid.hashCode();
        hashCode = 31 * hashCode + ((int)(this.taggedLong >> 32) ^ (int)this.taggedLong);
        hashCode = 31 * hashCode + Objects.hashCode(this.zeroCopyByteBuffer);
        hashCode = 31 * hashCode + Objects.hashCode(this.nullableZeroCopyByteBuffer);
        hashCode = 31 * hashCode + (this.myStruct == null ? 0 : this.myStruct.hashCode());
        hashCode = 31 * hashCode + (this.myTaggedStruct == null ? 0 : this.myTaggedStruct.hashCode());
        hashCode = 31 * hashCode + (this.myCommonStruct == null ? 0 : this.myCommonStruct.hashCode());
        hashCode = 31 * hashCode + (this.myOtherCommonStruct == null ? 0 : this.myOtherCommonStruct.hashCode());
        return hashCode;
    }

    public SimpleExampleMessageData duplicate() {
        SimpleExampleMessageData _duplicate = new SimpleExampleMessageData();
        _duplicate.processId = this.processId;
        ArrayList<Integer> newMyTaggedIntArray = new ArrayList<Integer>(this.myTaggedIntArray.size());
        for (Integer _element : this.myTaggedIntArray) {
            newMyTaggedIntArray.add(_element);
        }
        _duplicate.myTaggedIntArray = newMyTaggedIntArray;
        _duplicate.myNullableString = this.myNullableString == null ? null : this.myNullableString;
        _duplicate.myInt16 = this.myInt16;
        _duplicate.myFloat64 = this.myFloat64;
        _duplicate.myString = this.myString;
        _duplicate.myBytes = (byte[])(this.myBytes == null ? null : MessageUtil.duplicate((byte[])this.myBytes));
        _duplicate.taggedUuid = this.taggedUuid;
        _duplicate.taggedLong = this.taggedLong;
        _duplicate.zeroCopyByteBuffer = this.zeroCopyByteBuffer.duplicate();
        _duplicate.nullableZeroCopyByteBuffer = this.nullableZeroCopyByteBuffer == null ? null : this.nullableZeroCopyByteBuffer.duplicate();
        _duplicate.myStruct = this.myStruct.duplicate();
        _duplicate.myTaggedStruct = this.myTaggedStruct.duplicate();
        _duplicate.myCommonStruct = this.myCommonStruct.duplicate();
        _duplicate.myOtherCommonStruct = this.myOtherCommonStruct.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "SimpleExampleMessageData(, myTaggedIntArray=" + MessageUtil.deepToString(this.myTaggedIntArray.iterator()) + ", myNullableString=" + (this.myNullableString == null ? "null" : "'" + this.myNullableString.toString() + "'") + ", myInt16=" + this.myInt16 + ", myFloat64=" + this.myFloat64 + ", myString=" + (this.myString == null ? "null" : "'" + this.myString.toString() + "'") + ", myBytes=" + Arrays.toString(this.myBytes) + ", taggedLong=" + this.taggedLong + ", zeroCopyByteBuffer=" + this.zeroCopyByteBuffer + ", nullableZeroCopyByteBuffer=" + this.nullableZeroCopyByteBuffer + ")";
    }

    public UUID processId() {
        return this.processId;
    }

    public List<Integer> myTaggedIntArray() {
        return this.myTaggedIntArray;
    }

    public String myNullableString() {
        return this.myNullableString;
    }

    public short myInt16() {
        return this.myInt16;
    }

    public double myFloat64() {
        return this.myFloat64;
    }

    public String myString() {
        return this.myString;
    }

    public byte[] myBytes() {
        return this.myBytes;
    }

    public UUID taggedUuid() {
        return this.taggedUuid;
    }

    public long taggedLong() {
        return this.taggedLong;
    }

    public ByteBuffer zeroCopyByteBuffer() {
        return this.zeroCopyByteBuffer;
    }

    public ByteBuffer nullableZeroCopyByteBuffer() {
        return this.nullableZeroCopyByteBuffer;
    }

    public MyStruct myStruct() {
        return this.myStruct;
    }

    public TaggedStruct myTaggedStruct() {
        return this.myTaggedStruct;
    }

    public TestCommonStruct myCommonStruct() {
        return this.myCommonStruct;
    }

    public TestCommonStruct myOtherCommonStruct() {
        return this.myOtherCommonStruct;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SimpleExampleMessageData setProcessId(UUID v) {
        this.processId = v;
        return this;
    }

    public SimpleExampleMessageData setMyTaggedIntArray(List<Integer> v) {
        this.myTaggedIntArray = v;
        return this;
    }

    public SimpleExampleMessageData setMyNullableString(String v) {
        this.myNullableString = v;
        return this;
    }

    public SimpleExampleMessageData setMyInt16(short v) {
        this.myInt16 = v;
        return this;
    }

    public SimpleExampleMessageData setMyFloat64(double v) {
        this.myFloat64 = v;
        return this;
    }

    public SimpleExampleMessageData setMyString(String v) {
        this.myString = v;
        return this;
    }

    public SimpleExampleMessageData setMyBytes(byte[] v) {
        this.myBytes = v;
        return this;
    }

    public SimpleExampleMessageData setTaggedUuid(UUID v) {
        this.taggedUuid = v;
        return this;
    }

    public SimpleExampleMessageData setTaggedLong(long v) {
        this.taggedLong = v;
        return this;
    }

    public SimpleExampleMessageData setZeroCopyByteBuffer(ByteBuffer v) {
        this.zeroCopyByteBuffer = v;
        return this;
    }

    public SimpleExampleMessageData setNullableZeroCopyByteBuffer(ByteBuffer v) {
        this.nullableZeroCopyByteBuffer = v;
        return this;
    }

    public SimpleExampleMessageData setMyStruct(MyStruct v) {
        this.myStruct = v;
        return this;
    }

    public SimpleExampleMessageData setMyTaggedStruct(TaggedStruct v) {
        this.myTaggedStruct = v;
        return this;
    }

    public SimpleExampleMessageData setMyCommonStruct(TestCommonStruct v) {
        this.myCommonStruct = v;
        return this;
    }

    public SimpleExampleMessageData setMyOtherCommonStruct(TestCommonStruct v) {
        this.myOtherCommonStruct = v;
        return this;
    }

    public static class TestCommonStruct
    implements Message {
        int foo;
        int bar;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("foo", (Type)Type.INT32, ""), new Field("bar", (Type)Type.INT32, "")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TestCommonStruct(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TestCommonStruct(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public TestCommonStruct() {
            this.foo = 123;
            this.bar = 123;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.foo = _readable.readInt();
            this.bar = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 1) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.foo);
            _writable.writeInt(this.bar);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 1) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 1) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.foo = struct.getInt("foo");
            this.bar = struct.getInt("bar");
            if (_version >= 1 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            TreeMap _taggedFields = null;
            if (_version >= 1) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("foo", (Object)this.foo);
            struct.set("bar", (Object)this.bar);
            if (_version >= 1) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            _size += 4;
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 1) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TestCommonStruct)) {
                return false;
            }
            TestCommonStruct other = (TestCommonStruct)obj;
            if (this.foo != other.foo) {
                return false;
            }
            if (this.bar != other.bar) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.foo;
            hashCode = 31 * hashCode + this.bar;
            return hashCode;
        }

        public TestCommonStruct duplicate() {
            TestCommonStruct _duplicate = new TestCommonStruct();
            _duplicate.foo = this.foo;
            _duplicate.bar = this.bar;
            return _duplicate;
        }

        public String toString() {
            return "TestCommonStruct(foo=" + this.foo + ", bar=" + this.bar + ")";
        }

        public int foo() {
            return this.foo;
        }

        public int bar() {
            return this.bar;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TestCommonStruct setFoo(int v) {
            this.foo = v;
            return this;
        }

        public TestCommonStruct setBar(int v) {
            this.bar = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field[]{new Field("foo", (Type)Type.INT32, ""), new Field("bar", (Type)Type.INT32, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class TaggedStruct
    implements Message {
        String structId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("struct_id", (Type)Type.COMPACT_STRING, "String field in struct"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TaggedStruct(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaggedStruct(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public TaggedStruct() {
            this.structId = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TaggedStruct");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field structId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field structId had invalid length " + length);
            }
            this.structId = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TaggedStruct");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.structId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TaggedStruct");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.structId = struct.getString("struct_id");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TaggedStruct");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("struct_id", (Object)this.structId);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TaggedStruct");
            }
            byte[] _stringBytes = this.structId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'structId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.structId, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaggedStruct)) {
                return false;
            }
            TaggedStruct other = (TaggedStruct)obj;
            if (this.structId == null ? other.structId != null : !this.structId.equals(other.structId)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.structId == null ? 0 : this.structId.hashCode());
            return hashCode;
        }

        public TaggedStruct duplicate() {
            TaggedStruct _duplicate = new TaggedStruct();
            _duplicate.structId = this.structId;
            return _duplicate;
        }

        public String toString() {
            return "TaggedStruct(structId=" + (this.structId == null ? "null" : "'" + this.structId.toString() + "'") + ")";
        }

        public String structId() {
            return this.structId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaggedStruct setStructId(String v) {
            this.structId = v;
            return this;
        }
    }

    public static class StructArray
    implements Message {
        int arrayFieldId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("array_field_id", (Type)Type.INT32, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public StructArray(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public StructArray(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public StructArray() {
            this.arrayFieldId = 0;
        }

        public short lowestSupportedVersion() {
            return 2;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StructArray");
            }
            this.arrayFieldId = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.arrayFieldId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StructArray");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.arrayFieldId = struct.getInt("array_field_id");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StructArray");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("array_field_id", (Object)this.arrayFieldId);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of StructArray");
            }
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StructArray)) {
                return false;
            }
            StructArray other = (StructArray)obj;
            if (this.arrayFieldId != other.arrayFieldId) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.arrayFieldId;
            return hashCode;
        }

        public StructArray duplicate() {
            StructArray _duplicate = new StructArray();
            _duplicate.arrayFieldId = this.arrayFieldId;
            return _duplicate;
        }

        public String toString() {
            return "StructArray(arrayFieldId=" + this.arrayFieldId + ")";
        }

        public int arrayFieldId() {
            return this.arrayFieldId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StructArray setArrayFieldId(int v) {
            this.arrayFieldId = v;
            return this;
        }
    }

    public static class MyStruct
    implements Message {
        int structId;
        List<StructArray> arrayInStruct;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("struct_id", (Type)Type.INT32, "Int field in struct"), new Field("array_in_struct", (Type)new CompactArrayOf((Type)StructArray.SCHEMA_2), ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public MyStruct(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MyStruct(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public MyStruct() {
            this.structId = 0;
            this.arrayInStruct = new ArrayList<StructArray>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MyStruct");
            }
            this.structId = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field arrayInStruct was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<StructArray> newCollection = new ArrayList<StructArray>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new StructArray(_readable, _version));
            }
            this.arrayInStruct = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MyStruct");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.structId);
            _writable.writeUnsignedVarint(this.arrayInStruct.size() + 1);
            for (StructArray arrayInStructElement : this.arrayInStruct) {
                arrayInStructElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MyStruct");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.structId = struct.getInt("struct_id");
            Object[] _nestedObjects = struct.getArray("array_in_struct");
            this.arrayInStruct = new ArrayList<StructArray>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.arrayInStruct.add(new StructArray((Struct)nestedObject, _version));
            }
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MyStruct");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("struct_id", (Object)this.structId);
            Struct[] _nestedObjects = new Struct[this.arrayInStruct.size()];
            int i = 0;
            for (StructArray element : this.arrayInStruct) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("array_in_struct", (Object)_nestedObjects);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MyStruct");
            }
            _size += 4;
            int _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.arrayInStruct.size() + 1));
            for (StructArray arrayInStructElement : this.arrayInStruct) {
                _arraySize += arrayInStructElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyStruct)) {
                return false;
            }
            MyStruct other = (MyStruct)obj;
            if (this.structId != other.structId) {
                return false;
            }
            if (this.arrayInStruct == null ? other.arrayInStruct != null : !this.arrayInStruct.equals(other.arrayInStruct)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.structId;
            hashCode = 31 * hashCode + (this.arrayInStruct == null ? 0 : this.arrayInStruct.hashCode());
            return hashCode;
        }

        public MyStruct duplicate() {
            MyStruct _duplicate = new MyStruct();
            _duplicate.structId = this.structId;
            ArrayList<StructArray> newArrayInStruct = new ArrayList<StructArray>(this.arrayInStruct.size());
            for (StructArray _element : this.arrayInStruct) {
                newArrayInStruct.add(_element.duplicate());
            }
            _duplicate.arrayInStruct = newArrayInStruct;
            return _duplicate;
        }

        public String toString() {
            return "MyStruct(structId=" + this.structId + ", arrayInStruct=" + MessageUtil.deepToString(this.arrayInStruct.iterator()) + ")";
        }

        public int structId() {
            return this.structId;
        }

        public List<StructArray> arrayInStruct() {
            return this.arrayInStruct;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MyStruct setStructId(int v) {
            this.structId = v;
            return this;
        }

        public MyStruct setArrayInStruct(List<StructArray> v) {
            this.arrayInStruct = v;
            return this;
        }
    }
}

